package jp.co.sra.jun.opengl.objects.typical;

import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunOpenGL3dTypicalObjectsSpring class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsSpring.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsSpring extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - spring
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject Spring() {
		return SpringBy_radius_height_repeat_(10, 0.5, 1, 10);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param degree int
	 * @param radius double
	 * @param height height
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringBy_radius_height_(int degree, double radius, int height) {
		return SpringBy_radius_height_repeat_(degree, radius, height, height * 5);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param degree int
	 * @param radius double
	 * @param height height
	 * @param repeat int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringBy_radius_height_repeat_(int degree, double radius, int height, int repeat) {
		Jun3dPoint aVector = new Jun3dPoint(radius, 0, 0);
		double anIncrement = ((double) height) / Math.max(repeat, 1) / (360 / degree);
		Jun3dPoint aPoint = new Jun3dPoint(0, 0, 0);

		JunOpenGL3dCompoundObject aSpring = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < Math.max(repeat, 1); i++) {
			final Collection aCollection = new ArrayList();
			for (int angle = 0; angle < 360; angle = angle + degree) {
				Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(angle)).product_(Jun3dTransformation.Translate_(aPoint));
				Jun3dPoint aVertex = aVector.transform_(aTransformation);
				aPoint = aPoint.plus_(new Jun3dPoint(0, 0, anIncrement));
				aCollection.add(aVertex);
			}
			Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(360)).product_(Jun3dTransformation.Translate_(aPoint));
			Jun3dPoint aVertex = aVector.transform_(aTransformation);
			aCollection.add(aVertex);
			JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(aCollection);
			aSpring.add_(aPolyline);
		}
		aSpring.name_("spring");
		aSpring.paint_(DefaultPaint());
		return aSpring;
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringFrom_to_width_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor) {
		return From_to_height_depth_with_(fromPoint, toPoint, widthFactor, widthFactor, XUnitSpring());
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @param howMany int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringFrom_to_width_repeat_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor, int howMany) {
		return From_to_height_depth_with_(fromPoint, toPoint, widthFactor, widthFactor, SpringBy_radius_height_repeat_(10, 0.5, 1, howMany).transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90))));
	}

	/**
	 * Typical objects - spring
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject XUnitSpring() {
		return Spring().transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90)));
	}
}
