package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsCylinder class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsCylinder.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsCylinder extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical object - cylinder.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject Cylinder() {
		return JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, 10, 0.5, 1);
	}

	/**
	 * Typical object - cylinder with the specified degree.
	 * 
	 * @param degree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderBy_(double degree) {
		return JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, degree, 0.5, 1);
	}

	/**
	 * Typical object - cylinder with the specified degree and radius.
	 * 
	 * @param degree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderBy_radius_(double degree, double radius) {
		return JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, degree, radius, 1);
	}

	/**
	 * Typical object - cylinder with the specified degree, radius and height.
	 * 
	 * @param degree double
	 * @param radius double
	 * @param height double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderBy_radius_height_(double degree, double radius, double height) {
		return JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, degree, radius, height);
	}

	/**
	 * Typical object - cylinder with the specified from point, to point, radius and division.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aRadius double
	 * @param divisionNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderFrom_to_radius_by_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double aRadius, double divisionNumber) {
		JunOpenGL3dCompoundObject aCylinder = new JunOpenGL3dCompoundObject();
		Jun3dCircle fromCircle = new Jun3dCircle(fromPoint, aRadius, toPoint.to_(fromPoint).normalUnitVector());
		Jun3dPoint[] fromPoints = fromCircle.trackPointsBy_((int) Math.round(360.0 / divisionNumber));
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(fromPoints);
		aCylinder.add_(aPolygon);

		Jun3dPoint[] toPoints = new Jun3dPoint[fromPoints.length];
		Jun3dPoint[] reverseToPoints = new Jun3dPoint[fromPoints.length];
		for (int i = 0; i < toPoints.length; i++) {
			toPoints[i] = fromPoints[i].translatedBy_(toPoint.minus_(fromPoint));
			reverseToPoints[toPoints.length - 1 - i] = new Jun3dPoint(toPoints[i]);
		}
		aPolygon = new JunOpenGL3dPolygon(reverseToPoints);
		aPolygon.paint_(Color.red);
		aCylinder.add_(aPolygon);

		for (int i = 0; i < fromPoints.length - 1; i++) {
			Jun3dPoint p1 = fromPoints[i];
			Jun3dPoint p2 = fromPoints[i + 1];
			Jun3dPoint p3 = toPoints[i];
			Jun3dPoint p4 = toPoints[i + 1];
			Jun3dPoint[] points = new Jun3dPoint[] { p1, p3, p4, p2 };
			Jun3dPoint[] vectors = new Jun3dPoint[] { fromPoint.to_(p1).normalUnitVector(), toPoint.to_(p3).normalUnitVector(), toPoint.to_(p4).normalUnitVector(), fromPoint.to_(p2).normalUnitVector() };
			aPolygon = new JunOpenGL3dPolygon(points);
			aPolygon.normalVectors_(vectors);
			aCylinder.add_(aPolygon);
		}

		aCylinder.flushAllPaints();
		aCylinder.paint_(aCylinder.defaultPaint());
		return aCylinder;
	}

	/**
	 * Typical object - cylinder with the specified from point, to point and width factor.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderFrom_to_width_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor) {
		return From_to_height_depth_with_(fromPoint, toPoint, widthFactor, widthFactor, XUnitCylinder());
	}

	/**
	 * Typical object - cylinder with the specified from point, to point, width factor and degree.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderFrom_to_width_by_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor, double byDegree) {
		JunOpenGL3dObject aCylinder = JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(0, 360, byDegree, 0.5, 1);
		aCylinder = aCylinder.transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90)));
		aCylinder = From_to_height_depth_with_(fromPoint, toPoint, widthFactor, widthFactor, aCylinder);
		return aCylinder;
	}

	/**
	 * Typical object - xUnitCylinder.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject XUnitCylinder() {
		return Cylinder().transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90)));
	}
}
