package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsChemical class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsChemical.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsChemical extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - acetylcholine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Acetylcholine() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-3.2800   -1.1600    2.0531 C\n");
		buffer.append("-1.8350   -1.4552    1.7112 C\n");
		buffer.append("-1.3335   -0.5151    0.8623 O\n");
		buffer.append(" 0.0097   -0.7176    0.4443 C\n");
		buffer.append(" 0.4160    0.4217   -0.4937 C\n");
		buffer.append(" 1.8155    0.2627   -1.0872 N\n");
		buffer.append(" 2.0930    1.4823   -1.9553 C\n");
		buffer.append("-1.1989   -2.4011    2.1185 O\n");
		buffer.append(" 1.9124   -0.9771   -1.9611 C\n");
		buffer.append(" 2.8766    0.1924   -0.0023 C\n");
		buffer.append("-3.6707   -1.9184    2.7687 H\n");
		buffer.append("-3.9095   -1.1929    1.1350 H\n");
		buffer.append("-3.3742   -0.1559    2.5249 H\n");
		buffer.append(" 0.0613   -1.7012   -0.0736 H\n");
		buffer.append(" 0.6572   -0.7297    1.3506 H\n");
		buffer.append(" 0.3612    1.3817    0.0731 H\n");
		buffer.append("-0.3275    0.4881   -1.3233 H\n");
		buffer.append(" 3.1025    1.4204   -2.4211 H\n");
		buffer.append(" 2.0528    2.4165   -1.3507 H\n");
		buffer.append(" 1.3425    1.5648   -2.7738 H\n");
		buffer.append(" 2.9036   -1.0247   -2.4662 H\n");
		buffer.append(" 1.1238   -0.9689   -2.7471 H\n");
		buffer.append(" 1.8094   -1.9098   -1.3653 H\n");
		buffer.append(" 3.8957    0.1732   -0.4509 H\n");
		buffer.append(" 2.7741   -0.7306    0.6093 H\n");
		buffer.append(" 2.8110    1.0758    0.6722 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("acetylcholine");
		return compoundObject;
	}

	/**
	 * Typical objects - adrenaline
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Adrenaline() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-1.8847    0.9647    0.9048 C\n");
		buffer.append("-2.8496    0.0866    1.4070 C\n");
		buffer.append("-2.5680   -1.2837    1.4492 C\n");
		buffer.append("-1.3274   -1.7305    0.9876 C\n");
		buffer.append("-0.3732   -0.8418    0.4900 C\n");
		buffer.append("-0.6379    0.5305    0.4404 C\n");
		buffer.append(" 0.3468    1.5577   -0.0781 C\n");
		buffer.append(" 1.6634    1.0318   -0.6466 C\n");
		buffer.append(" 2.4615    2.1610   -1.1295 N\n");
		buffer.append(" 3.7743    1.7479   -1.6188 C\n");
		buffer.append("-4.0529    0.5327    1.8573 O\n");
		buffer.append("-3.4916   -2.1550    1.9353 O\n");
		buffer.append(" 0.6718    2.4743    0.9716 O\n");
		buffer.append("-2.1219    2.0408    0.8791 H\n");
		buffer.append("-1.0984   -2.8085    1.0194 H\n");
		buffer.append(" 0.5880   -1.2497    0.1428 H\n");
		buffer.append("-0.1655    2.1455   -0.8779 H\n");
		buffer.append(" 2.2298    0.4920    0.1485 H\n");
		buffer.append(" 1.4673    0.3390   -1.4983 H\n");
		buffer.append(" 1.9594    2.6261   -1.8869 H\n");
		buffer.append(" 4.3273    2.6458   -1.9770 H\n");
		buffer.append(" 4.3672    1.2700   -0.8062 H\n");
		buffer.append(" 3.6659    1.0400   -2.4715 H\n");
		buffer.append("-4.5379   -0.2537    2.1609 H\n");
		buffer.append("-3.1100   -3.0464    1.8911 H\n");
		buffer.append(" 1.4028    2.9838    0.6673 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("adrenaline");
		return compoundObject;
	}

	/**
	 * Typical objects - alanine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Alanine() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0002.2832 00002.2923 00001.055  N\n");
		buffer.append("-0002.3893 00002.6366 00002.013  H\n");
		buffer.append("-0000.9868 00002.7655 00000.516  C\n");
		buffer.append("-0000.8643 00002.3409 -0000.484  H\n");
		buffer.append("00000.1684 00002.3109 00001.379  C\n");
		buffer.append("00001.0354 00001.5757 00000.904  O\n");
		buffer.append("-0000.9936 00004.3095 00000.379  C\n");
		buffer.append("-0000.0479 00004.6483 -0000.046  H\n");
		buffer.append("-0001.8074 00004.6164 -0000.279  H\n");
		buffer.append("-0001.1326 00004.7772 00001.355  H\n");
		buffer.append("00000.2485 00002.6996 00002.674  O\n");
		buffer.append("-0002.2550 00001.2708 00001.106  H\n");
		buffer.append("00000.9611 00002.4209 00003.221  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("alanine");
		return compoundObject;
	}

	/**
	 * Typical objects - anthracene
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Anthracene() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0009.9531 00005.9919 -0000.002  C\n");
		buffer.append("-0009.9530 00007.3393 -0000.002  C\n");
		buffer.append("-0008.7799 00007.9978 -0000.003  C\n");
		buffer.append("-0007.6072 00007.3388 -0000.002  C\n");
		buffer.append("-0007.6074 00005.9916 -0000.001  C\n");
		buffer.append("-0008.7803 00005.3330 -0000.003  C\n");
		buffer.append("-0011.1240 00005.3278 -0000.000  C\n");
		buffer.append("-0011.1239 00008.0031 00000.000  C\n");
		buffer.append("-0008.7794 00009.1021 -0000.003  H\n");
		buffer.append("-0006.4360 00008.0020 00000.000  C\n");
		buffer.append("-0006.4367 00005.3276 00000.001  C\n");
		buffer.append("-0008.7801 00004.2286 -0000.003  H\n");
		buffer.append("-0005.2721 00007.3347 00000.004  C\n");
		buffer.append("-0005.2724 00005.9942 00000.005  C\n");
		buffer.append("-0006.4087 00009.1060 00000.000  H\n");
		buffer.append("-0006.4102 00004.2237 00000.002  H\n");
		buffer.append("-0004.3158 00007.8860 00000.007  H\n");
		buffer.append("-0004.3165 00005.4422 00000.009  H\n");
		buffer.append("-0012.2881 00007.3358 00000.003  C\n");
		buffer.append("-0012.2881 00005.9951 00000.002  C\n");
		buffer.append("-0011.1511 00004.2237 -0000.000  H\n");
		buffer.append("-0011.1512 00009.1072 00000.001  H\n");
		buffer.append("-0013.2446 00007.8873 00000.006  H\n");
		buffer.append("-0013.2446 00005.4435 00000.005  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("anthracene");
		return compoundObject;
	}

	/**
	 * Typical objects - benzene
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Benzene() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-1.1604   -0.6711   -0.0756 C\n");
		buffer.append("-1.1621    0.6709   -0.0461 C\n");
		buffer.append("-0.0019    1.3422    0.0296 C\n");
		buffer.append(" 1.1596    0.6708    0.0756 C\n");
		buffer.append(" 1.1615   -0.6712    0.0461 C\n");
		buffer.append(" 0.0012   -1.3423   -0.0296 C\n");
		buffer.append("-2.1144   -1.2230   -0.1378 H\n");
		buffer.append("-2.1172    1.2228   -0.0839 H\n");
		buffer.append("-0.0032    2.4459    0.0539 H\n");
		buffer.append(" 2.1138    1.2225    0.1378 H\n");
		buffer.append(" 2.1172   -1.2230    0.0840 H\n");
		buffer.append(" 0.0024   -2.4459   -0.0539 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("benzene");
		return compoundObject;
	}

	/**
	 * Typical objects - capsaicin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Capsaicin() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-5.6100    2.6214    1.7323 C\n");
		buffer.append("-6.0580    1.7836    2.7766 C\n");
		buffer.append("-5.1541    1.3576    3.7594 C\n");
		buffer.append("-3.8246    1.7533    3.6951 C\n");
		buffer.append("-3.3771    2.5746    2.6602 C\n");
		buffer.append("-4.2709    3.0142    1.6828 C\n");
		buffer.append("-1.9410    2.9917    2.5982 C\n");
		buffer.append("-1.1742    2.0360    1.7638 N\n");
		buffer.append(" 0.2052    2.2097    1.5174 C\n");
		buffer.append(" 0.8258    1.2653    0.5058 C\n");
		buffer.append(" 2.3178    1.4867    0.3251 C\n");
		buffer.append(" 2.8906    0.5151   -0.6952 C\n");
		buffer.append(" 4.3862    0.7309   -0.8771 C\n");
		buffer.append(" 4.9367   -0.1986   -1.9012 C\n");
		buffer.append(" 6.0025   -0.9663   -1.6749 C\n");
		buffer.append(" 6.6158   -1.9215   -2.6485 C\n");
		buffer.append(" 8.1077   -1.6352   -2.7630 C\n");
		buffer.append("-6.4360    2.9800    0.6720 O\n");
		buffer.append("-7.3772    1.4300    2.7876 O\n");
		buffer.append(" 0.8049    3.0643    2.1559 O\n");
		buffer.append(" 5.9800   -1.9162   -4.0281 C\n");
		buffer.append("-7.2800    4.0747    0.9547 C\n");
		buffer.append("-5.4876    0.7100    4.5792 H\n");
		buffer.append("-3.1220    1.4167    4.4667 H\n");
		buffer.append("-3.9253    3.6679    0.8719 H\n");
		buffer.append("-1.4844    3.0118    3.6092 H\n");
		buffer.append("-1.8482    4.0219    2.1932 H\n");
		buffer.append("-1.6945    1.4708    1.1295 H\n");
		buffer.append(" 0.3085    1.3848   -0.4685 H\n");
		buffer.append(" 0.6376    0.2185    0.8226 H\n");
		buffer.append(" 2.8391    1.3717    1.2966 H\n");
		buffer.append(" 2.5118    2.5310    0.0078 H\n");
		buffer.append(" 2.3695    0.6318   -1.6669 H\n");
		buffer.append(" 2.6980   -0.5292   -0.3782 H\n");
		buffer.append(" 4.9063    0.6169    0.0959 H\n");
		buffer.append(" 4.5860    1.7722   -1.2030 H\n");
		buffer.append(" 4.4109   -0.2093   -2.8649 H\n");
		buffer.append(" 6.5079   -0.9313   -0.6992 H\n");
		buffer.append(" 6.4804   -2.9417   -2.2086 H\n");
		buffer.append(" 8.6046   -2.3706   -3.4092 H\n");
		buffer.append(" 8.6021   -1.6698   -1.7833 H\n");
		buffer.append(" 8.2948   -0.6416   -3.1912 H\n");
		buffer.append("-7.5152    0.8518    3.5282 H\n");
		buffer.append(" 6.4697   -2.6459   -4.6868 H\n");
		buffer.append(" 6.0609   -0.9336   -4.5125 H\n");
		buffer.append(" 4.9144   -2.1783   -3.9858 H\n");
		buffer.append("-7.8300    4.1997    0.0186 H\n");
		buffer.append("-6.7080    4.9812    1.1820 H\n");
		buffer.append("-7.9744    3.8645    1.7757 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("capsaicin");
		return compoundObject;
	}

	/**
	 * Typical objects - catechin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Catechin() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0007.0207 00001.8582 00001.407  C\n");
		buffer.append("-0008.1286 00002.1358 00000.587  C\n");
		buffer.append("-0008.0365 00003.0804 -0000.448  C\n");
		buffer.append("-0006.8251 00003.7607 -0000.656  C\n");
		buffer.append("-0005.7151 00003.4933 00000.162  C\n");
		buffer.append("-0005.7952 00002.5212 00001.181  C\n");
		buffer.append("-0004.5804 00002.2655 00002.051  C\n");
		buffer.append("-0003.2675 00002.7127 00001.354  C\n");
		buffer.append("-0003.4573 00004.1469 00000.783  C\n");
		buffer.append("-0004.5591 00004.1653 -0000.078  O\n");
		buffer.append("-0007.1991 00000.9468 00002.398  O\n");
		buffer.append("-0009.0378 00001.6328 00000.752  H\n");
		buffer.append("-0009.1212 00003.3233 -0001.222  O\n");
		buffer.append("-0006.7470 00004.4738 -0001.425  H\n");
		buffer.append("-0004.4986 00001.1999 00002.274  H\n");
		buffer.append("-0004.7009 00002.8143 00002.988  H\n");
		buffer.append("-0003.0542 00002.0165 00000.538  H\n");
		buffer.append("-0002.2024 00002.6538 00002.317  O\n");
		buffer.append("-0002.2299 00004.6255 00000.035  C\n");
		buffer.append("-0003.6662 00004.8301 00001.612  H\n");
		buffer.append("-0001.3545 00005.5529 00000.630  C\n");
		buffer.append("-0000.1934 00005.9671 -0000.042  C\n");
		buffer.append("00000.1121 00005.4550 -0001.314  C\n");
		buffer.append("-0000.7540 00004.5208 -0001.914  C\n");
		buffer.append("-0001.9162 00004.1088 -0001.236  C\n");
		buffer.append("-0001.3665 00002.7804 00001.821  H\n");
		buffer.append("-0001.5611 00005.9381 00001.586  H\n");
		buffer.append("00000.4520 00006.6603 00000.413  H\n");
		buffer.append("00001.2458 00005.8775 -0001.927  O\n");
		buffer.append("-0000.4615 00004.0187 -0003.140  O\n");
		buffer.append("-0002.5546 00003.4042 -0001.686  H\n");
		buffer.append("-0006.5278 00000.7322 00003.017  H\n");
		buffer.append("-0009.0960 00003.9534 -0001.920  H\n");
		buffer.append("00001.4990 00005.5620 -0002.776  H\n");
		buffer.append("-0001.0241 00003.3954 -0003.564  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("catechin");
		return compoundObject;
	}

	/**
	 * Typical objects - chloroform
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Chloroform() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0000.8761 00000.0739 -0000.398  C\n");
		buffer.append("-0000.8728 00001.8325 -0000.757  Cl\n");
		buffer.append("00000.7559 -0000.5151 00000.060  Cl\n");
		buffer.append("-0002.1089 -0000.3518 00000.834  Cl\n");
		buffer.append("-0001.1599 -0000.4503 -0001.338  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("chloroform");
		return compoundObject;
	}

	/**
	 * Typical objects - compound object from the specified string.
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category Typical objects chemical
	 */
	protected static JunOpenGL3dCompoundObject CompoundFromString_(String aString) {
		String[][] tokens = null;
		try {
			tokens = JunStringUtility.GetTokensFromString_(aString);
		} catch (IOException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
			return null;
		}

		Collection aCollection = new ArrayList();
		for (int i = 0; i < tokens.length; i++) {
			String[] anArray = tokens[i];
			if (anArray != null && anArray.length > 0) {
				String aName = anArray[3];
				final Jun3dPoint aCenter = new Jun3dPoint(Double.parseDouble(anArray[0]), Double.parseDouble(anArray[1]), Double.parseDouble(anArray[2]));
				double aRadius = Double.NaN;
				Color aColor = null;
				if (aName.equals("C")) {
					aRadius = 1.7;
					aColor = StColorValue.Blend(Color.blue, Color.white);
				} else if (aName.equals("H")) {
					aRadius = 1.2;
					aColor = StColorValue.Blend(Color.green, Color.white);
				} else if (aName.equals("O")) {
					aRadius = 1.52;
					aColor = StColorValue.Blend(Color.red, Color.white);
				} else if (aName.equals("N")) {
					aRadius = 1.55;
					aColor = StColorValue.Blend(Color.cyan, Color.white);
				} else if (aName.equals("P")) {
					aRadius = 1.8;
					aColor = StColorValue.Blend(Color.magenta, Color.white);
				} else if (aName.equals("S")) {
					aRadius = 1.8;
					aColor = StColorValue.Blend(Color.yellow, Color.white);
				} else if (aName.equals("Cl")) {
					aRadius = 1.75;
					aColor = StColorValue.Blend(StColorValue.DarkGreen, Color.white);
				} else if (Double.isNaN(aRadius) || aColor == null) {
					aRadius = 1.0;
					aColor = StColorValue.Blend(Color.gray, Color.white);
				}

				Jun3dBoundingBall aBall = new Jun3dBoundingBall(aCenter, aRadius);
				JunOpenGL3dObject anAtom = JunOpenGL3dObject.Ball_radius_center_(2, aRadius, aCenter);
				final Color color = aColor;
				anAtom.objectsDo_(new StBlockClosure() {
					public Object value_(Object each) {
						((JunOpenGL3dObject) each).paint_(color);
						return null;
					}
				});
				anAtom.polygonsDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dPolygon each = ((JunOpenGL3dPolygon) obj);
						Jun3dPoint[] points = each.vertexes();
						Jun3dPoint[] normalVectors = new Jun3dPoint[points.length];
						for (int i = 0; i < points.length; i++) {
							normalVectors[i] = aCenter.to_(points[i]).normalUnitVector();
						}
						each.normalVectors_(normalVectors);
						return null;
					}
				});
				anAtom.name_(aName);
				aCollection.add(new StAssociation(aBall, anAtom));
			}
		}

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		StAssociation[] associations = (StAssociation[]) aCollection.toArray(new StAssociation[aCollection.size()]);
		for (int i = 0; i < associations.length; i++) {
			final Jun3dBoundingBall[] ballCollection = new Jun3dBoundingBall[associations.length - 1];
			int position = 0;
			for (int j = 0; j < associations.length; j++) {
				Jun3dBoundingBall aBall = (Jun3dBoundingBall) associations[j].key();
				if (aBall != associations[i].key()) {
					ballCollection[position] = aBall;
					position++;
				}
			}
			final JunOpenGL3dCompoundObject atomBody = new JunOpenGL3dCompoundObject();
			atomBody.name_(((JunOpenGL3dObject) associations[i].value()).name());
			((JunOpenGL3dObject) associations[i].value()).polygonsDo_(new StBlockClosure() {
				public Object value_(Object each) {
					JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) each;
					Jun3dPoint[] points = polygon.vertexes();
					boolean isEmpty = true;
					for (int j = 0; j < ballCollection.length; j++) {
						int containsPointCount = 0;
						for (int k = 0; k < points.length; k++) {
							if (ballCollection[j].containsPoint_(points[k])) {
								containsPointCount++;
							}
						}
						if (containsPointCount == points.length) {
							isEmpty = false;
							break;
						}
					}
					if (isEmpty) {
						atomBody.add_(polygon);
					}
					return null;
				}
			});
			compoundObject.add_(atomBody);
		}
		compoundObject.name_("compound");
		return compoundObject;
	}

	/**
	 * Typical objects - cystine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Cystine() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0002.6026 00001.5856 00001.799  N\n");
		buffer.append("-0002.9073 00001.9233 00002.712  H\n");
		buffer.append("-0001.2575 00002.0210 00001.519  C\n");
		buffer.append("-0000.9636 00001.5371 00000.557  H\n");
		buffer.append("-0000.3197 00001.4877 00002.585  C\n");
		buffer.append("00000.2185 00000.4075 00002.581  O\n");
		buffer.append("-0001.2589 00003.5485 00001.333  C\n");
		buffer.append("-0001.9803 00003.8243 00000.529  H\n");
		buffer.append("-0001.6008 00004.0552 00002.265  H\n");
		buffer.append("00000.4195 00004.1076 00000.872  S\n");
		buffer.append("00000.1444 00005.4184 00000.743  H\n");
		buffer.append("-0000.1912 00002.3390 00003.601  O\n");
		buffer.append("-0002.6334 00000.5687 00001.877  H\n");
		buffer.append("00000.3982 00001.9103 00004.244  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("cystine");
		return compoundObject;
	}

	/**
	 * Typical objects - dopamine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Dopamine() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-1.9351    0.0120    0.8693 C\n");
		buffer.append("-1.4577   -1.0645    1.6274 C\n");
		buffer.append("-0.0781   -1.2213    1.7854 C\n");
		buffer.append(" 0.8214   -0.3223    1.2118 C\n");
		buffer.append(" 0.3591    0.7576    0.4540 C\n");
		buffer.append("-1.0227    0.9030    0.2954 C\n");
		buffer.append(" 1.3290    1.7376   -0.1664 C\n");
		buffer.append(" 2.1069    1.1083   -1.3293 C\n");
		buffer.append(" 3.0281    2.0864   -1.9300 N\n");
		buffer.append("-2.3304   -1.9421    2.1904 O\n");
		buffer.append("-3.2767    0.1689    0.7093 O\n");
		buffer.append(" 0.3049   -2.0686    2.3775 H\n");
		buffer.append(" 1.9034   -0.4679    1.3602 H\n");
		buffer.append("-1.4165    1.7442   -0.2978 H\n");
		buffer.append(" 2.0375    2.0893    0.6200 H\n");
		buffer.append(" 0.7880    2.6415   -0.5318 H\n");
		buffer.append(" 1.4078    0.7468   -2.1192 H\n");
		buffer.append(" 2.7124    0.2415   -0.9767 H\n");
		buffer.append(" 3.6047    1.6485   -2.6482 H\n");
		buffer.append(" 3.6803    2.4479   -1.2345 H\n");
		buffer.append("-1.8125   -2.6281    2.6413 H\n");
		buffer.append("-3.6964   -0.5592    1.1985 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("dopamine");
		return compoundObject;
	}

	/**
	 * Typical objects - luminol
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Luminol() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(" 0.0550   -1.1096   -0.2102 C\n");
		buffer.append(" 0.0644    0.2928   -0.3272 C\n");
		buffer.append("-1.1553    0.9823   -0.4814 C\n");
		buffer.append("-2.3672    0.2587   -0.4503 C\n");
		buffer.append("-2.3530   -1.1152   -0.3169 C\n");
		buffer.append("-1.1444   -1.8083   -0.2079 C\n");
		buffer.append(" 1.3345   -1.8509   -0.0836 C\n");
		buffer.append(" 2.5551   -1.1200   -0.2237 N\n");
		buffer.append(" 2.5339    0.3012    0.0280 N\n");
		buffer.append(" 1.3435    1.0253   -0.2575 C\n");
		buffer.append(" 1.4557   -3.0576    0.0598 O\n");
		buffer.append(" 1.4718    2.2454   -0.3410 O\n");
		buffer.append("-1.1838    2.3649   -0.7693 N\n");
		buffer.append("-3.3246    0.7874   -0.5385 H\n");
		buffer.append("-3.2960   -1.6732   -0.3008 H\n");
		buffer.append("-1.1447   -2.9019   -0.1179 H\n");
		buffer.append(" 3.3937   -1.5522    0.1040 H\n");
		buffer.append(" 3.4077    0.7430   -0.1681 H\n");
		buffer.append("-0.3064    2.8181   -0.5748 H\n");
		buffer.append("-1.9711    2.8279   -0.3790 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("luminol");
		return compoundObject;
	}

	/**
	 * Typical objects - melatonin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Melatonin() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-2.7056   -1.9840    1.7098 C\n");
		buffer.append("-3.2980   -0.7404    1.6910 C\n");
		buffer.append("-2.6216    0.4342    1.2305 C\n");
		buffer.append("-1.3161    0.2911    0.7895 C\n");
		buffer.append("-0.6628   -0.9700    0.7897 C\n");
		buffer.append("-1.3705   -2.0868    1.2506 C\n");
		buffer.append("-0.5433   -3.1822    1.1577 N\n");
		buffer.append(" 0.6719   -2.7754    0.6469 C\n");
		buffer.append(" 0.6431   -1.4207    0.4056 C\n");
		buffer.append(" 1.8257   -0.6775   -0.1560 C\n");
		buffer.append(" 1.6792    0.8300   -0.3834 C\n");
		buffer.append(" 2.9290    1.3649   -0.9305 N\n");
		buffer.append(" 3.0571    2.6947   -1.2234 C\n");
		buffer.append(" 4.4127    3.0788   -1.7803 C\n");
		buffer.append(" 2.1673    3.4944   -1.0532 O\n");
		buffer.append("-3.1772    1.6900    1.1964 O\n");
		buffer.append("-4.5089    1.8505    1.6437 C\n");
		buffer.append("-3.2443   -2.8747    2.0682 H\n");
		buffer.append("-4.3364   -0.6850    2.0527 H\n");
		buffer.append("-0.7969    1.1919    0.4362 H\n");
		buffer.append("-0.7980   -4.1587    1.4303 H\n");
		buffer.append(" 1.4876   -3.4884    0.4872 H\n");
		buffer.append(" 2.6844   -0.8502    0.5365 H\n");
		buffer.append(" 2.0880   -1.1594   -1.1285 H\n");
		buffer.append(" 0.8591    1.0240   -1.1139 H\n");
		buffer.append(" 1.4680    1.3397    0.5858 H\n");
		buffer.append(" 3.7086    0.7445   -1.0945 H\n");
		buffer.append(" 4.4586    4.1695   -1.9994 H\n");
		buffer.append(" 5.2125    2.8369   -1.0442 H\n");
		buffer.append(" 4.6100    2.5245   -2.7258 H\n");
		buffer.append("-4.7748    2.9263    1.5392 H\n");
		buffer.append("-5.2032    1.2558    1.0094 H\n");
		buffer.append("-4.5909    1.5732    2.7182 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("melatonin");
		return compoundObject;
	}

	/**
	 * Typical objects - methane
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Methane() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(" -1.2639 0.5973  0.000  C\n");
		buffer.append(" -1.2639 1.7103 -0.000  H\n");
		buffer.append(" -0.2146 0.2263 -0.000  H\n");
		buffer.append(" -1.7886 0.2263  0.908  H\n");
		buffer.append(" -1.7886 0.2262 -0.908  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("methane");
		return compoundObject;
	}

	/**
	 * Typical objects - naphthalene
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Naphthalene() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0010.1558 00005.9261 -0000.000  C\n");
		buffer.append("-0010.1558 00007.2668 -0000.000  C\n");
		buffer.append("-0008.9919 00007.9344 -0000.000  C\n");
		buffer.append("-0007.8209 00007.2711 -0000.000  C\n");
		buffer.append("-0007.8209 00005.9221 00000.000  C\n");
		buffer.append("-0008.9918 00005.2585 00000.000  C\n");
		buffer.append("-0011.1120 00005.3741 -0000.000  H\n");
		buffer.append("-0011.1121 00007.8187 -0000.000  H\n");
		buffer.append("-0009.0182 00009.0383 -0000.000  H\n");
		buffer.append("-0006.6500 00007.9345 -0000.000  C\n");
		buffer.append("-0006.6499 00005.2586 00000.000  C\n");
		buffer.append("-0009.0180 00004.1546 00000.000  H\n");
		buffer.append("-0005.4861 00007.2670 -0000.000  C\n");
		buffer.append("-0005.4860 00005.9263 00000.000  C\n");
		buffer.append("-0006.6239 00009.0383 -0000.000  H\n");
		buffer.append("-0006.6238 00004.1547 00000.001  H\n");
		buffer.append("-0004.5299 00007.8189 -0000.000  H\n");
		buffer.append("-0004.5298 00005.3743 00000.000  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("naphthalene");
		return compoundObject;
	}

	/**
	 * Typical objects - serotonin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Serotonin() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-2.0643   -1.7321    2.0735 C\n");
		buffer.append("-0.8413   -2.3669    2.0400 C\n");
		buffer.append(" 0.2035   -1.7286    1.3277 C\n");
		buffer.append("-0.0055   -0.5044    0.6855 C\n");
		buffer.append("-1.2735    0.1279    0.7370 C\n");
		buffer.append("-2.3034   -0.4808    1.4283 C\n");
		buffer.append(" 1.5156   -2.0866    1.1044 N\n");
		buffer.append(" 2.1281   -1.1118    0.3351 C\n");
		buffer.append(" 1.2184   -0.1194    0.0567 C\n");
		buffer.append(" 1.4312    1.1303   -0.7487 C\n");
		buffer.append(" 2.8507    1.2863   -1.3070 C\n");
		buffer.append(" 2.9677    2.5224   -2.0972 N\n");
		buffer.append("-3.5275    0.1090    1.4906 O\n");
		buffer.append("-2.8941   -2.2091    2.6211 H\n");
		buffer.append("-0.6753   -3.3316    2.5430 H\n");
		buffer.append("-1.4333    1.0927    0.2314 H\n");
		buffer.append(" 1.9719   -2.9577    1.4595 H\n");
		buffer.append(" 3.1781   -1.2045    0.0413 H\n");
		buffer.append(" 1.1900    2.0059   -0.1008 H\n");
		buffer.append(" 0.7013    1.1233   -1.5926 H\n");
		buffer.append(" 3.1147    0.4263   -1.9659 H\n");
		buffer.append(" 3.5929    1.3404   -0.4765 H\n");
		buffer.append(" 3.9257    2.6560   -2.4202 H\n");
		buffer.append(" 2.7511    3.3410   -1.5292 H\n");
		buffer.append("-3.4794    0.9436    0.9955 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("serotonin");
		return compoundObject;
	}

	/**
	 * Typical objects - tryptophan
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Tryptophan() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0002.3570 00000.8018 00001.257  N\n");
		buffer.append("-0002.9089 00001.3879 00001.881  H\n");
		buffer.append("-0001.0050 00001.2860 00001.142  C\n");
		buffer.append("-0000.6046 00000.8179 00000.211  H\n");
		buffer.append("-0000.1153 00000.7372 00002.239  C\n");
		buffer.append("-0000.1772 -0000.3712 00002.713  O\n");
		buffer.append("-0000.9992 00002.8086 00000.954  C\n");
		buffer.append("00000.0114 00003.1129 00000.592  H\n");
		buffer.append("-0001.7048 00003.0643 00000.129  H\n");
		buffer.append("-0001.3369 00003.7159 00002.107  C\n");
		buffer.append("-0001.1998 00005.1075 00002.037  C\n");
		buffer.append("-0000.8534 00005.7258 00001.193  H\n");
		buffer.append("-0001.8092 00003.4954 00003.406  C\n");
		buffer.append("-0001.5426 00005.6340 00003.139  N\n");
		buffer.append("-0001.5249 00006.6626 00003.328  H\n");
		buffer.append("-0001.9090 00004.7637 00003.985  C\n");
		buffer.append("-0002.1597 00002.3728 00004.153  C\n");
		buffer.append("-0002.0989 00001.3533 00003.750  H\n");
		buffer.append("-0002.3494 00004.9552 00005.291  C\n");
		buffer.append("-0002.4178 00005.9665 00005.725  H\n");
		buffer.append("-0002.6068 00002.5499 00005.467  C\n");
		buffer.append("-0002.8886 00001.6688 00006.068  H\n");
		buffer.append("-0002.7027 00003.8253 00006.033  C\n");
		buffer.append("-0003.0583 00003.9415 00007.070  H\n");
		buffer.append("00000.7976 00001.6238 00002.631  O\n");
		buffer.append("-0002.3726 -0000.1257 00001.680  H\n");
		buffer.append("00001.3284 00001.1886 00003.319  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("tryptophan");
		return compoundObject;
	}

	/**
	 * Typical objects - tyrosine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Tyrosine() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0003.9770 00001.0414 00004.346  N\n");
		buffer.append("-0004.1081 00001.4803 00005.257  H\n");
		buffer.append("-0002.7061 00001.4126 00003.778  C\n");
		buffer.append("-0002.6033 00000.8446 00002.823  H\n");
		buffer.append("-0001.5710 00000.9848 00004.685  C\n");
		buffer.append("-0000.7041 00000.1865 00004.426  O\n");
		buffer.append("-0002.6921 00002.9180 00003.469  C\n");
		buffer.append("-0003.5584 00003.1795 00002.817  H\n");
		buffer.append("-0002.8243 00003.5092 00004.406  H\n");
		buffer.append("-0001.4124 00003.3190 00002.771  C\n");
		buffer.append("-0000.3360 00003.8611 00003.480  C\n");
		buffer.append("-0000.4118 00004.0052 00004.571  H\n");
		buffer.append("-0001.2722 00003.1536 00001.390  C\n");
		buffer.append("-0002.1025 00002.7271 00000.803  H\n");
		buffer.append("00000.8445 00004.2160 00002.826  C\n");
		buffer.append("00001.6819 00004.6344 00003.409  H\n");
		buffer.append("-0000.0906 00003.5140 00000.740  C\n");
		buffer.append("-0000.0060 00003.3703 -0000.348  H\n");
		buffer.append("00000.9906 00004.0503 00001.445  C\n");
		buffer.append("00002.1433 00004.3964 00000.814  O\n");
		buffer.append("00002.2310 00004.2630 -0000.113  H\n");
		buffer.append("-0001.6527 00001.5855 00005.872  O\n");
		buffer.append("-0004.0049 00000.0385 00004.530  H\n");
		buffer.append("-0000.9071 00001.2553 00006.401  H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("tyrosine");
		return compoundObject;
	}

	/**
	 * Typical objects - Water
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Water() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-0.4488   -0.3329   -0.0172 O\n");
		buffer.append("-0.4087    0.6082   -0.0097 H\n");
		buffer.append(" 0.4369   -0.6082    0.1470 H\n");

		JunOpenGL3dObject compoundObject = CompoundFromString_(buffer.toString());
		compoundObject.name_("water");
		return compoundObject;
	}
}
