package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject;

/**
 * JunOpenGL3dTypicalObjectsArrow class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsArrow.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsArrow extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - Arrow
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowFrom_to_(Jun3dPoint fromPoint, Jun3dPoint toPoint) {
		return ArrowFrom_to_color_(fromPoint, toPoint, DefaultPaint());
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param colorValue java.awt.Color
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowFrom_to_color_(Jun3dPoint fromPoint, Jun3dPoint toPoint, Color colorValue) {
		return ArrowFrom_to_color_lineWidth_(fromPoint, toPoint, colorValue, 1);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param colorValue java.awt.Color
	 * @param lineWidth float
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowFrom_to_color_lineWidth_(final Jun3dPoint fromPoint, final Jun3dPoint toPoint, final Color colorValue, final float lineWidth) {
		JunOpenGL3dCompoundObject arrowBody = (JunOpenGL3dCompoundObject) From_to_height_depth_with_(fromPoint, toPoint, (fromPoint.distance_(toPoint)), (fromPoint.distance_(toPoint)), XUnitArrow());
		arrowBody.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(colorValue);
				return null;
			}
		});
		arrowBody.name_("arrow");
		((JunOpenGL3dPolyline) arrowBody.components()[0]).lineWidth_(lineWidth);
		return arrowBody;
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowLine_(Jun3dLine aLine) {
		return ArrowFrom_to_(aLine.first(), aLine.last());
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @param colorValue java.awt.Color
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowLine_color_lineWidth_(Jun3dLine aLine, Color colorValue) {
		return ArrowFrom_to_color_(aLine.first(), aLine.last(), colorValue);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @param colorValue java.awt.Color
	 * @param lineWidth float
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowLine_color_lineWidth_(Jun3dLine aLine, Color colorValue, float lineWidth) {
		return ArrowFrom_to_color_lineWidth_(aLine.first(), aLine.last(), colorValue, lineWidth);
	}

	/**
	 * Typical objects - xArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XArrow() {
		JunOpenGL3dCompoundObject anArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		((JunOpenGL3dVertexesObject) anArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(-1, 0, 0), new Jun3dPoint(1, 0, 0) });
		anArrow.paint_(Color.red);
		anArrow.name_("x arrow");
		return anArrow;
	}

	/**
	 * Typical objects - xUnitArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XUnitArrow() {
		JunOpenGL3dPolyline xLine = new JunOpenGL3dPolyline(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0.9, 0, 0) });
		xLine.lineWidth_(1);

		JunOpenGL3dObject xArrow = JunOpenGL3dObject.ConeFrom_to_radius_by_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 2), 1, 45);
		xArrow = xArrow.transform_(Jun3dTransformation.Scale_(new Jun3dPoint(1.0 / 30, 1.0 / 30, 1.0 / 20)).product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90))));
		xArrow = xArrow.translatedBy_(new Jun3dPoint(0.9, 0, 0));

		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();
		aCompoundObject.add_(xLine);
		aCompoundObject.add_(xArrow);
		aCompoundObject.flushAllPaints();
		aCompoundObject.paint_(DefaultPaint());
		aCompoundObject.name_("x unit arrow");
		return aCompoundObject;
	}

	/**
	 * Typical objects - xyArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject xArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		((JunOpenGL3dPolyline) xArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(-1, 0, 0), new Jun3dPoint(1, 0, 0) });
		xArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		aCompoundObject.add_(xArrow);

		JunOpenGL3dCompoundObject yArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		((JunOpenGL3dPolyline) yArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 1, 0) });
		yArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.green);
				return null;
			}
		});
		aCompoundObject.add_(yArrow);

		aCompoundObject.name_("xy arrows");

		return aCompoundObject;
	}

	/**
	 * Typical objects - xyUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyUnitArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject xArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		xArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		aCompoundObject.add_(xArrow);

		JunOpenGL3dCompoundObject yArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		yArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.green);
				return null;
			}
		});
		aCompoundObject.add_(yArrow);

		aCompoundObject.name_("xy unit arrow");

		return aCompoundObject;
	}

	/**
	 * Typical objects - xyzArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyzArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject xArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		JunOpenGL3dPolyline xLine = (JunOpenGL3dPolyline) xArrow.components()[0];
		xLine.vertexes_(new Jun3dPoint[] { new Jun3dPoint(-1, 0, 0), new Jun3dPoint(1, 0, 0) });
		xArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		aCompoundObject.add_(xArrow);

		JunOpenGL3dCompoundObject yArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		JunOpenGL3dPolyline yLine = (JunOpenGL3dPolyline) yArrow.components()[0];
		yLine.vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 1, 0) });
		yArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.green);
				return null;
			}
		});
		aCompoundObject.add_(yArrow);

		JunOpenGL3dCompoundObject zArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		JunOpenGL3dPolyline zLine = (JunOpenGL3dPolyline) zArrow.components()[0];
		zLine.vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1) });
		zArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.blue);
				return null;
			}
		});
		aCompoundObject.add_(zArrow);

		aCompoundObject.name_("xyz unit arrow");

		return aCompoundObject;
	}

	/**
	 * Typical objects - xyzUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyzUnitArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject xArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		xArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		aCompoundObject.add_(xArrow);

		JunOpenGL3dCompoundObject yArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		yArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.green);
				return null;
			}
		});
		aCompoundObject.add_(yArrow);

		JunOpenGL3dCompoundObject zArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		zArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.blue);
				return null;
			}
		});
		aCompoundObject.add_(zArrow);

		aCompoundObject.name_("xyz unit arrows");

		return aCompoundObject;
	}

	/**
	 * Typical objects - yArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YArrow() {
		JunOpenGL3dCompoundObject anArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		((JunOpenGL3dVertexesObject) anArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 1, 0) });
		anArrow.paint_(Color.green);
		anArrow.name_("y arrow");
		return anArrow;
	}

	/**
	 * Typical objects - yUnitArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YUnitArrow() {
		JunOpenGL3dObject yUnitArrow = XUnitArrow().transform_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(90)));
		yUnitArrow.name_("y unit arrow");
		return yUnitArrow;
	}

	/**
	 * Typical objects - yzArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YzArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject yArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		((JunOpenGL3dPolyline) yArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 1, 0) });
		yArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.green);
				return null;
			}
		});
		aCompoundObject.add_(yArrow);

		JunOpenGL3dCompoundObject zArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		((JunOpenGL3dPolyline) zArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1) });
		zArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.blue);
				return null;
			}
		});
		aCompoundObject.add_(zArrow);

		aCompoundObject.name_("yz arrows");

		return aCompoundObject;
	}

	/**
	 * Typical objects - yzUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YzUnitArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject yArrow = (JunOpenGL3dCompoundObject) YUnitArrow();
		yArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.green);
				return null;
			}
		});
		aCompoundObject.add_(yArrow);

		JunOpenGL3dCompoundObject zArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		zArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.blue);
				return null;
			}
		});
		aCompoundObject.add_(zArrow);

		aCompoundObject.name_("yz unit arrow");

		return aCompoundObject;
	}

	/**
	 * Typical objects - zArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZArrow() {
		JunOpenGL3dCompoundObject anArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		((JunOpenGL3dVertexesObject) anArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1) });
		anArrow.paint_(Color.blue);
		anArrow.name_("z arrow");
		return anArrow;
	}

	/**
	 * Typical objects - zUnitArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZUnitArrow() {
		JunOpenGL3dObject zUnitArrow = XUnitArrow().transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(-90)));
		zUnitArrow.name_("z unit arrow");
		return zUnitArrow;
	}

	/**
	 * Typical objects - zxArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZxArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject zArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		((JunOpenGL3dPolyline) zArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1) });
		zArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.blue);
				return null;
			}
		});
		aCompoundObject.add_(zArrow);

		JunOpenGL3dCompoundObject xArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		((JunOpenGL3dPolyline) xArrow.components()[0]).vertexes_(new Jun3dPoint[] { new Jun3dPoint(-1, 0, 0), new Jun3dPoint(1, 0, 0) });
		xArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		aCompoundObject.add_(xArrow);

		aCompoundObject.name_("zx arrows");

		return aCompoundObject;
	}

	/**
	 * Typical objects - zxUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZxUnitArrows() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject zArrow = (JunOpenGL3dCompoundObject) ZUnitArrow();
		zArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.blue);
				return null;
			}
		});
		aCompoundObject.add_(zArrow);

		JunOpenGL3dCompoundObject xArrow = (JunOpenGL3dCompoundObject) XUnitArrow();
		xArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		aCompoundObject.add_(xArrow);

		aCompoundObject.name_("zx unit arrow");

		return aCompoundObject;
	}
}
