package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StObject;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationModel;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationPolyline;

/**
 * JunOpenGL3dTypicalObjects class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjects.java,v 8.6 2008/02/20 06:32:47 nisinaka Exp $
 */
public abstract class JunOpenGL3dTypicalObjects extends StObject {
	/**
	 * Answer the default image size to paint JunOpenGL3dObject.
	 * 
	 * @return int
	 * @category Defaults
	 */
	public static int DefaultImageSize() {
		return 128;
	}

	/**
	 * Answer the default color to paint <code>JunOpenGL3dObject</code>.
	 * 
	 * @return java.awt.Color
	 * @category Defaults
	 */
	public static Color DefaultPaint() {
		return JunOpenGL3dObject.DefaultPaint();
	}

	/**
	 * Answer the expanded bodies loops edges vertexes by the specified polygon.
	 * 
	 * @param aJunOpenGL3dCompoundObject jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @param aJunOpenGL3dPolygon jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 * @return java.util.Map
	 * @category Utilities
	 */
	public static Map ExpandedBodiesLoopsEdgesVertexes_by_(JunOpenGL3dCompoundObject aJunOpenGL3dCompoundObject, JunOpenGL3dPolygon aJunOpenGL3dPolygon) {
		return ExpandedBodiesLoopsEdgesVertexes_by_power_(aJunOpenGL3dCompoundObject, aJunOpenGL3dPolygon, 2.0d);
	}

	/**
	 * Answer the expanded bodies loops edges vertexes by the specified polygon, control point and power value.
	 * 
	 * @param aJunOpenGL3dCompoundObject jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @param aJunOpenGL3dPolygon jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 * @param powerValue double
	 * @return java.util.Map
	 * @category Utilities
	 */
	public static Map ExpandedBodiesLoopsEdgesVertexes_by_power_(JunOpenGL3dCompoundObject aJunOpenGL3dCompoundObject, JunOpenGL3dPolygon aJunOpenGL3dPolygon, double powerValue) {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		final JunOpenGL3dCompoundObject aCompoundObject = compoundObject;
		aJunOpenGL3dCompoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				aCompoundObject.add_((JunOpenGL3dObject) aPolygon);
				return null;
			}
		});

		JunOpenGL3dPolygon basePolygon = aJunOpenGL3dPolygon;
		Jun3dTransformation aTransformation = Jun3dTransformation.Translate_(basePolygon.averagePoint().negated());
		compoundObject = (JunOpenGL3dCompoundObject) compoundObject.transform_(aTransformation);
		basePolygon = (JunOpenGL3dPolygon) basePolygon.transform_(aTransformation);
		// compoundObject.showWithAxes().hiddenlinePresentation();

		aTransformation = Jun3dTransformation.AlignVector_withVector_(basePolygon.normalVector(), new Jun3dPoint(0, 0, 1));
		compoundObject = (JunOpenGL3dCompoundObject) compoundObject.transform_(aTransformation);
		basePolygon = (JunOpenGL3dPolygon) basePolygon.transform_(aTransformation);
		// compoundObject.showWithAxes().hiddenlinePresentation();

		Jun3dPoint firstPoint = basePolygon.vertexes()[0];
		JunAngle anAngle = new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(1, 0, 0)).angleWithLine_(new Jun3dPoint(0, 0, 0).to_(firstPoint));
		JunPlane xzPlane = new JunPlane(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1), new Jun3dPoint(1, 0, 0));
		if (xzPlane.whichSide_(firstPoint) >= 0) {
			aTransformation = Jun3dTransformation.RotateZ_(anAngle.negated());
		} else {
			aTransformation = Jun3dTransformation.RotateZ_(anAngle);
		}
		compoundObject = (JunOpenGL3dCompoundObject) compoundObject.transform_(aTransformation);
		basePolygon = (JunOpenGL3dPolygon) basePolygon.transform_(aTransformation);
		// compoundObject.showWithAxes().hiddenlinePresentation();

		JunGeometry.HashEqualitySet pointCollection = new JunGeometry.HashEqualitySet();
		pointCollection.addAll(compoundObject.asPointArray());
		final ArrayList polylineCollection = new ArrayList();
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				polylineCollection.add(((JunOpenGL3dPolygon) aPolygon).asArrayOfLines());
				return null;
			}
		});
		Jun3dLine[][] polylineArray = (Jun3dLine[][]) polylineCollection.toArray(new Jun3dLine[polylineCollection.size()][]);
		Jun3dPoint[] pointArray = (Jun3dPoint[]) pointCollection.toArray(new Jun3dPoint[pointCollection.size()]);
		Jun3dPoint basePoint = new Jun3dPoint(0, 0, compoundObject.boundingBox().origin().z() - 1.0);
		Object[][] assocCollection = new Object[pointArray.length][];
		for (int i = 0; i < pointArray.length; i++) {
			double distance = basePoint.distance_(pointArray[i]);
			assocCollection[i] = new Object[] { pointArray[i], new Double(distance) };
		}
		Arrays.sort(assocCollection, new Comparator() {
			public int compare(Object o1, Object o2) {
				double value1 = ((Number) ((Object[]) o1)[1]).doubleValue();
				double value2 = ((Number) ((Object[]) o2)[1]).doubleValue();
				return (value1 < value2) ? -1 : 1;
			}
		});

		Jun3dPoint[] vertexCollection = new Jun3dPoint[pointCollection.size()];
		ArrayList edgeCollection = new ArrayList(polylineCollection.size() * 3);
		Jun3dLine[][] loopCollection = new Jun3dLine[polylineCollection.size()][];
		for (int i = 0; i < assocCollection.length; i++) {
			Jun3dPoint point = (Jun3dPoint) assocCollection[i][0];
			double distance = ((Number) assocCollection[i][1]).doubleValue();
			distance = Math.pow(distance, powerValue);
			Jun3dPoint p1 = new Jun3dPoint(basePoint.x(), basePoint.y(), 0);
			Jun3dPoint p2 = new Jun3dPoint(point.x(), point.y(), 0);
			Jun3dPoint vertex = p1.equal_(p2) ? p1 : p1.to_(p2).normalized().atT_(distance);
			vertexCollection[i] = vertex;
			assocCollection[i] = new Jun3dPoint[] { point, vertex };
		}
		for (int i = 0; i < polylineArray.length; i++) {
			Jun3dLine[] edges = new Jun3dLine[polylineArray[i].length];
			for (int j = 0; j < polylineArray[i].length; j++) {
				Jun3dLine line = polylineArray[i][j];
				Jun3dPoint from = null;
				Jun3dPoint to = null;
				for (int k = 0; k < assocCollection.length; k++) {
					Jun3dPoint key = (Jun3dPoint) assocCollection[k][0];
					if (from == null && line.from().equal_(key)) {
						from = (Jun3dPoint) assocCollection[k][1];
					}
					if (to == null && line.to().equal_(key)) {
						to = (Jun3dPoint) assocCollection[k][1];
					}
					if (from != null && to != null) {
						break;
					}
				}
				Jun3dLine edge = from.to_(to);
				edgeCollection.add(edge);
				edges[j] = edge;
			}
			loopCollection[i] = edges;
		}

		HashMap aTable = new HashMap();
		aTable.put($("bodies"), new JunOpenGL3dCompoundObject[] { new JunOpenGL3dCompoundObject(), new JunOpenGL3dCompoundObject() });
		aTable.put($("loops"), loopCollection);
		aTable.put($("edges"), edgeCollection.toArray(new Jun3dLine[edgeCollection.size()]));
		aTable.put($("vertexes"), vertexCollection);

		JunOpenGL3dCompoundObject aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[0];
		Jun3dLine[] edges = (Jun3dLine[]) aTable.get($("edges"));
		for (int i = 0; i < edges.length; i++) {
			JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) edges[i].asJunOpenGL3dObject();
			polyline.paint_(Color.black);
			polyline.lineWidth_(3);
			aBody.add_(polyline);
		}
		Jun3dPoint[] vertexes = (Jun3dPoint[]) aTable.get($("vertexes"));
		for (int i = 0; i < vertexes.length; i++) {
			JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) vertexes[i].asJunOpenGL3dObject();
			vertex.paint_(Color.black);
			vertex.size_(5);
			aBody.add_(vertex);
		}

		final JunOpenGL3dCompoundObject aBody2 = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[1];
		compoundObject.primitivesDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
				each.paint_(StColorValue.LightGray);
				each.halftone_(0.75);
				((JunOpenGL3dObject) each).paint_(StColorValue.LightGray);
				((JunOpenGL3dObject) each).halftone_(0.75);
				return null;
			}
		});
		aBody2.add_(compoundObject);
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				Jun3dLine[] lines = ((JunOpenGL3dPolygon) aPolygon).asArrayOfLines();
				for (int i = 0; i < lines.length; i++) {
					JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) lines[i].asJunOpenGL3dObject();
					polyline.paint_(Color.black);
					polyline.lineWidth_(3);
					aBody2.add_(polyline.scaledBy_(1.01));
				}
				return null;
			}
		});

		JunGeometry.HashEqualitySet aJunHashEqualitySet = new JunGeometry.HashEqualitySet();
		aJunHashEqualitySet.addAll(compoundObject.asPointArray());
		Jun3dPoint[] points = (Jun3dPoint[]) aJunHashEqualitySet.toArray(new Jun3dPoint[aJunHashEqualitySet.size()]);
		for (int i = 0; i < points.length; i++) {
			JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) points[i].asJunOpenGL3dObject();
			vertex.paint_(Color.black);
			vertex.size_(5);
			aBody2.add_(vertex);
		}

		return aTable;
	}

	/**
	 * Answer the object to expanded size
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param heightFactor double
	 * @param depthFactor double
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject From_to_height_depth_with_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double heightFactor, double depthFactor, JunOpenGL3dObject a3dObject) {
		Jun3dPoint aPoint = toPoint.minus_(fromPoint);
		double distanceFromOrigin = (new Jun3dPoint(0, 0, 0)).distance_(aPoint);
		if (distanceFromOrigin < Jun3dTransformation.Accuracy()) {
			return new JunOpenGL3dCompoundObject();
		}

		JunOpenGL3dObject anObject = a3dObject.scaledBy_(new Jun3dPoint(distanceFromOrigin, heightFactor, depthFactor));
		Jun3dLine xLine = null;
		if (aPoint.y() < 0) {
			anObject = anObject.transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(180)));
			xLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0 - distanceFromOrigin, 0, 0));
		} else {
			xLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(distanceFromOrigin, 0, 0));
		}

		Jun3dPoint xyPoint = new Jun3dPoint(aPoint.x(), aPoint.y(), 0);
		distanceFromOrigin = new Jun3dPoint(0, 0, 0).distance_(xyPoint);
		Jun3dTransformation aTransformation = null;
		if (distanceFromOrigin < Jun3dTransformation.Accuracy()) {
			aTransformation = Jun3dTransformation.Unity();
			if (aPoint.z() > 0) {
				aTransformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(270));
			} else {
				aTransformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
			}
		} else {
			Jun3dLine shadowLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), xyPoint);
			JunAngle anAngle = xLine.angleWithLine_(shadowLine);
			Jun3dTransformation zRotationTransformation = Jun3dTransformation.RotateZ_(anAngle);
			Jun3dLine aLine = xLine.transform_(zRotationTransformation);
			Jun3dLine targetLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), aPoint);
			anAngle = aLine.angleWithLine_(targetLine);
			if (xyPoint.distance_(aPoint) < Jun3dTransformation.Accuracy()) {
				aTransformation = zRotationTransformation;
			} else {
				JunPlane aPlane = new JunPlane(new Jun3dPoint(0, 0, 0), xyPoint, aPoint);
				Jun3dLine perpendicularLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), aPlane.normalVector());
				Jun3dTransformation rotationTransformation = Jun3dTransformation.Rotate_around_(anAngle, perpendicularLine);
				aTransformation = zRotationTransformation.product_(rotationTransformation);
			}
		}
		aTransformation = aTransformation.product_(Jun3dTransformation.Translate_(fromPoint));
		anObject = anObject.transform_(aTransformation);
		return anObject;
	}

	/**
	 * Answer the object to expanded size
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject From_to_with_(Jun3dPoint fromPoint, Jun3dPoint toPoint, JunOpenGL3dObject a3dObject) {
		return From_to_height_depth_with_(fromPoint, toPoint, 1, 1, a3dObject);
	}

	/**
	 * Answer the nAkis hedron objects.
	 * 
	 * @param aHedron jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject NAkisHedron_(JunOpenGL3dObject aHedron) {
		return NAkisHedron_interim_(aHedron, new StBlockClosure() {
			public Object value_(Object object) {
				return null;
			}
		});
	}

	/**
	 * Answer the nAkis hedron objects.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aHedron jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Utilities
	 */
	public static JunOpenGL3dObject NAkisHedron_interim_(final JunOpenGL3dObject aHedron, final StBlockClosure aBlock) {
		final Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		final JunOpenGL3dCompoundObject nAkisHedron = new JunOpenGL3dCompoundObject();
		aHedron.primitivesDo_(new StBlockClosure() {
			public Object value_(Object object) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) object;
				JunPlane aPlane = null;
				if (polygon.vertexes().length >= 5) {
					aPlane = new JunPlane(polygon.vertexes()[0], polygon.vertexes()[2], polygon.vertexes()[4]);
				} else {
					aPlane = new JunPlane(polygon.vertexes()[0], polygon.vertexes()[1], polygon.vertexes()[2]);
				}
				Jun3dPoint aPoint = aPlane.nearestPointFromPoint_(originPoint);
				Jun3dLine aLine = new Jun3dLine(originPoint, aPoint).normalizedLine();
				aPoint = aLine.atT_(1);
				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				for (int index = 0; index < polygon.vertexes().length; index++) {
					JunOpenGL3dPolygon aTriangle = null;
					if (index + 1 < polygon.vertexes().length) {
						aTriangle = new JunOpenGL3dPolygon(new Jun3dPoint[] { polygon.vertexes()[index], polygon.vertexes()[index + 1], aPoint });
					} else {
						aTriangle = new JunOpenGL3dPolygon(new Jun3dPoint[] { polygon.vertexes()[index], polygon.vertexes()[0], aPoint });
					}
					compoundObject.add_(aTriangle);
				}
				// nAkisHedron.addAll_(compoundObject.components());
				nAkisHedron.add_(compoundObject);
				if (aBlock != null) {
					if (aBlock.numArgs() == 1) {
						aBlock.value_(nAkisHedron);
					}
					if (aBlock.numArgs() == 2) {
						aBlock.value_value_(nAkisHedron, aHedron);
					}
				}
				return null;
			}
		});
		return nAkisHedron;
	}

	/**
	 * Typical object - rotation
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param arrayOfPoints jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param divisionNumber int
	 * @category Utilities
	 */
	public static JunOpenGL3dObject Rotate_divisions_(Jun2dPoint[] arrayOfPoints, int divisionNumber) {
		JunOpenGLRotationModel aModel = new JunOpenGLRotationModel();
		aModel.polyline_(new JunOpenGLRotationPolyline(arrayOfPoints, true));
		JunOpenGL3dObject aBody = aModel.rotatedBody_(divisionNumber).asJunOpenGL3dObject();
		aBody.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) each;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
				for (int i = 0; i < vertexes.length; i++) {
					normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
				}
				polygon.normalVectors_(normalVectors);
				return null;
			}
		});
		aBody.flushAllPaints();
		aBody.paint_(DefaultPaint());
		return aBody;
	}
}
