package jp.co.sra.jun.opengl.objects;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunOpenGL3dPrimitiveObject class
 * 
 *  @author    nisinaka
 *  @created   1998/10/13 (by nisinaka)
 *  @updated   1999/08/04 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2004/05/14 (by nisinaka)
 *  @updated   2004/09/29 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun678 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dPrimitiveObject.java,v 8.12 2008/02/20 06:32:35 nisinaka Exp $
 */
public abstract class JunOpenGL3dPrimitiveObject extends JunOpenGL3dObject {

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dPrimitiveObject, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#isPrimitive()
	 * @category testing
	 */
	public boolean isPrimitive() {
		return true;
	}

	/**
	 * Enumerate each objects and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public Object objectsDo_(StBlockClosure aBlock) {
		return aBlock.value_(this);
	}

	/**
	 * Enumerate all of the primitive objects and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public Object primitivesDo_(StBlockClosure aBlock) {
		return aBlock.value_(this);
	}

	/**
	 * Enumerate every polygons and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#polygonsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void polygonsDo_(StBlockClosure aBlock) {
		return;
	}

	/**
	 * Enumerate every polylines and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#polylinesDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void polylinesDo_(StBlockClosure aBlock) {
		return;
	}

	/**
	 * Convert the receiver to a JunOpenGL3dCompoundObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#asCompoundObject()
	 * @category converting
	 */
	public JunOpenGL3dCompoundObject asCompoundObject() {
		return new JunOpenGL3dCompoundObject(this);
	}

	/**
	 * Flush all alphas.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllAlphas()
	 * @category flushing
	 */
	public void flushAllAlphas() {
		this.flushAlpha();
	}

	/**
	 * Flush all bounds.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllBounds()
	 * @category flushing
	 */
	public void flushAllBounds() {
		this.flushBounds();
	}

	/**
	 * Flush all colors.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllColors()
	 * @category flushing
	 */
	public void flushAllColors() {
		this.flushColors();
	}

	/**
	 * Flush all names.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllNames()
	 * @category flushing
	 */
	public void flushAllNames() {
		this.flushName();
	}

	/**
	 * Flush all normal vectors.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllNormalVectors()
	 * @category flushing
	 */
	public void flushAllNormalVectors() {
		this.flushNormalVectors();
	}

	/**
	 * Flush all paints.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#flushAllPaints()
	 * @category flushing
	 */
	public void flushAllPaints() {
		this.flushPaint();
	}

	/**
	 * Answer the number of primitives.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#numberOfPrimitives()
	 * @category utilities
	 */
	public int numberOfPrimitives() {
		return 1;
	}

}
