package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.util.Collection;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGL3dPolylineLoop class
 * 
 *  @author    nisinaka
 *  @created   1998/10/21 (by nisinaka)
 *  @updated   1999/08/04 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2004/05/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun691 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dPolylineLoop.java,v 8.12 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dPolylineLoop extends JunOpenGL3dPolyline {

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop() {
		super();
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with a collection of 3d points.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Collection aCollectionOf3dPoints) {
		super(aCollectionOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with a collection of 3d points.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Collection aCollectionOf3dPoints, Color aColor) {
		super(aCollectionOf3dPoints, aColor);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with a collection of 3d points and alpha value.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Collection aCollectionOf3dPoints, Color aColor, float aNumber) {
		super(aCollectionOf3dPoints, aColor, aNumber);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints) {
		super(anArrayOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points and a Color.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Color aColor) {
		super(anArrayOf3dPoints, aColor);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points, a Color and alpha value.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Color aColor, float aNumber) {
		super(anArrayOf3dPoints, aColor, aNumber);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points and an array of colors.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Color[] anArrayOfColors) {
		super(anArrayOf3dPoints, anArrayOfColors);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points, an array of colors and alpha value.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Color[] anArrayOfColors, float aNumber) {
		super(anArrayOf3dPoints, anArrayOfColors, aNumber);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points, and an array of 3d vectors.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOf3dVectors jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Jun3dPoint[] anArrayOf3dVectors) {
		super(anArrayOf3dPoints, anArrayOf3dVectors);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points, an array of 3d vectors and an array of colors.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOf3dVectors jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Jun3dPoint[] anArrayOf3dVectors, Color[] anArrayOfColors) {
		super(anArrayOf3dPoints, anArrayOf3dVectors, anArrayOfColors);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points, an array of 3d vectors, an array of colors and alpha value.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOf3dVectors jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(Jun3dPoint[] anArrayOf3dPoints, Jun3dPoint[] anArrayOf3dVectors, Color[] anArrayOfColors, float aNumber) {
		super(anArrayOf3dPoints, anArrayOf3dVectors, anArrayOfColors, aNumber);
	}

	/**
	 * Create a new instance of JunOpenGL3dPolylineLoop and initialize it with the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunOpenGL3dPolylineLoop(JunLispList aList) {
		super(aList);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @deprecated since Jun454, use the constructor.
	 * @category Instance creation
	 */
	public static JunOpenGL3dObject Vertexes_(Jun3dPoint[] anArrayOf3dPoints) {
		return new JunOpenGL3dPolylineLoop(anArrayOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with a collection of 3d points.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @deprecated since Jun454, use the constructor.
	 * @category Instance creation
	 */
	public static JunOpenGL3dObject Vertexes_(Collection aCollectionOf3dPoints) {
		return new JunOpenGL3dPolylineLoop(aCollectionOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolylineLoop and initialize it with an array of 3d points and a Color.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @deprecated since Jun454, use the constructor.
	 * @category Instance creation
	 */
	public static JunOpenGL3dObject Vertexes_paint_(Jun3dPoint[] anArrayOf3dPoints, Color aColor) {
		return new JunOpenGL3dPolylineLoop(anArrayOf3dPoints, aColor);
	}

	/**
	 * Answer true if the receiver is looped line segments.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline#isLoop()
	 * @category testing
	 */
	public boolean isLoop() {
		return true;
	}

	/**
	 * Render the OpenGL object on a rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
		if (this.hasPaint()) {
			aRenderingContext.paint_(this.paint());
		}
		if (this.hasAlpha()) {
			aRenderingContext.alpha_(this.alpha());
		}
		aRenderingContext.lineWidth_(this.lineWidth());
		if (this.hasStipple()) {
			aRenderingContext.lineStippleFactor_pattern_(this.stippleFactor(), this.stipplePattern());
			aRenderingContext.enableLineStipple();
		}

		aRenderingContext.displayLineLoop_(this.vertexes());

		if (this.hasStipple()) {
			aRenderingContext.disableLineStipple();
		}
	}

	/**
	 * Enumerate every geometries and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public Object geometriesDo_(StBlockClosure aBlock) {
		for (int i = 0; i < (vertexes.length - 1); i++) {
			Object result = aBlock.value_(new Jun3dLine(vertexes[i], vertexes[i + 1]));
			if (result != null) {
				return result;
			}
		}
		return aBlock.value_(new Jun3dLine(vertexes[vertexes.length - 1], vertexes[0]));
	}

	/**
	 * Answer the StSymbol which represents the kind of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category lisp support
	 */
	public StSymbol kindName() {
		return $("PolylineLoop");
	}

	/**
	 * Answer the vertexes for VRML.
	 * 
	 * @return Jun3dPoint[]
	 * @category vrml support
	 */
	protected Jun3dPoint[] vrmlVertexes() {
		Jun3dPoint[] points = this.vertexes();
		int size = points.length;
		if (points[0] == points[size - 1]) {
			return points;
		}

		Jun3dPoint[] newPoints = new Jun3dPoint[size + 1];
		for (int index = 0; index < size; index++) {
			newPoints[index] = points[index];
		}
		newPoints[size] = points[0];
		return newPoints;
	}

}
