package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjects;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsMisc;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsPie;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.setoperators.JunINTER;

/**
 * JunOpenGL3dObjectTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/13 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2004/09/29 (by m-asada)
 *  @updated   2006/04/18 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dObjectTestExamples.java,v 8.26 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dObjectTestExamples extends JunTestExamples {
	/**
	 * Example: show ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Ball() {
		JunOpenGL3dObject baseHedron = JunOpenGL3dObject.BallHedron();
		final Color[] colorCollection = new Color[] { Color.red, Color.green, Color.blue, Color.gray };
		baseHedron.paint_(colorCollection[colorCollection.length - 1]);
		final JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(baseHedron);
		displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
		displayModel.defaultEyePoint_(new Jun3dPoint(10, 10, 10));
		displayModel.defaultProjection_($("perspectiveProjection"));
		displayModel.defaultPresentation_($("hiddenlinePresentation"));
		displayModel.open();

		JunOpenGL3dObject.Ball_smooth_interim_(baseHedron, colorCollection.length - 1, new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				JunOpenGL3dObject object = (JunOpenGL3dObject) obj1;
				JunOpenGL3dObject original = (JunOpenGL3dObject) obj2;
				int n = ((Number) obj3).intValue();
				JunOpenGL3dObject anOriginal = new JunOpenGL3dTransformedObject(original, Jun3dTransformation.Scale_(0.9999));
				anOriginal.paint_(colorCollection[n]);
				JunOpenGL3dObject anObject = new JunOpenGL3dTransformedObject(object, Jun3dTransformation.Unity());
				anObject.paint_(colorCollection[n - 1]);
				displayModel.displayObject_(new JunOpenGL3dCompoundObject(anOriginal, anObject));
				displayModel.changed_($("object"));
				try {
					Thread.sleep(40);
					Thread.yield();
				} catch (InterruptedException e) {
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * Example: show balls.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Balls() {
		Point aPoint = new Point(100, 100);
		for (int n = -1; n <= 5; n++) {
			JunOpenGL3dObject aBall = (n < 0) ? JunOpenGL3dObject.Sphere() : JunOpenGL3dObject.Ball_(n);
			aBall.primitivesDo_(new StBlockClosure() {
				public Object value_(Object each) {
					((JunOpenGL3dObject) each).paint_(Color.white);
					return null;
				}
			});
			final JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
			aBody.add_(aBall);
			aBall.polygonsDo_(new StBlockClosure() {
				public Object value_(Object obj) {
					JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) obj;
					Jun3dPoint[] points = aPolygon.vertexes();
					Jun3dPoint[] vertexes = new Jun3dPoint[points.length];
					for (int i = 0; i < points.length; i++) {
						vertexes[i] = new Jun3dPoint(0, 0, 0).to_(points[i]).atT_(1.005);
					}
					if (vertexes[0].equals(vertexes[vertexes.length - 1]) == false) {
						Jun3dPoint[] newVertexes = new Jun3dPoint[vertexes.length + 1];
						for (int i = 0; i < vertexes.length; i++) {
							newVertexes[i] = vertexes[i];
						}
						newVertexes[newVertexes.length - 1] = vertexes[0];
						vertexes = newVertexes;
					}
					JunOpenGL3dPolyline polyline = new JunOpenGL3dPolyline(vertexes);
					polyline.paint_(Color.black);
					polyline.lineWidth_(1);
					aBody.add_(polyline);
					return null;
				}
			});
			aBody.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(1.6));

			HashMap aTable = new HashMap();
			aTable.put($("eyePoint"), new Jun3dPoint(50, 50, 50));
			aTable.put($("presentation"), $("solidPresentation"));
			aTable.put($("projection"), $("perspectiveProjection"));
			aTable.put($("shading"), $("smoothShading"));
			aTable.put($("upVector"), new Jun3dPoint(0, 0, 1));
			aTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
			aTable.put($("viewFactor"), new Integer(10));
			aTable.put($("zoomHeight"), new Double(2.8));
			aBody.showProjectionTable_in_(aTable, new Rectangle(aPoint, new Dimension(400, 400)));
			aPoint = new Point(aPoint.x + 25, aPoint.y + 25);
		}

		return true;
	}

	/**
	 * Example: show Dodecahedron and Icosahedron.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Both() {
		Example_BothObject().show();
		return true;
	}

	/**
	 * Example object - Dodecahedron and Icosahedron.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static final JunOpenGL3dObject Example_BothObject() {
		JunOpenGL3dCompoundObject object = new JunOpenGL3dCompoundObject();
		object.add_(Example_Dodecahedron());
		JunOpenGL3dObject icosahedron = Example_Icosahedron();
		icosahedron.paint_(Color.red);
		object.add_(icosahedron);
		return object;
	}

	/**
	 * Example object - Dodecahedron.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static final JunOpenGL3dObject Example_Dodecahedron() {
		JunOpenGL3dCompoundObject object = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] points = new Jun3dPoint[10];
		for (int i = 0; i < 5; i++) {
			points[i] = new Jun3dPoint(Math.cos((Math.PI * ((i + 1) * 2 + 1)) / 5.0d) * 2, Math.sin(Math.PI * ((i + 1) * 2 + 1) / 5.0d) * 2, (1.0d + Math.sqrt(5.0d)) / 2 + 1.0d);
			points[i + 5] = new Jun3dPoint(Math.cos(Math.PI * ((i + 1) * 2 + 1) / 5.0d) * (1.0d + Math.sqrt(5.0d)), Math.sin(Math.PI * ((i + 1) * 2 + 1) / 5.0d) * (1.0d + Math.sqrt(5.0d)), (1.0d + Math.sqrt(5.0d)) / 2 - 1.0d);
		}
		for (int i = 0; i < 10; i++) {
			points[i] = points[i].dividedBy_(points[i].rho()).multipliedBy_(0.81573786516665d / 0.79465447229177d);
		}
		object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[0], points[1], points[2], points[3], points[4] }));
		object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[4].negated(), points[3].negated(), points[2].negated(), points[1].negated(), points[0].negated() }));
		for (int i = 0; i < 5; i++) {
			object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[i], points[i + 5], points[(i + 1 + 2) % 5 + 5].negated(), points[(i + 1) % 5 + 5], points[(i + 1) % 5] }));
			object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[(i + 1) % 5].negated(), points[(i + 1) % 5 + 5].negated(), points[(i + 1 + 2) % 5 + 5], points[i + 5].negated(), points[i].negated() }));
		}
		object.paint_(Color.blue);
		return object;
	}

	/**
	 * Example object - Expand hedrons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static final boolean Example_ExpandHedrons() {
		boolean aBoolean = JunSensorUtility.ShiftDown();
		ArrayList toDoList = new ArrayList();
		toDoList.add(new Object[] { $("RegularTetrahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(1.0);
			}
		} } });
		toDoList.add(new Object[] { $("RegularHexahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(1.0);
			}
		} } });
		toDoList.add(new Object[] { $("RegularOctahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[((JunOpenGL3dCompoundObject) hedron).size() - 1];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(2.0);
			}
		} } });
		toDoList.add(new Object[] { $("RegularDodecahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(1.0);
			}
		} } });
		toDoList.add(new Object[] { $("RegularIcosahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(4.0);
			}
		} } });
		toDoList.add(new Object[] { $("Cuboctahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(2.0);
			}
		} } });
		toDoList.add(new Object[] { $("Icosidodecahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(6.0);
			}
		} } });
		toDoList.add(new Object[] { $("TetrakisHexahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[((JunOpenGL3dCompoundObject) hedron).size() - 1];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(25.0);
			}
		} } });
		toDoList.add(new Object[] { $("PentakisDodecahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[((JunOpenGL3dCompoundObject) hedron).size() - 1];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(25.0);
			}
		} } });
		toDoList.add(new Object[] { $("TruncatedTetrahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[((JunOpenGL3dCompoundObject) hedron).size() - 1];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(1.5);
			}
		} } });
		toDoList.add(new Object[] { $("TruncatedHexahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(1.6);
			}
		} } });
		toDoList.add(new Object[] { $("TruncatedOctahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(2.0);
			}
		} } });
		toDoList.add(new Object[] { $("TruncatedDodecahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[0];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(2.0);
			}
		} } });
		toDoList.add(new Object[] { $("TruncatedIcosahedron"), new StBlockClosure[] { new StBlockClosure() {
			public Object value_(Object hedron) {
				return ((JunOpenGL3dCompoundObject) hedron).components()[((JunOpenGL3dCompoundObject) hedron).size() - 1];
			}
		}, new StBlockClosure() {
			public Object value() {
				return new Double(2.2);
			}
		} } });

		Object[][] toDoArray = (Object[][]) toDoList.toArray(new Object[toDoList.size()][]);
		for (int i = toDoArray.length - 1; i >= 0; i--) {
			Object[] associtaion = toDoArray[i];
			StSymbol key = (StSymbol) associtaion[0];
			String englishString = JunStringUtility.SpacingMessageSelector_(key).trim();
			String japaneseString = $String(englishString.replaceAll(" ", "\\ "));
			JunOpenGL3dCompoundObject aHedron = null;
			try {
				aHedron = ((JunOpenGL3dCompoundObject) _Perform(JunOpenGL3dObject.class, key.toString())).flatten();
			} catch (Exception e) {
				System.out.println(e.getMessage());
				e.printStackTrace();
			}
			JunOpenGL3dPolygon value1 = (JunOpenGL3dPolygon) ((StBlockClosure[]) associtaion[1])[0].value_(aHedron);
			double value2 = ((Number) ((StBlockClosure[]) associtaion[1])[1].value()).doubleValue();
			Map aTable = JunOpenGL3dTypicalObjects.ExpandedBodiesLoopsEdgesVertexes_by_power_(aHedron, value1, value2);
			JunOpenGLDisplayModel[] aCollection = new JunOpenGLDisplayModel[2];

			Map projectionTable = new HashMap();
			projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 10));
			projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
			projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
			Rectangle displayBounds = new Rectangle(new Point(100, 100), (aBoolean ? new Dimension(600, 600) : new Dimension(400, 400)));
			JunOpenGL3dCompoundObject aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[1];
			JunOpenGLDisplayModel aModel = aBody.showProjectionTable_in_(projectionTable, displayBounds);
			((Frame) aModel.getWindow()).setTitle(japaneseString);
			aCollection[0] = aModel;

			displayBounds = new Rectangle(new Point(550, 100), (aBoolean ? new Dimension(600, 600) : new Dimension(400, 400)));
			aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[0];
			if (aBody.boundingBox().width() > 1000) {
				aModel = aBody.showWithAxesIn_(displayBounds);
			} else {
				projectionTable = new HashMap();
				projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 1000));
				projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
				projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
				aModel = aBody.showProjectionTable_in_(projectionTable, displayBounds);
			}
			((Frame) aModel.getWindow()).setTitle("expanded " + englishString);
			aCollection[1] = aModel;

			for (int j = 0; j < aCollection.length; j++) {
				aCollection[j].closeTogether_(aCollection);
			}

			if (aBoolean) {
				JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
				try {
					cursor._show();

					for (int j = 0; j < aCollection.length; j++) {
						String filename = englishString.replaceAll(" ", "_") + Integer.toString(j + 1) + ".jpg";
						JunImageStream stream = null;
						try {
							stream = JunJpegImageStream.On_(new FileOutputStream(new File(filename)));
							stream.nextPutImage_(aCollection[j].asImage());
						} catch (IOException e) {
							System.out.println(e.getMessage());
							e.printStackTrace();
						} finally {
							if (stream != null) {
								try {
									stream.flush();
									stream.close();
								} catch (IOException e) {
									System.out.println(e.getMessage());
									e.printStackTrace();
								}
							}
						}
					}
				} finally {
					cursor._restore();
				}
			}
		}

		return true;
	}

	/**
	 * Example: show fullerene 5.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Fullerene5() {
		JunOpenGL3dCompoundObject aHedron = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.TruncatedIcosahedron();
		Map aTable = JunOpenGL3dTypicalObjects.ExpandedBodiesLoopsEdgesVertexes_by_power_(aHedron, (JunOpenGL3dPolygon) aHedron.components()[aHedron.size() - 1], 1.6);
		JunOpenGLDisplayModel[] aCollection = new JunOpenGLDisplayModel[2];

		Map projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 10));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Double(2.5));
		JunOpenGL3dCompoundObject aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[1];
		JunOpenGLDisplayModel aModel = aBody.showProjectionTable_in_(projectionTable, new Rectangle(100, 100, 400, 400));
		((Frame) aModel.getWindow()).setTitle($String("truncated icosahedron"));
		aCollection[0] = aModel;

		projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 1000));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Integer(38));
		aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[0];
		aModel = aBody.showProjectionTable_in_(projectionTable, new Rectangle(550, 100, 400, 400));
		((Frame) aModel.getWindow()).setTitle("expanded truncated icosahedron");
		aCollection[1] = aModel;

		for (int j = 0; j < aCollection.length; j++) {
			aCollection[j].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example: show fullerene 55.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Fullerene55() {
		boolean aBoolean = JunSensorUtility.ShiftDown();
		JunOpenGL3dCompoundObject aHedron = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.TruncatedIcosahedron();

		final ArrayList polygonCollection = new ArrayList(32);
		aHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				polygonCollection.add(aPolygon);
				return null;
			}
		});
		JunOpenGL3dPolygon[] polygonArray = (JunOpenGL3dPolygon[]) polygonCollection.toArray(new JunOpenGL3dPolygon[polygonCollection.size()]);

		ArrayList lineCollection = new ArrayList(32 * 6);
		for (int i = 0; i < polygonArray.length; i++) {
			Jun3dLine[] lines = polygonArray[i].asArrayOfLines();
			for (int j = 0; j < lines.length; j++) {
				lineCollection.add(lines[j]);
			}
		}
		Jun3dLine[] lineArray = (Jun3dLine[]) lineCollection.toArray(new Jun3dLine[lineCollection.size()]);

		JunGeometry.HashEqualitySet pointCollection = new JunGeometry.HashEqualitySet(60);
		pointCollection.addAll(aHedron.asPointArray());
		Jun3dPoint[] pointArray = (Jun3dPoint[]) pointCollection.toArray(new Jun3dPoint[pointCollection.size()]);

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		aHedron.primitivesDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
				each.paint_(StColorValue.LightGray);
				each.halftone_(0.75);
				return null;
			}
		});
		aBody.add_(aHedron);
		for (int i = 0; i < pointArray.length; i++) {
			JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) pointArray[i].asJunOpenGL3dObject();
			vertex.paint_(Color.black);
			vertex.size_(5);
			aBody.add_(vertex);
		}
		for (int i = 0; i < lineArray.length; i++) {
			JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) lineArray[i].asJunOpenGL3dObject();
			polyline.paint_(Color.black);
			polyline.lineWidth_(3);
			aBody.add_(polyline.scaledBy_(1.01));
		}

		JunOpenGLDisplayModel[] aCollection = new JunOpenGLDisplayModel[2];

		Map projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 10));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Double(2.5));
		Rectangle displayBounds = new Rectangle(new Point(100, 100), (aBoolean ? new Dimension(600, 600) : new Dimension(400, 400)));
		JunOpenGLDisplayModel aModel = aBody.showProjectionTable_in_(projectionTable, displayBounds);
		((Frame) aModel.getWindow()).setTitle($String("truncated icosahedron"));
		aCollection[0] = aModel;

		Jun3dPoint basePoint = new Jun3dPoint(0, 0, Math.sqrt(2) * 2);
		Object[][] assocCollection = new Object[pointArray.length][];
		aBody = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < pointArray.length; i++) {
			double distance = basePoint.distance_(pointArray[i]);
			if (distance > 3.5) {
				distance = Math.pow(distance, 2.2);
			} else {
				distance = Math.pow(distance, 2);
			}
			Jun3dLine line = new Jun3dPoint(basePoint.x(), basePoint.y(), 0).to_(new Jun3dPoint(pointArray[i].x(), pointArray[i].y(), 0)).normalized();
			Jun3dPoint point = line.atT_(distance);
			assocCollection[i] = new Object[] { pointArray[i], point };
			JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) point.asJunOpenGL3dObject();
			vertex.paint_(Color.black);
			vertex.size_(5);
			aBody.add_(vertex);
		}
		for (int i = 0; i < lineArray.length; i++) {
			Jun3dLine line = lineArray[i];
			Jun3dPoint from = null;
			Jun3dPoint to = null;
			for (int j = 0; j < assocCollection.length; j++) {
				Jun3dPoint key = (Jun3dPoint) assocCollection[j][0];
				if (from == null && line.from().equal_(key)) {
					from = (Jun3dPoint) assocCollection[j][1];
				}
				if (to == null && line.to().equal_(key)) {
					to = (Jun3dPoint) assocCollection[j][1];
				}
				if (from != null && to != null) {
					break;
				}
			}
			JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) from.to_(to).asJunOpenGL3dObject();
			polyline.paint_(Color.black);
			polyline.lineWidth_(3);
			aBody.add_(polyline);
		}

		projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 1000));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(-1, 0, 0));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Integer(42));
		displayBounds = new Rectangle(new Point(550, 100), (aBoolean ? new Dimension(600, 600) : new Dimension(400, 400)));
		aModel = aBody.showProjectionTable_in_(projectionTable, displayBounds);
		((Frame) aModel.getWindow()).setTitle("expanded truncated icosahedron");
		aCollection[1] = aModel;

		for (int j = 0; j < aCollection.length; j++) {
			aCollection[j].closeTogether_(aCollection);
		}

		if (aBoolean) {
			JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
			try {
				cursor._show();

				for (int j = 0; j < aCollection.length; j++) {
					String filename = "expanded truncated icosahedron".replaceAll(" ", "_") + "5" + Integer.toString(j + 1) + ".jpg";
					JunImageStream stream = null;
					try {
						stream = JunJpegImageStream.On_(new FileOutputStream(new File(filename)));
						stream.nextPutImage_(aCollection[j].asImage());
					} catch (IOException e) {
						System.out.println(e.getMessage());
						e.printStackTrace();
					} finally {
						if (stream != null) {
							try {
								stream.flush();
								stream.close();
							} catch (IOException e) {
								System.out.println(e.getMessage());
								e.printStackTrace();
							}
						}
					}
				}
			} finally {
				cursor._restore();
			}
		}

		return true;
	}

	/**
	 * Example: show fullerene 6.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Fullerene6() {
		JunOpenGL3dCompoundObject aHedron = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.TruncatedIcosahedron();
		Map aTable = JunOpenGL3dTypicalObjects.ExpandedBodiesLoopsEdgesVertexes_by_power_(aHedron, (JunOpenGL3dPolygon) aHedron.components()[0], 1.6);
		JunOpenGLDisplayModel[] aCollection = new JunOpenGLDisplayModel[2];

		Map projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 10));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Double(2.5));
		JunOpenGL3dCompoundObject aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[1];
		JunOpenGLDisplayModel aModel = aBody.showProjectionTable_in_(projectionTable, new Rectangle(200, 250, 400, 400));
		((Frame) aModel.getWindow()).setTitle($String("truncated icosahedron"));
		aCollection[0] = aModel;

		projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 1000));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Integer(38));
		aBody = ((JunOpenGL3dCompoundObject[]) aTable.get($("bodies")))[0];
		aModel = aBody.showProjectionTable_in_(projectionTable, new Rectangle(650, 250, 400, 400));
		((Frame) aModel.getWindow()).setTitle("expanded truncated icosahedron");
		aCollection[1] = aModel;

		for (int j = 0; j < aCollection.length; j++) {
			aCollection[j].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example: show fullerene 66.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Fullerene66() {
		boolean aBoolean = JunSensorUtility.ShiftDown();
		JunOpenGL3dCompoundObject aHedron = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.TruncatedIcosahedron().transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(37.333333333333d)));

		final ArrayList polygonCollection = new ArrayList(32);
		aHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				polygonCollection.add(aPolygon);
				return null;
			}
		});
		JunOpenGL3dPolygon[] polygonArray = (JunOpenGL3dPolygon[]) polygonCollection.toArray(new JunOpenGL3dPolygon[polygonCollection.size()]);

		ArrayList lineCollection = new ArrayList(32 * 6);
		for (int i = 0; i < polygonArray.length; i++) {
			Jun3dLine[] lines = polygonArray[i].asArrayOfLines();
			for (int j = 0; j < lines.length; j++) {
				lineCollection.add(lines[j]);
			}
		}
		Jun3dLine[] lineArray = (Jun3dLine[]) lineCollection.toArray(new Jun3dLine[lineCollection.size()]);

		JunGeometry.HashEqualitySet pointCollection = new JunGeometry.HashEqualitySet(60);
		pointCollection.addAll(aHedron.asPointArray());
		Jun3dPoint[] pointArray = (Jun3dPoint[]) pointCollection.toArray(new Jun3dPoint[pointCollection.size()]);

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		aHedron.primitivesDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
				each.paint_(StColorValue.LightGray);
				each.halftone_(0.75);
				return null;
			}
		});
		aBody.add_(aHedron);
		for (int i = 0; i < pointArray.length; i++) {
			JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) pointArray[i].asJunOpenGL3dObject();
			vertex.paint_(Color.black);
			vertex.size_(5);
			aBody.add_(vertex);
		}
		for (int i = 0; i < lineArray.length; i++) {
			JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) lineArray[i].asJunOpenGL3dObject();
			polyline.paint_(Color.black);
			polyline.lineWidth_(3);
			aBody.add_(polyline.scaledBy_(1.01));
		}

		JunOpenGLDisplayModel[] aCollection = new JunOpenGLDisplayModel[2];

		Map projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 10));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(1, 0, 0));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Double(2.5));
		Rectangle displayBounds = new Rectangle(new Point(200, 250), (aBoolean ? new Dimension(600, 600) : new Dimension(400, 400)));
		JunOpenGLDisplayModel aModel = aBody.showProjectionTable_in_(projectionTable, displayBounds);
		((Frame) aModel.getWindow()).setTitle($String("truncated icosahedron"));
		aCollection[0] = aModel;

		Jun3dPoint basePoint = new Jun3dPoint(0, 0, Math.sqrt(2) * 2);
		Object[][] assocCollection = new Object[pointArray.length][];
		aBody = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < pointArray.length; i++) {
			double distance = basePoint.distance_(pointArray[i]);
			if (distance > 3.5) {
				distance = Math.pow(distance, 2.2);
			} else {
				distance = Math.pow(distance, 2);
			}
			Jun3dLine line = new Jun3dPoint(basePoint.x(), basePoint.y(), 0).to_(new Jun3dPoint(pointArray[i].x(), pointArray[i].y(), 0)).normalized();
			Jun3dPoint point = line.atT_(distance);
			assocCollection[i] = new Object[] { pointArray[i], point };
			JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) point.asJunOpenGL3dObject();
			vertex.paint_(Color.black);
			vertex.size_(5);
			aBody.add_(vertex);
		}
		for (int i = 0; i < lineArray.length; i++) {
			Jun3dLine line = lineArray[i];
			Jun3dPoint from = null;
			Jun3dPoint to = null;
			for (int j = 0; j < assocCollection.length; j++) {
				Jun3dPoint key = (Jun3dPoint) assocCollection[j][0];
				if (from == null && line.from().equal_(key)) {
					from = (Jun3dPoint) assocCollection[j][1];
				}
				if (to == null && line.to().equal_(key)) {
					to = (Jun3dPoint) assocCollection[j][1];
				}
				if (from != null && to != null) {
					break;
				}
			}
			JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) from.to_(to).asJunOpenGL3dObject();
			polyline.paint_(Color.black);
			polyline.lineWidth_(3);
			aBody.add_(polyline);
		}

		projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, 1000));
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("projection"), $("perspectiveProjection"));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(-1, 0, 0));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("zoomHeight"), new Integer(42));
		displayBounds = new Rectangle(new Point(650, 250), (aBoolean ? new Dimension(600, 600) : new Dimension(400, 400)));
		aModel = aBody.showProjectionTable_in_(projectionTable, displayBounds);
		((Frame) aModel.getWindow()).setTitle("expanded truncated icosahedron");
		aCollection[1] = aModel;

		for (int j = 0; j < aCollection.length; j++) {
			aCollection[j].closeTogether_(aCollection);
		}

		if (aBoolean) {
			JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
			try {
				cursor._show();

				for (int j = 0; j < aCollection.length; j++) {
					String filename = "expanded truncated icosahedron".replaceAll(" ", "_") + "6" + Integer.toString(j + 1) + ".jpg";
					JunImageStream stream = null;
					try {
						stream = JunJpegImageStream.On_(new FileOutputStream(new File(filename)));
						stream.nextPutImage_(aCollection[j].asImage());
					} catch (IOException e) {
						System.out.println(e.getMessage());
						e.printStackTrace();
					} finally {
						if (stream != null) {
							try {
								stream.flush();
								stream.close();
							} catch (IOException e) {
								System.out.println(e.getMessage());
								e.printStackTrace();
							}
						}
					}
				}
			} finally {
				cursor._restore();
			}
		}

		return true;
	}

	/**
	 * Example object - Dodecahedron.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static final JunOpenGL3dObject Example_Icosahedron() {
		JunOpenGL3dCompoundObject object = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] points = new Jun3dPoint[5];
		for (int i = 0; i < points.length; i++) {
			points[i] = new Jun3dPoint(Math.cos(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sin(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sqrt(5.0d) / 5);
		}
		for (int i = 0; i < points.length; i++) {
			object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 1), points[i], points[(i + 1) % 5] }));
			object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[(i + 1) % 5], points[i], points[(i + 1 + 2) % 5].negated() }));
			object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[i].negated(), points[(i + 1) % 5].negated(), points[(i + 1 + 2) % 5] }));
			object.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { points[(i + 1) % 5].negated(), points[i].negated(), new Jun3dPoint(0.0d, 0.0d, 1.0d).negated() }));
		}
		object.paint_(Color.blue);
		return object;
	}

	/**
	 * Example: show SoccerBall.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_SoccerBall() {
		Example_SoccerBallObject().show();
		// Example_SoccerBallObject2().show();
		return true;
	}

	/**
	 * Example object - SoccerBall.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static final JunOpenGL3dObject Example_SoccerBallObject() {
		final JunOpenGL3dCompoundObject object = new JunOpenGL3dCompoundObject();
		Jun3dPoint[] points = new Jun3dPoint[5];
		for (int i = 0; i < 5; i++) {
			points[i] = new Jun3dPoint(Math.cos(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sin(Math.PI * (i + 1) * 2 / 5) * Math.sqrt(5.0d) * 2 / 5, Math.sqrt(5.0d) / 5);
		}
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Jun3dPoint p1 = (Jun3dPoint) obj1;
				Jun3dPoint p2 = (Jun3dPoint) obj2;
				Jun3dPoint p3 = (Jun3dPoint) obj3;

				Jun3dPoint[] anArray = new Jun3dPoint[6];
				anArray[0] = p1.multipliedBy_(2).plus_(p2).dividedBy_(3);
				anArray[1] = p1.plus_(p2.multipliedBy_(2)).dividedBy_(3);
				anArray[2] = p2.multipliedBy_(2).plus_(p3).dividedBy_(3);
				anArray[3] = p2.plus_(p3.multipliedBy_(2)).dividedBy_(3);
				anArray[4] = p3.multipliedBy_(2).plus_(p1).dividedBy_(3);
				anArray[5] = p3.plus_(p1.multipliedBy_(2)).dividedBy_(3);
				JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(anArray);
				polygon.paint_(Color.blue);
				object.add_(polygon);
				return null;
			}
		};
		for (int i = 0; i < 5; i++) {
			aBlock.value_value_value_(new Jun3dPoint(0.0d, 0.0d, 1.0d), points[i], points[(i + 1) % 5]);
			aBlock.value_value_value_(points[(i + 1) % 5], points[i], points[(i + 1 + 2) % 5].negated());
			aBlock.value_value_value_(points[i].negated(), points[(i + 1) % 5].negated(), points[(i + 1 + 2) % 5]);
			aBlock.value_value_value_(points[(i + 1) % 5].negated(), points[i].negated(), new Jun3dPoint(0.0d, 0.0d, 1.0d).negated());
		}

		aBlock = new StBlockClosure() {
			public Object value_value_(Object obj1, Object obj2) {
				Jun3dPoint p0 = (Jun3dPoint) obj1;
				Jun3dPoint[] pp = (Jun3dPoint[]) obj2;

				Jun3dPoint[] anArray = new Jun3dPoint[5];
				for (int i = 0; i < 5; i++) {
					anArray[i] = p0.multipliedBy_(2).plus_(pp[i]).dividedBy_(3);
				}
				JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(anArray);
				polygon.paint_(Color.red);
				object.add_(polygon);
				for (int i = 0; i < 5; i++) {
					anArray[i] = p0.multipliedBy_(2).plus_(pp[4 - i]).dividedBy_(3).negated();
				}
				polygon = new JunOpenGL3dPolygon(anArray);
				polygon.paint_(Color.red);
				object.add_(polygon);
				return null;
			}
		};
		aBlock.value_value_(new Jun3dPoint(0.0d, 0.0d, 1.0d), points);

		for (int i = 0; i < 5; i++) {
			aBlock.value_value_(points[i], new Jun3dPoint[] { points[(i + 1 + 3) % 5], points[(i + 1 + 1) % 5].negated(), points[(i + 1 + 2) % 5].negated(), points[(i + 1) % 5], new Jun3dPoint(0.0d, 0.0d, 1.0d) });
		}

		return object;
	}

	/**
	 * Example object - SoccerBall2.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 * @category Examples
	 */
	protected static final JunBody Example_SoccerBallObject2() {
		JunBody body1 = JunBody.FromJunOpenGL3dObject_(JunOpenGL3dObjectTestExamples.Example_Dodecahedron());
		JunBody body2 = JunBody.FromJunOpenGL3dObject_(JunOpenGL3dObjectTestExamples.Example_Icosahedron());
		JunINTER setOp = JunINTER.Body_body_(body1, body2);
		setOp.doOperation();
		return setOp.body();
	}

	/**
	 * Show the typical object: Arrow
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_Arrow1() {
		JunOpenGL3dObject anArrow = JunOpenGL3dObject.ArrowFrom_to_(new Jun3dPoint(0.5, -0.5, 0), new Jun3dPoint(-0.5, 0.5, 0));
		anArrow.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.cyan);
				return null;
			}
		});

		JunOpenGL3dObject anAxes = JunOpenGL3dObject.Axes();
		anAxes.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).halftone_(0.5);
				return null;
			}
		});

		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();
		aCompoundObject.add_(anArrow);
		aCompoundObject.add_(anAxes);
		aCompoundObject.show();
		return true;
	}

	/**
	 * Show the typical object: Arrow
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_Arrow2() {
		JunOpenGL3dObject anArrow = JunOpenGL3dObject.ArrowFrom_to_color_lineWidth_(new Jun3dPoint(0.5, -0.5, 0), new Jun3dPoint(-0.5, 0.5, 0), Color.cyan, 3);

		JunOpenGL3dObject anAxes = JunOpenGL3dObject.Axes();
		anAxes.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).halftone_(0.5);
				return null;
			}
		});

		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();
		aCompoundObject.add_(anArrow);
		aCompoundObject.add_(anAxes);
		aCompoundObject.show();
		return true;
	}

	/**
	 * Show the typical object: XArrow
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_XArrow() {
		JunOpenGL3dObject.XArrow().show();
		JunOpenGL3dObject.YArrow().show();
		JunOpenGL3dObject.ZArrow().show();
		return true;
	}

	/**
	 * Show the typical object: XUnitArrow
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_XUnitArrow() {
		JunOpenGL3dObject.XUnitArrow().show();
		JunOpenGL3dObject.YUnitArrow().show();
		JunOpenGL3dObject.ZUnitArrow().show();
		return true;
	}

	/**
	 * Show the typical object: XyArrows
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_XyArrows() {
		JunOpenGL3dObject.XyArrows().show();
		JunOpenGL3dObject.YzArrows().show();
		JunOpenGL3dObject.ZxArrows().show();
		return true;
	}

	/**
	 * Show the typical object: XyUnitArrows
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_XyUnitArrows() {
		JunOpenGL3dObject.XyUnitArrows().show();
		JunOpenGL3dObject.YzUnitArrows().show();
		JunOpenGL3dObject.ZxUnitArrows().show();
		return true;
	}

	/**
	 * Show the typical object: XyzArrows
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_XyzArrows() {
		JunOpenGL3dObject.XyzArrows().show();
		return true;
	}

	/**
	 * Show the typical object: XyzUnitArrows
	 * 
	 * @return boolean
	 * @category Examples arrow
	 */
	public static boolean ExampleArrow_XyzUnitArrows() {
		JunOpenGL3dObject.XyzUnitArrows().show();
		return true;
	}

	/**
	 * Show the typical object: Ball
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_Ball1() {
		JunOpenGL3dObject.Ball_(1).show();
		return true;
	}

	/**
	 * Show the typical object: Ball
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_Ball2() {
		ShowHedron_(JunOpenGL3dObject.Ball_smooth_(JunOpenGL3dObject.BallHedron(), 3));
		return true;
	}

	/**
	 * Show the typical object: Ball
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_Ball3() {
		JunOpenGL3dObject aBoll = JunOpenGL3dObject.Ball_radius_center_(2, 5, new Jun3dPoint(1, 1, 1));
		((JunOpenGL3dCompoundObject) aBoll).add_(JunOpenGL3dObject.Axes2());
		aBoll.show().wireframePresentation();
		return true;
	}

	/**
	 * Show the typical object: Ball
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_BallHedron() {
		ShowHedronWithAxes_(JunOpenGL3dObject.BallHedron());
		return true;
	}

	/**
	 * Show the typical object: Earth
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_Earth() {
		JunOpenGL3dObject.Earth().show();
		return true;
	}

	/**
	 * Show the typical object: Earth
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_SoccerBall() {
		JunOpenGL3dObject.SoccerBall().show();
		return true;
	}

	/**
	 * Show the typical object: Earth
	 * 
	 * @return boolean
	 * @category Examples ball
	 */
	public static boolean ExampleBall_XUnitBall() {
		JunOpenGL3dObject anObject = JunOpenGL3dObject.XUnitBall();
		anObject.paint_(Color.pink);
		JunOpenGL3dCompoundObject aCompoundObject = anObject.asCompoundObject();
		aCompoundObject.add_(JunOpenGL3dObject.Axes2());
		aCompoundObject.show().wireframePresentation();
		return true;
	}

	/**
	 * Show the typical object: Box
	 * 
	 * @return boolean
	 * @category Examples box
	 */
	public static boolean ExampleBox_Box() {
		JunOpenGL3dObject.Box().show();
		return true;
	}

	/**
	 * Show the typical object: ColorCube
	 * 
	 * @return boolean
	 * @category Examples box
	 */
	public static boolean ExampleBox_ColorCube() {
		JunOpenGL3dObject.ColorCube().show();
		return true;
	}

	/**
	 * Show the typical object: Cube
	 * 
	 * @return boolean
	 * @category Examples box
	 */
	public static boolean ExampleBox_Cube() {
		JunOpenGL3dObject.Cube().show();
		return true;
	}

	/**
	 * Show the typical object: Acetylcholine
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Acetylcholine() {
		JunOpenGL3dObject.Acetylcholine().show();
		return true;
	}

	/**
	 * Show the typical object: Adrenaline
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Adrenaline() {
		JunOpenGL3dObject.Adrenaline().show();
		return true;
	}

	/**
	 * Show the typical object: Alanine
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Alanine() {
		JunOpenGL3dObject.Alanine().show();
		return true;
	}

	/**
	 * Show the typical object: Anthracene
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Anthracene() {
		JunOpenGL3dObject.Anthracene().show();
		return true;
	}

	/**
	 * Show the typical object: Benzene
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Benzene() {
		JunOpenGL3dObject.Benzene().show();
		return true;
	}

	/**
	 * Show the typical object: Capsaicin
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Capsaicin() {
		JunOpenGL3dObject.Capsaicin().show();
		return true;
	}

	/**
	 * Show the typical object: Catechin
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Catechin() {
		JunOpenGL3dObject.Catechin().show();
		return true;
	}

	/**
	 * Show the typical object: Chloroform
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Chloroform() {
		JunOpenGL3dObject.Chloroform().show();
		return true;
	}

	/**
	 * Show the typical object: Cystine
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Cystine() {
		JunOpenGL3dObject.Cystine().show();
		return true;
	}

	/**
	 * Show the typical object: Dopamine
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Dopamine() {
		JunOpenGL3dObject.Dopamine().show();
		return true;
	}

	/**
	 * Show the typical object: Luminol
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Luminol() {
		JunOpenGL3dObject.Luminol().show();
		return true;
	}

	/**
	 * Show the typical object: Melatonin
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Melatonin() {
		JunOpenGL3dObject.Melatonin().show();
		return true;
	}

	/**
	 * Show the typical object: Methane
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Methane() {
		JunOpenGL3dObject.Methane().show();
		return true;
	}

	/**
	 * Show the typical object: Naphthalene
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Naphthalene() {
		JunOpenGL3dObject.Naphthalene().show();
		return true;
	}

	/**
	 * Show the typical object: Serotonin
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Serotonin() {
		JunOpenGL3dObject.Serotonin().show();
		return true;
	}

	/**
	 * Show the typical object: Tryptophan
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Tryptophan() {
		JunOpenGL3dObject.Tryptophan().show();
		return true;
	}

	/**
	 * Show the typical object: Tyrosine
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Tyrosine() {
		JunOpenGL3dObject.Tyrosine().show();
		return true;
	}

	/**
	 * Show the typical object: Water
	 * 
	 * @return boolean
	 * @category Examples chemical
	 */
	public static boolean ExampleChemical_Water() {
		JunOpenGL3dObject.Water().show();
		return true;
	}

	/**
	 * Show the typical object: Circle
	 * 
	 * @return boolean
	 * @category Examples circle
	 */
	public static boolean ExampleCircle_CircleBy_radius_() {
		JunOpenGL3dObject.CircleBy_radius_(10, 1).showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Circle
	 * 
	 * @return boolean
	 * @category Examples circle
	 */
	public static boolean ExampleCircle_CircleBy_radius_upVector_() {
		JunOpenGL3dObject.CircleBy_radius_upVector_(30, 0.5, new Jun3dPoint(0, 1, 1)).showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Circle
	 * 
	 * @return boolean
	 * @category Examples circle
	 */
	public static boolean ExampleCircle_xUnitCircle() {
		JunOpenGL3dObject.XUnitCircle().showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Color Cone
	 * 
	 * @return boolean
	 * @category Examples cone
	 */
	public static boolean ExampleCone_ColorCone() {
		JunOpenGL3dObject.ColorCone().show();
		return true;
	}

	/**
	 * Show the typical object: Cone
	 * 
	 * @return boolean
	 * @category Examples cone
	 */
	public static boolean ExampleCone_Cone() {
		JunOpenGL3dObject.Cone().show();
		return true;
	}

	/**
	 * Show the typical object: Cone
	 * 
	 * @return boolean
	 * @category Examples cone
	 */
	public static boolean ExampleCone_ConeFrom_to_radius_by_() {
		JunOpenGL3dObject cone = JunOpenGL3dObject.ConeFrom_to_radius_by_(new Jun3dPoint(-1, -1, 0), new Jun3dPoint(1, 1, 0), 1, 45);
		cone.showWithAxes();
		return true;
	}

	/**
	 * Show the typical object: Cone
	 * 
	 * @return boolean
	 * @category Examples cone
	 */
	public static boolean ExampleCone_ConeFrom_to_width_() {
		JunOpenGL3dObject cone = JunOpenGL3dObject.ConeFrom_to_width_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(3, 4, 5), 0.1);
		cone.paint_(Color.cyan);
		(new JunOpenGL3dCompoundObject(cone, JunOpenGL3dObject.Axes2())).show();
		return true;
	}

	/**
	 * Show the typical object: Cylinder
	 * 
	 * @return boolean
	 * @category Examples cylinder
	 */
	public static boolean ExampleCylinder_Cylinder() {
		JunOpenGL3dObject aCylinder = JunOpenGL3dObject.Cylinder();
		aCylinder.paint_(Color.cyan);
		JunOpenGL3dCompoundObject aCompoundObject = aCylinder.asCompoundObject();
		aCompoundObject.add_(JunOpenGL3dObject.Axes2());
		aCompoundObject.show();
		return true;
	}

	/**
	 * Show the typical object: Cylinder with the specified from point, to point, radius and division.
	 * 
	 * @return boolean
	 * @category Examples cylinder
	 */
	public static boolean ExampleCylinder_CylinderFrom_to_radius_by_() {
		JunOpenGL3dObject.CylinderFrom_to_radius_by_(new Jun3dPoint(-1, -1, 0), new Jun3dPoint(1, 1, 0), 1, 45).showWithAxes();
		return true;
	}

	/**
	 * Show the typical object: xUnitCylinder.
	 * 
	 * @return boolean
	 * @category Examples cylinder
	 */
	public static boolean ExampleCylinder_xUnitCylinder() {
		JunOpenGL3dObject aCylinder = JunOpenGL3dObject.XUnitCylinder();
		aCylinder.paint_(Color.pink);
		aCylinder.showWithUnitAxes().wireframePresentation();
		return true;
	}

	/**
	 * Show the typical object: regular tetrahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_RegularTetrahedron() {
		JunOpenGL3dObject regularTetrahedron = JunOpenGL3dObject.RegularTetrahedron();
		regularTetrahedron.show();
		ShowHedron_((JunOpenGL3dObject) regularTetrahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) regularTetrahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: regular hexahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_RegularHexahedron() {
		JunOpenGL3dObject regularHexahedron = JunOpenGL3dObject.RegularHexahedron();
		regularHexahedron.show();
		ShowHedron_((JunOpenGL3dObject) regularHexahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) regularHexahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: regular octahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_RegularOctahedron() {
		JunOpenGL3dObject regularOctahedron = JunOpenGL3dObject.RegularOctahedron();
		regularOctahedron.show();
		ShowHedron_((JunOpenGL3dObject) regularOctahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) regularOctahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: regular dodecahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_RegularDodecahedron() {
		JunOpenGL3dObject regularDodecahedron = JunOpenGL3dObject.RegularDodecahedron();
		regularDodecahedron.show();
		ShowHedron_((JunOpenGL3dObject) regularDodecahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) regularDodecahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: regular icosahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_RegularIcosahedron() {
		JunOpenGL3dObject regularIcosahedron = JunOpenGL3dObject.RegularIcosahedron();
		regularIcosahedron.show();
		ShowHedron_((JunOpenGL3dObject) regularIcosahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) regularIcosahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: cuboctahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_Cuboctahedron() {
		JunOpenGL3dObject cuboctahedron = JunOpenGL3dObject.Cuboctahedron();
		cuboctahedron.show();
		ShowHedron_((JunOpenGL3dObject) cuboctahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) cuboctahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: icosidodecahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_Icosidodecahedron() {
		JunOpenGL3dObject icosidodecahedron = JunOpenGL3dObject.Icosidodecahedron();
		icosidodecahedron.show();
		ShowHedron_((JunOpenGL3dObject) icosidodecahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) icosidodecahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: triakis octahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TriakisOctahedron() {
		JunOpenGL3dObject triakisOctahedron = JunOpenGL3dObject.TriakisOctahedron();
		triakisOctahedron.show();
		ShowHedron_((JunOpenGL3dObject) triakisOctahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) triakisOctahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: triakis icosahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TriakisIcosahedron() {
		JunOpenGL3dObject triakisIcosahedron = JunOpenGL3dObject.TriakisIcosahedron();
		triakisIcosahedron.show();
		ShowHedron_((JunOpenGL3dObject) triakisIcosahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) triakisIcosahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: tetrakis hexahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TetrakisHexahedron() {
		JunOpenGL3dObject tetrakisHexahedron = JunOpenGL3dObject.TetrakisHexahedron();
		tetrakisHexahedron.show();
		ShowHedron_((JunOpenGL3dObject) tetrakisHexahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) tetrakisHexahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: pentakis dodecahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_PentakisDodecahedron() {
		JunOpenGL3dObject pentakisDodecahedron = JunOpenGL3dObject.PentakisDodecahedron();
		pentakisDodecahedron.show();
		ShowHedron_((JunOpenGL3dObject) pentakisDodecahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) pentakisDodecahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: truncated tetrahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TruncatedTetrahedron() {
		JunOpenGL3dObject truncatedTetrahedron = JunOpenGL3dObject.TruncatedTetrahedron();
		truncatedTetrahedron.show();
		ShowHedron_((JunOpenGL3dObject) truncatedTetrahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) truncatedTetrahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: truncated hexahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TruncatedHexahedron() {
		JunOpenGL3dObject truncatedHexahedron = JunOpenGL3dObject.TruncatedHexahedron();
		truncatedHexahedron.show();
		ShowHedron_((JunOpenGL3dObject) truncatedHexahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) truncatedHexahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: truncated octahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TruncatedOctahedron() {
		JunOpenGL3dObject truncatedOctahedron = JunOpenGL3dObject.TruncatedOctahedron();
		truncatedOctahedron.show();
		ShowHedron_((JunOpenGL3dObject) truncatedOctahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) truncatedOctahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: truncated dodecahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TruncatedDodecahedron() {
		JunOpenGL3dObject truncatedDodecahedron = JunOpenGL3dObject.TruncatedDodecahedron();
		truncatedDodecahedron.show();
		ShowHedron_((JunOpenGL3dObject) truncatedDodecahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) truncatedDodecahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: truncated icosahedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleHedron_TruncatedIcosahedron() {
		JunOpenGL3dObject truncatedIcosahedron = JunOpenGL3dObject.TruncatedIcosahedron();
		truncatedIcosahedron.show();
		ShowHedron_((JunOpenGL3dObject) truncatedIcosahedron.copy());
		ShowHedronWithAxes_((JunOpenGL3dObject) truncatedIcosahedron.copy());
		return true;
	}

	/**
	 * Show the typical object: aAkis hedron
	 * 
	 * @return boolean
	 * @category Examples hedron
	 */
	public static boolean ExampleNAkis_NAkisHedron() {
		JunOpenGL3dObject aHedron = JunOpenGL3dObject.RegularTetrahedron();
		ShowHedron_(aHedron);
		ShowHedron_(JunOpenGL3dTypicalObjects.NAkisHedron_(aHedron));
		return true;
	}

	/**
	 * Convert to an image.
	 * 
	 * @return boolean
	 * @category Examples image
	 */
	public static boolean ExampleImage_asImage() {
		JunOpenGL3dObject anObject = JunOpenGL3dObject.Eddy();
		StImage anImage = anObject.asImage();
		StImage.Display_(anImage);
		return true;
	}

	/**
	 * Show the typical object: Anpanman
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Anpanman() {
		JunOpenGL3dObject.Anpanman().show();
		return true;
	}

	/**
	 * Show the typical object: Aoki
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Aoki() {
		JunOpenGL3dObject.Aoki1().show();
		return true;
	}

	/**
	 * Show the typical object: Aoki
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Aoki2() {
		JunOpenGL3dObject.Aoki2().show();
		return true;
	}

	/**
	 * Show the typical object: Arowana
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Arowana() {
		JunOpenGL3dObject.Arowana().show();
		return true;
	}

	/**
	 * Show the typical object: Axes
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Axes() {
		JunOpenGL3dObject.Axes().show();
		return true;
	}

	/**
	 * Show the typical object: Axes2
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Axes2() {
		JunOpenGL3dObject.Axes2().show();
		return true;
	}

	/**
	 * Show the typical object: Baby
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Baby() {
		JunOpenGL3dObject.Baby().show();
		return true;
	}

	/**
	 * Show the typical object: Bell
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Bell() {
		JunOpenGL3dObject.Bell().show();
		return true;
	}

	/**
	 * Show the typical object: Dolphin
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Dolphin() {
		JunOpenGL3dObject.Dolphin().show();
		return true;
	}

	/**
	 * Show the typical object: Dolphin
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Doraemon() {
		JunOpenGL3dObject.Doraemon().show();
		return true;
	}

	/**
	 * Show the typical object: Earl
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Earl() {
		JunOpenGL3dObject.Earl().show();
		return true;
	}

	/**
	 * Show the typical object: Eddy
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Eddy() {
		JunOpenGL3dObject.Eddy().show();
		return true;
	}

	/**
	 * Show the typical object: Hand
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Hand() {
		JunOpenGL3dObject.Hand().show();
		return true;
	}

	/**
	 * Show the typical object: Mickey
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Mickey() {
		JunOpenGL3dObject.Mickey().show();
		JunOpenGL3dObject.Mickey1().show();
		return true;
	}

	/**
	 * Show the typical object: Minnie
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Minnie() {
		JunOpenGL3dObject.Minnie().show();
		return true;
	}

	/**
	 * Show the typical object: Mouse
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Mouse() {
		JunOpenGL3dObject.Mouse().show();
		return true;
	}

	/**
	 * Show the typical object: Oni
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Oni() {
		JunOpenGL3dObject.Oni().show();
		return true;
	}

	/**
	 * Show the typical object: Panda
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Panda() {
		JunOpenGL3dObject.Panda().show();
		return true;
	}

	/**
	 * Show the typical object: Panda2
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Panda2() {
		JunOpenGL3dObject.Panda2().show();
		return true;
	}

	/**
	 * Show the typical object: Penguin
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Penguin() {
		JunOpenGL3dObject.Penguin().show();
		return true;
	}

	/**
	 * Show the typical object: Pooh
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Pooh() {
		JunOpenGL3dObject.Pooh().show();
		return true;
	}

	/**
	 * Show the typical object: Raptor
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Raptor() {
		JunOpenGL3dObject.Raptor().show();
		return true;
	}

	/**
	 * Show the typical object: Smalltalk
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Smalltalk() {
		JunOpenGL3dObject.Smalltalk().show();
		return true;
	}

	/**
	 * Show the typical object: Stack
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Stack() {
		JunOpenGL3dObject.Stack().show();
		return true;
	}

	/**
	 * Show the typical object: Torus
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Torus() {
		JunOpenGL3dTypicalObjectsMisc.Torus().show();
		return true;
	}

	/**
	 * Show the typical object: Torus
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Triball() {
		JunOpenGL3dObject.Triball().show();
		return true;
	}

	/**
	 * Show the typical object: Wasp
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Wasp() {
		JunOpenGL3dObject.Wasp().show();
		return true;
	}

	/**
	 * Show the typical object: Wyvern
	 * 
	 * @return boolean
	 * @category Examples misc
	 */
	public static boolean ExampleMisc_Wyvern() {
		JunOpenGL3dObject.Wyvern().show();
		return true;
	}

	/**
	 * Show the typical object: Mobius
	 * 
	 * @return boolean
	 * @category Examples mobius
	 */
	public static boolean ExampleMobius_Mobius() {
		JunOpenGL3dObject.Mobius().show();

		JunOpenGL3dObject mobius = JunOpenGL3dObject.MobiusRadius_divisions_stripRadius_(3.0 / 4.0, 36, 1.0 / 4.0);
		mobius.polylinesDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolyline each = (JunOpenGL3dPolyline) obj;
				each.lineWidth_(3);
				each.paint_(Color.black);
				return null;
			}
		});
		mobius.showIn_(new Rectangle(200, 200, 400, 400)).hiddenlinePresentation();

		mobius = JunOpenGL3dObject.MobiusRadius_divisions_stripRadius_divisions_(3.0 / 4.0, 36, 1.0 / 4.0, 4);
		mobius.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(StColorValue.Brightness_(0.9));
				return null;
			}
		});
		mobius.showIn_(new Rectangle(200, 200, 400, 400)).hiddenlinePresentation();

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		mobius = JunOpenGL3dObject.MobiusRadius_divisions_stripRadius_divisions_(3.0 / 4.0, 72, 1.0 / 4.0, 12);
		mobius.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon each = (JunOpenGL3dPolygon) obj;
				each.halftone_(0.75);
				each.paint_(StColorValue.Brightness_(0.9));
				return null;
			}
		});
		compoundObject.add_(mobius);
		final JunOpenGL3dObject theBall = JunOpenGL3dObject.Ball_(1).scaledBy_(0.025);
		final JunOpenGL3dCompoundObject theBody = new JunOpenGL3dCompoundObject();
		mobius = JunOpenGL3dObject.MobiusRadius_divisions_stripRadius_locusDo_(3.0 / 4.0, 72, 1.0 / 4.0, new StBlockClosure() {
			public Object valueWithArguments_(Object[] anArray) {
				Jun3dPoint locusPoint = (Jun3dPoint) anArray[0];
				// Jun3dPoint rightVector = (Jun3dPoint) anArray[1];
				Jun3dPoint upVector = (Jun3dPoint) anArray[2];
				float normalizedValue = ((Number) anArray[3]).floatValue();
				JunOpenGL3dObject aBall = theBall.translatedBy_(locusPoint).translatedBy_(upVector.multipliedBy_(0.025));
				aBall.paint_(Color.getHSBColor(normalizedValue, 1.0f, 1.0f));
				theBody.add_(aBall);
				return null;
			}
		});
		compoundObject.add_(theBody);
		compoundObject.show();

		return true;
	}

	/**
	 * Show the typical object: Mobius Strip
	 * 
	 * @return boolean
	 * @category Examples mobius
	 */
	public static boolean ExampleMobius_MobiusStrip() {
		JunOpenGL3dObject.MobiusStrip().show();

		JunOpenGL3dObject mobiusStrip = JunOpenGL3dObject.MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(3.0 / 4.0, 72, 1.0 / 4.0, 4, 0.05);
		mobiusStrip.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(StColorValue.Brightness_(0.9));
				return null;
			}
		});
		mobiusStrip.showIn_(new Rectangle(200, 200, 400, 400)).hiddenlinePresentation();

		return true;
	}

	/**
	 * Show the typical object: ChunkOfPie
	 * 
	 * @return boolean
	 * @category Examples pie
	 */
	public static boolean ExamplePie_ChunkOfPie() {
		JunOpenGL3dObject aChunkOfPie = JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_radius_thickness_(0, 90, 10, 0.8, 0.2);
		aChunkOfPie.paint_(java.awt.Color.red);
		(new JunOpenGL3dCompoundObject(aChunkOfPie, JunOpenGL3dObject.XyzUnitArrows())).show();
		return true;
	}

	/**
	 * Show the typical object: SlicedPie
	 * 
	 * @return boolean
	 * @category Examples pie
	 */
	public static boolean ExamplePie_SlicedPie() {
		JunOpenGL3dObject aSliecedPie = JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_radius_thickness_(0, 270, 10, 0.8, 0.2);
		aSliecedPie.paint_(java.awt.Color.red);
		(new JunOpenGL3dCompoundObject(aSliecedPie, JunOpenGL3dObject.XyzUnitArrows())).show();
		return true;
	}

	/**
	 * Show the typical object: Rotation
	 * 
	 * @return boolean
	 * @category Examples rotation
	 */
	public static boolean ExampleRotation_Rotation() {
		Jun2dPoint[] arrayOfPoints = new Jun2dPoint[] { new Jun2dPoint(-1.0, 1.0), new Jun2dPoint(0.0, 2.0), new Jun2dPoint(1.0, 1.0) };
		int divisionNumber = 18;
		JunOpenGL3dObject aBody = JunOpenGL3dObject.Rotate_divisions_(arrayOfPoints, divisionNumber);
		aBody.show();
		return true;
	}

	/**
	 * Show the typical object: Globe
	 * 
	 * @return boolean
	 * @category Examples sphere
	 */
	public static boolean ExampleSphere_Globe() {
		JunOpenGL3dObject.Globe().show();
		return true;
	}

	/**
	 * Show the typical object: Spring
	 * 
	 * @return boolean
	 * @category Examples spring
	 */
	public static boolean ExampleSpring_Spring() {
		JunOpenGL3dObject.Spring().show().backgroundColor_(Color.white);
		return true;
	}

	/**
	 * Show the typical object: Spring
	 * 
	 * @return boolean
	 * @category Examples spring
	 */
	public static boolean ExampleSpring_SpringFrom_to_width_() {
		JunOpenGL3dObject aSpring = JunOpenGL3dObject.SpringFrom_to_width_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(-1, -1, 0), 0.1);
		aSpring.paint_(Color.cyan);
		aSpring.showWithUnitAxes();

		aSpring = JunOpenGL3dObject.SpringFrom_to_width_repeat_(new Jun3dPoint(-1, -1, -1), new Jun3dPoint(1, 1, 1), 0.1, 50);
		aSpring.paint_(Color.cyan);
		aSpring.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: xUnit Spring
	 * 
	 * @return boolean
	 * @category Examples spring
	 */
	public static boolean ExampleSpring_xUnitSpring() {
		JunOpenGL3dObject aSpring = JunOpenGL3dObject.XUnitSpring();
		aSpring.paint_(Color.pink);
		aSpring.showWithAxes();
		return true;
	}

	/**
	 * Show the 2D text.
	 * 
	 * @return boolean
	 * @category Examples text
	 */
	public static boolean ExampleText_Text2d() {
		JunOpenGL3dObject.Text2d_("Jun").show();
		JunOpenGL3dObject.Text2d_weight_("Jun", 0.1).show();
		JunOpenGL3dObject.Text2d_weight_("Jun", 0.9).show();
		return true;
	}

	/**
	 * Show the 3D text.
	 * 
	 * @return boolean
	 * @category Examples text
	 */
	public static boolean ExampleText_Text3d() {
		JunOpenGL3dObject.Text3d_("Jun").show();
		JunOpenGL3dObject.Text3d_weight_("Jun", 0.1).show();
		JunOpenGL3dObject.Text3d_weight_("Jun", 0.9).show();
		return true;
	}

	/**
	 * Show the typical object: Torus
	 * 
	 * @return boolean
	 * @category Examples torus
	 */
	public static boolean ExampleTorus_Torus() {
		JunOpenGL3dObject.Torus().show();
		JunOpenGL3dObject.Torus_radius_(8, 4).show();
		JunOpenGL3dObject.Torus_divisions_radius_divisions_(8, 24, 2, 10).show();
		JunOpenGL3dObject.TorusRadius_tubeRadius_(1, 0.4).showIn_(new Rectangle(200, 200, 400, 400));
		return true;
	}

	/**
	 * Show the 3D objects using hedron.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @param aHedron jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGLDisplayModel ShowHedron_(JunOpenGL3dObject aHedron) {
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		System.out.println(aHedron.name());
		Jun3dPoint[] pointSet = aHedron.asPointSet();
		System.out.println("number of vertexes: " + pointSet.length);
		System.out.println("number of faces: " + aHedron.numberOfPolygons());
		for (int i = 0; i < pointSet.length; i++) {
			double distance = pointSet[i].distance_(originPoint);
			System.out.print(String.valueOf(distance) + " ");
			System.out.flush();
		}

		aHedron.paint_(StColorValue.VeryDarkGray);
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(aHedron);
		displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
		displayModel.defaultEyePoint_(new Jun3dPoint(10, 10, 10));
		displayModel.defaultProjection_($("perspectiveProjection"));
		displayModel.defaultPresentation_($("hiddenlinePresentation"));
		displayModel.open();
		return displayModel;
	}

	/**
	 * Show the 3D objects with axes using hedron.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @param aHedron jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGLDisplayModel ShowHedronWithAxes_(JunOpenGL3dObject aHedron) {
		System.out.println(aHedron.name());
		Jun3dPoint[] pointSet = aHedron.asPointSet();
		System.out.println("number of vertexes: " + pointSet.length);
		System.out.println("number of faces: " + aHedron.numberOfPolygons());

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		aHedron.paint_(StColorValue.VeryDarkGray);
		compoundObject.add_(aHedron);
		compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(new Jun3dPoint(2, 2, 2)));

		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(compoundObject);
		displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
		displayModel.defaultEyePoint_(new Jun3dPoint(10, 10, 10));
		displayModel.defaultProjection_($("perspectiveProjection"));
		displayModel.defaultPresentation_($("hiddenlinePresentation"));
		displayModel.open();
		return displayModel;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGL3dObjectTestExamples();
	}
}
