package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import jp.co.sra.jun.collections.sequences.*;
import jp.co.sra.jun.geometry.basic.*;

/**
 * JunOpenGL3dNurbsSurfaceTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/01/20 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dNurbsSurfaceTestExamples.java,v 8.10 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dNurbsSurfaceTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunOpenGL3dNurbsSurface nurbs = ExampleBSplineSurface();
		nurbs.name_("example");
		nurbs.paint_(Color.red);
		nurbs.show();
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunOpenGL3dNurbsSurface nurbs = ExampleNurbsSurface();
		nurbs.name_("example");
		nurbs.paint_(Color.blue);
		nurbs.show();
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example7() {
		JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
		JunOpenGL3dNurbsSurface nurbs = ExampleNurbsSurface();
		nurbs.name_("red");
		nurbs.paint_(Color.red);
		body.add_(nurbs);
		nurbs = ExampleNurbsSurface();
		nurbs.name_("blue");
		nurbs.paint_(Color.blue);
		nurbs = (JunOpenGL3dNurbsSurface) nurbs.rotatedBy_(JunAngle.FromRad_(60));
		body.add_(nurbs);
		body.show();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunOpenGL3dNurbsSurfaceTestExamples();
	}

	/**
	 * Create an instance of JunOpenGL3dNurbsSurface which represents a
	 * B-Spline surface.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface
	 */
	protected static JunOpenGL3dNurbsSurface ExampleBSplineSurface() {
		JunMatrix controlPoints = new JunMatrix(4);
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				double x = ((i - 1.5) * 2) / 3;
				double y = ((j - 1.5) * 2) / 3;
				double z = ((i == 1 || i == 2) && (j == 1 || j == 2)) ? 1 : -1;
				controlPoints._put(i, j, new Jun3dPoint(x, y, z));
			}
		}
		double[] knots = { 0.0, 0.0, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0 };

		return JunOpenGL3dNurbsSurface.BSplineControlPoints_uKnotVector_vKnotVector_(controlPoints, knots, knots);
	}

	/**
	 * Create an instance of JunOpenGL3dNurbsSurface which represents a NURBS
	 * surface.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface
	 */
	protected static JunOpenGL3dNurbsSurface ExampleNurbsSurface() {
		JunMatrix controlPoints = new JunMatrix(4);
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				double x = ((i - 1.5) * 2) / 3;
				double y = ((j - 1.5) * 2) / 3;
				double z = ((i == 1 || i == 2) && (j == 1 || j == 2)) ? 1 : -1;
				controlPoints._put(i, j, new Jun3dPoint(x, y, z));
			}
		}
		double[] weights = new double[16];
		for (int i = 0; i < 16; i++) {
			weights[i] = ((i + 1) / 4 + 1) / 2.0;
		}
		double[] knots = { 0.0, 0.0, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0 };

		return new JunOpenGL3dNurbsSurface(controlPoints, new JunDoubleMatrix(4, weights), knots, knots);
	}
}
