package jp.co.sra.jun.opengl.lights;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLPointLight class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1999/5/10 (by Hirotsugu Kondo)
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLPointLight.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLPointLight extends JunOpenGLLight {

	protected Jun3dPoint position;

	/**
	 * Create a new instance of JunOpenGLPointLight and initialize it.
	 *
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGLPointLight(Jun3dPoint a3dPoint, Color aColor, float aNumber) {
		this.setPosition_color_alpha_(a3dPoint, aColor, aNumber);
	}

	/**
	 * Create a new instance of JunOpenGLPointLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLPointLight
	 * @category Instance creation
	 */
	public static JunOpenGLPointLight At3dPoint_(Jun3dPoint a3dPoint) {
		return At3dPoint_color_(a3dPoint, DefaultColor());
	}

	/**
	 * Create a new instance of JunOpenGLPointLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLPointLight
	 * @category Instance creation
	 */
	public static JunOpenGLPointLight At3dPoint_color_(Jun3dPoint a3dPoint, Color aColor) {
		return At3dPoint_color_alpha_(a3dPoint, aColor, DefaultAlpha());
	}

	/**
	 * Create a new instance of JunOpenGLPointLight and initialize it.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLPointLight
	 * @category Instance creation
	 */
	public static JunOpenGLPointLight At3dPoint_color_alpha_(Jun3dPoint a3dPoint, Color aColor, float aNumber) {
		return new JunOpenGLPointLight(a3dPoint, aColor, aNumber);
	}

	/**
	 * Answer my current position.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public final Jun3dPoint position() {
		return position;
	}

	/**
	 * Set my new position.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public final void position_(Jun3dPoint a3dPoint) {
		position = a3dPoint;
	}

	/**
	 * Lighting on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#lightingOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category lighting
	 */
	public void lightingOn_(JunOpenGLRenderingContext aRenderingContext) {
		int index = aRenderingContext.getLightIndex();
		aRenderingContext.lightIndex_position_direction_cutoffAngle_color_alpha_(index, this.position(), null, null, this.color(), this.alpha());
		aRenderingContext.enableLightIndex_(index);
		aRenderingContext.enableLighting();
	}

	/**
	 * Transformation on the light.
	 * 
	 * @param aJun3dTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLLight
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#transform_(jp.co.sra.jun.geometry.transformations.Jun3dTransformation)
	 * @category transforming
	 */
	public JunOpenGLLight transform_(Jun3dTransformation aJun3dTransformation) {
		JunOpenGLPointLight transformed = (JunOpenGLPointLight) this.copy();
		transformed.position_(this.position().transform_(aJun3dTransformation));
		return transformed;
	}

	/**
	 * Set the position, color and alpha.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category private
	 */
	protected void setPosition_color_alpha_(Jun3dPoint a3dPoint, Color aColor, float aNumber) {
		position = a3dPoint;
		color = aColor;
		alpha = aNumber;
	}

}
