package jp.co.sra.jun.opengl.lights;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLLightTestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLLightTestExamples.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLLightTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * ManualExample1a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1a() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				aRenderingContext.clear();
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(10, 10, 10));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
				aCube.paint_(Color.magenta);
				aProjector.project_on_(aCube, aRenderingContext);
				aCube.renderOn_(aRenderingContext);
				aRenderingContext.flush();
			}
		}.open();

		return true;
	}

	/**
	 * ManualExample1b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1b() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				aRenderingContext.clear();
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(10, 10, 10));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
				aCube.paint_(Color.magenta);
				JunOpenGLAmbientLight anAmbientLight = JunOpenGLAmbientLight.Color_(Color.lightGray);
				aProjector.project_on_(aCube, aRenderingContext);
				anAmbientLight.lightingOn_(aRenderingContext);
				aCube.renderOn_(aRenderingContext);
				aRenderingContext.flush();
			}
		}.open();

		return true;
	}

	/**
	 * ManualExample2a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample2a() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				aRenderingContext.clear();
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Globe();
				aGlobe.paint_(Color.magenta);
				aProjector.project_on_(aGlobe, aRenderingContext);
				aGlobe.renderOn_(aRenderingContext);
				aRenderingContext.flush();
			}
		}.open();

		return true;
	}

	/**
	 * ManualExample2b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample2b() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				aRenderingContext.clear();
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Globe();
				aGlobe.paint_(Color.magenta);
				JunOpenGLParallelLight aParallelLight = JunOpenGLParallelLight.At3dPoint_color_(new Jun3dPoint(1.0, 1.0, 1.0), Color.lightGray);
				aProjector.project_on_(aGlobe, aRenderingContext);
				aParallelLight.lightingOn_(aRenderingContext);
				aGlobe.renderOn_(aRenderingContext);
				aRenderingContext.flush();
			}
		}.open();

		return true;
	}

	/**
	 * ManualExample3a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3a() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				aRenderingContext.clear();
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Globe();
				aGlobe.paint_(Color.magenta);
				aProjector.project_on_(aGlobe, aRenderingContext);
				aGlobe.renderOn_(aRenderingContext);
				aRenderingContext.flush();
			}
		}.open();

		return true;
	}

	/**
	 * ManualExample3b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3b() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				aRenderingContext.clear();
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Globe();
				aGlobe.paint_(Color.magenta);
				JunOpenGLSpotLight aSpotLight = JunOpenGLSpotLight.At3dPoint_color_(new Jun3dPoint(0.0, 0.0, 10.0), Color.lightGray);
				aProjector.project_on_(aGlobe, aRenderingContext);
				aSpotLight.lightingOn_(aRenderingContext);
				aGlobe.renderOn_(aRenderingContext);
				aRenderingContext.flush();
			}
		}.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunOpenGLLightTestExamples();
	}

}
