package jp.co.sra.jun.opengl.illusion;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLIllusion01 class
 * 
 *  @author    nisinaka
 *  @created   2004/09/27 (by nisinaka)
 *  @updated   2006/10/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun655 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLIllusion01.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLIllusion01 extends JunOpenGLIllusion {
	/**
	 * Answer my default frame factors of stages.
	 * 
	 * @return java.uitl.List
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#defaultFramesOfStages()
	 * @category defaults
	 */
	protected List defaultFramesOfStages() {
		ArrayList aList = new ArrayList(5);
		aList.add(new Integer(5));
		aList.add(new Integer(11));
		aList.add(new Integer(5));
		aList.add(new Integer(11));
		aList.add(new Integer(5));
		return aList;
	}

	/**
	 * Create my flux model.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#makeFluxModel()
	 * @category making
	 */
	protected JunOpenGLFluxModel makeFluxModel() {
		JunOpenGLFluxObject aFluxObject = new JunOpenGLFluxObject();
		aFluxObject.addMutable_(this.smallCube11());
		aFluxObject.addMutable_(this.smallCube12());
		aFluxObject.addMutable_(this.smallCube13());
		aFluxObject.addMutable_(this.smallCube14());
		aFluxObject.addMutable_(this.smallCube21());
		aFluxObject.addMutable_(this.smallCube22());
		aFluxObject.addMutable_(this.smallCube23());
		aFluxObject.addMutable_(this.smallCube24());
		aFluxObject.addMutable_(this.largeCubes());
		return new JunOpenGLFluxModel(aFluxObject);
	}

	/**
	 * Create a small cube at 11.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube11() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-2, 0, 0), new Jun3dPoint(-4, 1, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-4, 1, 0), new Jun3dPoint(-4, 1, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-4, 1, 0), new Jun3dPoint(-4, 1, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-4, 1, 0), new Jun3dPoint(-4, 1, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-4, 1, 0), new Jun3dPoint(-2, 0, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 12.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube12() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-1, 0, 0), new Jun3dPoint(-2, 1, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-2, 1, 0), new Jun3dPoint(-2, 1, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-2, 1, 0), new Jun3dPoint(-2, 1, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-2, 1, 0), new Jun3dPoint(-2, 1, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-2, 1, 0), new Jun3dPoint(-1, 0, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 13.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube13() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 1, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 1, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 1, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 14.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube14() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(1, 0, 0), new Jun3dPoint(2, 1, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(2, 1, 0), new Jun3dPoint(2, 1, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(2, 1, 0), new Jun3dPoint(2, 1, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(2, 1, 0), new Jun3dPoint(2, 1, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(2, 1, 0), new Jun3dPoint(1, 0, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 21.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube21() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-2, -2, 0), new Jun3dPoint(-3, -3, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-3, -3, 0), new Jun3dPoint(-3, -3, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-3, -3, 0), new Jun3dPoint(-3, -3, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-3, -3, 0), new Jun3dPoint(-3, -3, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-3, -3, 0), new Jun3dPoint(-2, -2, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 22.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube22() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-1, -2, 0), new Jun3dPoint(-1, -3, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-1, -3, 0), new Jun3dPoint(-1, -3, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-1, -3, 0), new Jun3dPoint(-1, -3, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-1, -3, 0), new Jun3dPoint(-1, -3, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(-1, -3, 0), new Jun3dPoint(-1, -2, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 23.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube23() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, -2, 0), new Jun3dPoint(1, -3, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(1, -3, 0), new Jun3dPoint(1, -3, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(1, -3, 0), new Jun3dPoint(1, -3, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(1, -3, 0), new Jun3dPoint(1, -3, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(1, -3, 0), new Jun3dPoint(0, -2, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a small cube at 24.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject smallCube24() {
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(this.smallCube());

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(1, -2, 0), new Jun3dPoint(3, -3, 0), this.framesOfStageAt_(1));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(3, -3, 0), new Jun3dPoint(3, -3, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(3, -3, 0), new Jun3dPoint(3, -3, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(3, -3, 0), new Jun3dPoint(3, -3, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(3, -3, 0), new Jun3dPoint(1, -2, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a default small cube.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category parts
	 */
	protected JunOpenGL3dObject smallCube() {
		Jun3dBoundingBox aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 2, 1));
		aBox = aBox.expandedBy_(0.001);
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Origin_corner_(aBox.origin(), aBox.corner());
		aCube.paint_(Color.lightGray);
		return aCube;
	}

	/**
	 * Create large cubes.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject largeCubes() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(this.largeCube().translatedBy_(new Jun3dPoint(-4, 6, 0)));
		compoundObject.add_(this.largeCube().translatedBy_(new Jun3dPoint(-2, 6, 0)));
		compoundObject.add_(this.largeCube().translatedBy_(new Jun3dPoint(0, 6, 0)));
		compoundObject.add_(this.largeCube().translatedBy_(new Jun3dPoint(2, 6, 0)));
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(compoundObject);
		int step = this.framesOfStageAt_(1);
		for (int i = 0; i < step; i++) {
			mutableObject.add_(Jun3dTransformation.Unity());
		}

		Jun3dTransformation[] transformations;
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, -11, 0), this.framesOfStageAt_(2));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, -11, 0), new Jun3dPoint(0, -11, 0), this.framesOfStageAt_(3));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, -11, 0), new Jun3dPoint(0, -22, 0), this.framesOfStageAt_(4));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}
		transformations = this.transformationsFrom_to_step_(new Jun3dPoint(0, -22, 0), new Jun3dPoint(0, -22, 0), this.framesOfStageAt_(5));
		for (int i = 0; i < transformations.length; i++) {
			mutableObject.add_(transformations[i]);
		}

		return mutableObject;
	}

	/**
	 * Create a default large cube.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category parts
	 */
	protected JunOpenGL3dObject largeCube() {
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Box().scaledBy_(new Jun3dPoint(1, 10, 1));
		aCube.paint_(Color.black);
		return aCube;
	}
}
