package jp.co.sra.jun.opengl.grapher;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dArcTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/12/15 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dArcTestExamples.java,v 8.10 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGL3dArcTestExamples extends JunTestExamples {
	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dNode node1 = JunOpenGL3dNode.Location_extent_color_(new Jun3dPoint(10, 0, 0), new Jun3dPoint(1, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node2 = JunOpenGL3dNode.Location_extent_color_(new Jun3dPoint(0, 0, 20), new Jun3dPoint(1, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dArc arc = JunOpenGL3dArc.From_to_color_(node1, node2, JunOpenGL3dObject.SampleColor());
		JunOpenGLDisplayModel.Show_(arc);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGL3dNode node1 = JunOpenGL3dNode.Location_extent_color_(new Jun3dPoint(10, 0, 0), new Jun3dPoint(1, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dNode node2 = JunOpenGL3dNode.Location_extent_color_(new Jun3dPoint(0, 0, 20), new Jun3dPoint(1, 1, 1), JunOpenGL3dObject.SampleColor());
		JunOpenGL3dArc arc = JunOpenGL3dArc.From_to_color_(node1, node2, JunOpenGL3dObject.SampleColor());
		arc.crank_(true);

		JunLispList list = arc.showLispList();
		arc = new JunOpenGL3dArc(list);
		arc.showLispList();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunOpenGL3dArcTestExamples();
	}
}
