package jp.co.sra.jun.opengl.flux;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLFluxObjectTestExamples class
 * 
 *  @author    BNR
 *  @created   1999/07/26 (by BNR)
 *  @updated   2006/10/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxObjectTestExamples.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLFluxObjectTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * ManualExample1:
	 * 
	 * @return boolean
	 */
	public static boolean ManualExample1() {
		JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Box();
		for (int i = 0; i < anObject.components().length; i++) {
			anObject.components()[i].paint_(Color.red);
		}
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(anObject);
		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addMutable_(mutableObject);
		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.open();

		return true;
	}

	/**
	 * ManualExample2:
	 * 
	 * @return boolean
	 */
	public static boolean ManualExample2() {
		JunOpenGL3dObject moonObject = JunOpenGL3dObject.Sphere_(30);
		moonObject = moonObject.scaledBy_(0.3);
		moonObject = moonObject.translatedBy_(new Jun3dPoint(0, 5, 0));
		moonObject.paint_(Color.yellow);
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(moonObject);
		int angleDegrees = 10;
		for (int degrees = 0; degrees < (360 - angleDegrees); degrees += angleDegrees) {
			Jun3dTransformation aT = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees));
			mutableObject.add_(aT);
		}
		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addMutable_(mutableObject);
		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.open();

		return true;
	}

	/**
	 * ManualExample3:
	 * 
	 * @return boolean
	 */
	public static boolean ManualExample3() {
		JunOpenGL3dObject earthObject = JunOpenGL3dObject.Sphere_(20);
		earthObject.paint_(Color.cyan);
		JunOpenGLFluxImmutableObject immutableObject = new JunOpenGLFluxImmutableObject(earthObject);
		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(immutableObject);
		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.open();

		return true;
	}

	/**
	 * ManualExample4:
	 * 
	 * @return boolean
	 */
	public static boolean ManualExample4() {
		JunOpenGL3dObject earthObject = JunOpenGL3dObject.Sphere_(20);
		earthObject.paint_(Color.cyan);
		JunOpenGLFluxImmutableObject immutableObject = new JunOpenGLFluxImmutableObject(earthObject);
		JunOpenGL3dObject moonObject = JunOpenGL3dObject.Sphere_(30);
		moonObject = moonObject.scaledBy_(0.3);
		moonObject = moonObject.translatedBy_(new Jun3dPoint(0, 5, 0));
		moonObject.paint_(Color.yellow);
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(moonObject);
		int angleDegrees = 10;
		for (int degrees = 0; degrees < (360 - angleDegrees); degrees += angleDegrees) {
			Jun3dTransformation aT = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees));
			mutableObject.add_(aT);
		}
		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(immutableObject);
		fluxObject.addMutable_(mutableObject);
		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunOpenGLFluxObjectTestExamples();
	}

}
