package jp.co.sra.jun.opengl.flux;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayController;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLFluxModelTestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   2006/10/13 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun678 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxModelTestExamples.java,v 8.15 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLFluxModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example: Open a flux model.
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		JunOpenGLFluxModel model = new JunOpenGLFluxModel();
		model.open();

		return true;
	}

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		anObject.do_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.red);
				return null;
			}
		});
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(anObject);

		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addMutable_(mutableObject);

		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.framesPerSecond_(5);
		fluxModel.open();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Eddy();
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(anObject);

		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addMutable_(mutableObject);

		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().backAndForth();
		fluxModel.framesPerSecond_(8);
		fluxModel.open();
		fluxModel.start();

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunOpenGL3dObject earthObject = JunOpenGL3dObject.Sphere_(20);
		earthObject.paint_(Color.cyan);
		JunOpenGLFluxImmutableObject immutableObject = new JunOpenGLFluxImmutableObject(earthObject);

		JunOpenGL3dObject moonObject = JunOpenGL3dObject.Sphere_(30);
		moonObject = moonObject.scaledBy_(0.3);
		moonObject = moonObject.translatedBy_(new Jun3dPoint(0, 5, 0));
		moonObject.paint_(Color.yellow);
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(moonObject);
		int angleDegrees = 10;
		for (int degrees = 0; degrees < (360 - angleDegrees); degrees += angleDegrees) {
			Jun3dTransformation aT = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees));
			mutableObject.add_(aT);
		}

		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(immutableObject);
		fluxObject.addMutable_(mutableObject);

		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.open();
		fluxModel.start();

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunOpenGL3dObject object = JunOpenGL3dObject.Sphere_(15);
		object.paint_(Color.cyan);
		JunOpenGLFluxImmutableObject earthObject = new JunOpenGLFluxImmutableObject(object);

		object = JunOpenGL3dObject.Sphere_(15);
		object = object.scaledBy_(0.3);
		object = object.translatedBy_(new Jun3dPoint(0, 5, 0));
		object.paint_(Color.yellow);
		JunOpenGLFluxMutableObject firstMoonObject = new JunOpenGLFluxMutableObject(object);

		object = JunOpenGL3dObject.Sphere_(30);
		object = object.scaledBy_(0.3);
		object = object.translatedBy_(new Jun3dPoint(0, -3, 0));
		object = object.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30)));
		object.paint_(Color.magenta);
		JunOpenGLFluxMutableObject secondMoonObject = new JunOpenGLFluxMutableObject(object);

		int angleDegrees = 10;
		for (int degrees = 0; degrees < (360 - angleDegrees); degrees += angleDegrees) {
			Jun3dTransformation aT = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees));
			firstMoonObject.add_(aT);

			Jun3dPoint fromPoint = earthObject.boundingBox().center();
			Jun3dPoint toPoint = secondMoonObject.boundingBox().center();
			toPoint = toPoint.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90)));
			Jun3dLine aLine = new Jun3dLine(fromPoint, toPoint);
			aT = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(degrees), aLine);
			secondMoonObject.add_(aT);
		}

		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(earthObject);
		fluxObject.addMutable_(firstMoonObject);
		fluxObject.addMutable_(secondMoonObject);

		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.open();
		fluxModel.start();

		return true;
	}

	/**
	 * Example5: 
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunOpenGL3dObject object = JunOpenGL3dObject.Sphere_(15);
		object.paint_(Color.cyan);
		JunOpenGLFluxImmutableObject earthObject = new JunOpenGLFluxImmutableObject(object);

		object = JunOpenGL3dObject.Sphere_(15);
		object = object.scaledBy_(0.3);
		object = object.translatedBy_(new Jun3dPoint(0, 5, 0));
		object.paint_(Color.yellow);
		JunOpenGLFluxMutableObject firstMoonObject = new JunOpenGLFluxMutableObject(object);

		object = JunOpenGL3dObject.Sphere_(30);
		object = object.scaledBy_(0.3);
		object = object.translatedBy_(new Jun3dPoint(0, -3, 0));
		object = object.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30)));
		object.paint_(Color.magenta);
		JunOpenGLFluxMutableObject secondMoonObject = new JunOpenGLFluxMutableObject(object);

		int angleDegrees = 10;
		for (int degrees = 0; degrees < (360 - angleDegrees); degrees += angleDegrees) {
			Jun3dTransformation aT = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees));
			firstMoonObject.add_(aT);

			Jun3dPoint fromPoint = earthObject.boundingBox().center();
			Jun3dPoint toPoint = secondMoonObject.boundingBox().center();
			toPoint = toPoint.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90)));
			Jun3dLine aLine = new Jun3dLine(fromPoint, toPoint);
			aT = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(degrees), aLine);
			secondMoonObject.add_(aT);
		}

		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(earthObject);
		fluxObject.addMutable_(firstMoonObject);
		fluxObject.addMutable_(secondMoonObject);

		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.open();
		fluxModel.saveAsMovie();

		return true;
	}

	/**
	 * Example6: 
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		final double mobiusRadius = 3.0 / 4.0;
		final double stripRadius = 1.0 / 4.0;
		final int mobiusDivisions = 72;
		final int stripDivisions = 12;
		final double ballRadius = 0.05;
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		JunOpenGL3dObject mobius = JunOpenGL3dObject.MobiusStripRadius_divisions_stripRadius_divisions_(mobiusRadius, mobiusDivisions, stripRadius, stripDivisions);
		mobius.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
				each.halftone_(0.75);
				each.paint_(StColorValue.Brightness_(0.9));
				return null;
			}
		});
		compoundObject.add_(mobius);

		JunOpenGLFluxImmutableObject mobiusStrip = new JunOpenGLFluxImmutableObject(compoundObject);
		final JunOpenGL3dObject theBall = JunOpenGL3dObject.Ball_(1).scaledBy_(ballRadius);
		final JunOpenGL3dCompoundObject mobiusLocus = new JunOpenGL3dCompoundObject();
		JunOpenGL3dObject.MobiusRadius_divisions_stripRadius_locusDo_(mobiusRadius, mobiusDivisions, stripRadius, new StBlockClosure() {
			public Object valueWithArguments_(Object[] anArray) {
				Jun3dPoint locusPoint = (Jun3dPoint) anArray[0];
				// Jun3dPoint rightVector = (Jun3dPoint) anArray[1];
				Jun3dPoint upVector = (Jun3dPoint) anArray[2];
				float normalizedValue = ((Number) anArray[3]).floatValue();

				JunOpenGL3dObject aBall = theBall.translatedBy_(locusPoint).translatedBy_(upVector.multipliedBy_(ballRadius));
				aBall.paint_(Color.getHSBColor(normalizedValue, 1f, 1f));
				mobiusLocus.add_(aBall);
				return null;
			}
		});

		JunOpenGLFluxMutableObject mobiusLocus2 = new JunOpenGLFluxMutableObject(mobiusLocus);
		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(mobiusStrip);
		fluxObject.addMutable_(mobiusLocus2);
		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.framesPerSecond_(10);
		fluxModel.open();
		fluxModel.start();
		fluxModel.grabButton().value_(true);
		JunOpenGLDisplayController aController = (JunOpenGLDisplayController) fluxModel.getController();
		aController.movementVector_(new Jun2dPoint(0.025, 0.0));
		aController.createMovementProcess();

		return true;
	}

	/**
	 * Example_fps: 
	 * 
	 * @return boolean
	 */
	public static boolean Example_fps() {
		JunOpenGL3dObject object = JunOpenGL3dObject.Sphere_(15);
		object.paint_(Color.cyan);
		JunOpenGLFluxImmutableObject earthObject = new JunOpenGLFluxImmutableObject(object);

		object = JunOpenGL3dObject.Sphere_(15);
		object = object.scaledBy_(0.3);
		object = object.translatedBy_(new Jun3dPoint(0, 5, 0));
		object.paint_(Color.yellow);
		JunOpenGLFluxMutableObject firstMoonObject = new JunOpenGLFluxMutableObject(object);

		object = JunOpenGL3dObject.Sphere_(30);
		object = object.scaledBy_(0.3);
		object = object.translatedBy_(new Jun3dPoint(0, -3, 0));
		object = object.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30)));
		object.paint_(Color.magenta);
		JunOpenGLFluxMutableObject secondMoonObject = new JunOpenGLFluxMutableObject(object);

		int angleDegrees = 10;
		for (int degrees = 0; degrees < (360 - angleDegrees); degrees += angleDegrees) {
			Jun3dTransformation aT = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees));
			firstMoonObject.add_(aT);

			Jun3dPoint fromPoint = earthObject.boundingBox().center();
			Jun3dPoint toPoint = secondMoonObject.boundingBox().center();
			toPoint = toPoint.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(90)));
			Jun3dLine aLine = new Jun3dLine(fromPoint, toPoint);
			aT = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(degrees), aLine);
			secondMoonObject.add_(aT);
		}

		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(earthObject);
		fluxObject.addMutable_(firstMoonObject);
		fluxObject.addMutable_(secondMoonObject);

		JunOpenGLFluxModel fluxModel = new JunOpenGLFluxModel(fluxObject);
		fluxModel.trackerModel().loop();
		fluxModel.framesPerSecond_(1000);

		fluxModel.superimposeBlock_(new StBlockClosure() {
			Font font = new Font("SansSerif", Font.BOLD, 24);
			DecimalFormat format = new DecimalFormat("####.00");
			long startTime;
			int count;
			float fps;

			public Object value_(Object o1) {
				Graphics aGraphics = (Graphics) o1;

				if (startTime == 0) {
					startTime = System.currentTimeMillis();
				}
				if (++count == 30) {
					long endTime = System.currentTimeMillis();
					fps = 30.0f / (float) (endTime - startTime) * 1000;
					count = 0;
					startTime = System.currentTimeMillis();
				}
				if (fps > 0) {
					aGraphics.setColor(Color.black);
					aGraphics.setFont(font);
					aGraphics.drawString("FPS: " + format.format(fps), 10, 30);
				}

				return null;
			}
		});

		fluxModel.open();
		fluxModel.start();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunOpenGLFluxModelTestExamples();
	}
}
