package jp.co.sra.jun.opengl.flux;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunOpenGLFluxAbstract class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/25 (by MATSUDA Ryouichi)
 *  @updated   2004/11/12 (by Mitsuhiro Asada)
 *  @updated   2006/10/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxAbstract.java,v 8.12 2008/02/20 06:32:34 nisinaka Exp $
 */
public abstract class JunOpenGLFluxAbstract extends JunAbstractObject {

	protected JunOpenGL3dObject originalObject;

	/**
	 * Create a new instance of <code>JunOpenGLFluxAbstract</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGLFluxAbstract() {
		super();
	}

	/**
	 * Create a new instance of <code>JunOpenGLFluxAbstract</code> and initialize it.
	 *
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Instance creation
	 */
	public JunOpenGLFluxAbstract(JunOpenGL3dObject a3dObject) {
		this();
		this.originalObject_(a3dObject);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		originalObject = null;
	}

	/**
	 * Answer my current original object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject originalObject() {
		return originalObject;
	}

	/**
	 * Set my new original object.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public void originalObject_(JunOpenGL3dObject a3dObject) {
		originalObject = a3dObject;
		this.flushBounds();
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category bounds accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		return this.preferredBoundingBox();
	}

	/**
	 * Answer my preferred bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category bounds accessing
	 */
	public abstract Jun3dBoundingBox preferredBoundingBox();

	/**
	 * Flush my bounds.
	 * 
	 * @category bounds accessing
	 */
	public void flushBounds() {
	}

	/**
	 * Answer the receiver as an array of points.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category converting
	 */
	public Jun3dPoint[] asPointArray() {
		final ArrayList aList = new ArrayList();
		this.pointsDo_(new StBlockClosure() {
			public Object value_(Object point) {
				aList.add(point);
				return null;
			}
		});
		return (Jun3dPoint[]) aList.toArray(new Jun3dPoint[aList.size()]);
	}

	/**
	 * Enumerate every points and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public abstract void pointsDo_(StBlockClosure aBlock);

	/**
	 * Answer the StSymbol which represents the kind of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category lisp support
	 */
	public StSymbol kindName() {
		return this._className();
	}

	/**
	 * Create an instance of JunLispCons.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public JunLispCons lispCons() {
		return (JunLispCons) JunLispCons.Cell();
	}

	/**
	 * Create an instance of JunLispNil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispNil
	 * @category lisp support
	 */
	public JunLispNil lispNil() {
		return (JunLispNil) JunLispNil.NullList();
	}

	/**
	 * Convert the receiver as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public abstract JunLispCons toLispList();

	/**
	 * Convert the transformation as a lisp list.
	 * 
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected JunLispList transformationToLispList_(Jun3dTransformation aTransformation) {
		return JunOpenGL3dObject.TransformationToLispList_(aTransformation);
	}

	/**
	 * Popup a window which displays the Lisp List of the receiver.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public JunLispList showLispList() {
		return this.showLispList_(this.toLispList());
	}

	/**
	 * Popup a window which displays the Lisp List.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category lisp support
	 */
	public JunLispList showLispList_(JunLispList aList) {
		try {
			return (JunLispList) _PerformWith(this.getClass(), "ShowLispList_", aList);
		} catch (Exception e) {
			throw new SmalltalkException(e);
		}
	}

	/**
	 * Write the receiver's list representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @category lisp support
	 */
	public void saveOn_(Writer aWriter) throws IOException {
		JunLispList aList = this.toLispList();
		aList.saveOn_(aWriter);
	}

}
