package jp.co.sra.jun.opengl.display;

import java.awt.Point;

import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOpenGLEmbeddedDisplayModel class
 * 
 *  @author    nisinaka
 *  @created   1998/12/17 (by nisinaka)
 *  @updated   1999/06/25 (by nisinaka)
 *  @updated   2003/01/08 (by nisinaka)
 *  @updated   2005/03/02 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLEmbeddedDisplayModel.java,v 8.13 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLEmbeddedDisplayModel extends JunOpenGLDisplayModel {
	/**
	 * The flag to determine whether the receiver is needed to be fit when a
	 * window is resized.
	 */
	protected transient boolean needsToFit = true;

	/**
	 * Create a new instance of <code>JunOpenGLEmbeddedDisplayModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGLEmbeddedDisplayModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunOpenGLEmbeddedDisplayModel</code> and set the JunOpenGL3dObject.
	 * 
	 * @param anOpenGL3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Instance creation
	 */
	public JunOpenGLEmbeddedDisplayModel(JunOpenGL3dObject anOpenGL3dObject) {
		super(anOpenGL3dObject);
	}

	/**
	 * Set the JunOpenGL3dObject to be shown on the receiver.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#displayObject_(jp.co.sra.jun.opengl.objects.JunOpenGL3dObject)
	 * @category accessing
	 */
	public void displayObject_(JunOpenGL3dObject a3dObject) {
		this.needsToFit_(true);
		this.setDisplayObject_(a3dObject);
	}

	/**
	 * Set the flag to determine whether the receiver is needed to be fit when
	 * a window is resized.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void needsToFit_(boolean aBoolean) {
		needsToFit = aBoolean;
	}

	/**
	 * Set the JunOpenGL3dObject to be shown on the receiver.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public void setDisplayObject_(JunOpenGL3dObject a3dObject) {
		if (openGL3dObject == null) {
			this.flushProjector();
		}

		super.displayObject_(a3dObject);

		if (this.needsToFit()) {
			this.fitSilently();
			this.needsToFit_(false);
		}

		this.changed_($("object"));
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunOpenGLEmbeddedDisplayViewAwt(this);
		} else {
			return new JunOpenGLEmbeddedDisplayViewSwing(this);
		}
	}

	/**
	 * Spawn the display model and show the object.
	 * 
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#spawnObject()
	 * @category menu messages
	 */
	public void spawnObject() {
		JunOpenGLDisplayModel displayModel = DisplayObject_(this.getClass().getSuperclass(), this.spawningObject());
		displayModel.displayProjection_((JunOpenGLProjection) this.displayProjection().copy());

		StView view = this.getView();
		if (view == null) {
			displayModel.open();
		} else {
			StRectangle box = new StRectangle(view.topComponent().getBounds());
			StRectangle area = new StRectangle(0, 0, box.width(), box.height());
			area = area.align_with_(area.topLeft(), new Point(box.right() + 5, box.top()));
			displayModel.openIn_(area.toRectangle());
		}

		displayModel.changed_($("object"));
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		StPopupMenu aPopupMenu = new StPopupMenu();
		aPopupMenu.addAll(this._menuBar().menus());
		return aPopupMenu;
	}

	/**
	 * Create a "File" menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#_createFileMenu()
	 * @category resources
	 */
	protected StMenu _createFileMenu() {
		StMenu fileMenu = new StMenu(JunSystem.$String("File"), $("fileMenu"));

		// Save...
		fileMenu.add(new StMenuItem(JunSystem.$String("Save") + "...", $("saveMenu"), new MenuPerformer(this, "saveLST")));

		// Save as...
		StMenu saveAsMenu = new StMenu(JunSystem.$String("Save as..."), $("saveAsMenu"));
		saveAsMenu.add(new StMenuItem("VRML1.0...", new MenuPerformer(this, "saveWRL10")));
		saveAsMenu.add(new StMenuItem("VRML97...", new MenuPerformer(this, "saveWRL97")));
		fileMenu.add(saveAsMenu);

		// Save as image...
		fileMenu.add(new StMenuItem(JunSystem.$String("Save as image..."), $("saveAsImageMenu"), new MenuPerformer(this, "saveAsImage")));

		return fileMenu;
	}

	/**
	 * Answer true if the receiver is needed to be fit when a window is
	 * resized.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean needsToFit() {
		return needsToFit;
	}
}