package jp.co.sra.jun.opengl.display;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunOpenGLDisplayObjectsViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/07/25 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayObjectsViewSwing.java,v 8.12 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayObjectsViewSwing extends JunAbstractViewJPanel implements JunOpenGLDisplayObjectsView {

	protected JunOpenGLDisplayViewSwing viewfinder;
	protected JList methodList;

	/**
	 * Create a new instance of JunOpenGLDisplayObjectsViewSwing and initialize it.
	 *
	 * @param anOpenGLDisplayObjects jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjects
	 * @category Instance creation
	 */
	public JunOpenGLDisplayObjectsViewSwing(JunOpenGLDisplayObjects anOpenGLDisplayObjects) {
		super(anOpenGLDisplayObjects);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		this.setLightWeightPopupEnabled(false);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.viewfinder(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -200, 1f, -1));
		this.add(new JScrollPane(this.methodList()), WindowSpecLayout.Position(1f, -199, 0f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(500, 300));
	}

	/**
	 * Answer my model as JunOpenGLDisplayObjects.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjects
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjectsView#getOpenGLDisplayObjects()
	 * @category model accessing
	 */
	public JunOpenGLDisplayObjects getOpenGLDisplayObjects() {
		return (JunOpenGLDisplayObjects) this.model();
	}

	/**
	 * Answer the viewfinder.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing
	 * @category user interface
	 */
	protected JunOpenGLDisplayViewSwing viewfinder() {
		if (viewfinder == null) {
			viewfinder = new JunOpenGLDisplayViewSwing(this.getOpenGLDisplayObjects());
		}
		return viewfinder;
	}

	/**
	 * Answer the method list.
	 * 
	 * @return javax.swing.JList
	 * @category user interface
	 */
	protected JList methodList() {
		if (methodList == null) {
			methodList = new JList(new DefaultListModel());
			methodList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			methodList.addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent e) {
					if (e.getValueIsAdjusting()) {
						return;
					}

					getOpenGLDisplayObjects().selectionIndex_(methodList.getSelectedIndex());
				}
			});
			methodList.setCellRenderer(new DefaultListCellRenderer() {
				public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
					Method aMethod = (Method) value;
					String classname = aMethod.getDeclaringClass().getName();
					classname = classname.substring(classname.lastIndexOf('.') + 1);
					value = "<HTML><B>" + aMethod.getName() + "</B> {" + classname + "}</HTML>";
					return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
				}
			});

			this.updateMethodList();
		}
		return methodList;
	}

	/**
	 * Update for the change notice.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StViewJPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("methods")) {
			this.updateMethodList();
		} else {
			super.update_(e);
		}
	}

	/**
	 * Update the method list.
	 * 
	 * @category updating
	 */
	protected void updateMethodList() {
		DefaultListModel aListModel = (DefaultListModel) this.methodList().getModel();
		aListModel.clear();

		Method[] methods = this.getOpenGLDisplayObjects().methods();
		for (int i = 0; i < methods.length; i++) {
			aListModel.addElement(methods[i]);
		}

		int index = this.getOpenGLDisplayObjects().selectionIndex();
		if (index >= 0) {
			this.methodList().setSelectedIndex(index);
			this.methodList().ensureIndexIsVisible(index);
		}
	}

}
