package jp.co.sra.jun.opengl.display;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOpenGLDisplayLightViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   UNKNOWN
 *  @updated   2000/01/25 (by MATSUDA Ryouichi)
 *  @updated   2003/05/09 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun608 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayLightViewAwt.java,v 8.13 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayLightViewAwt extends JunAbstractViewPanel implements JunOpenGLDisplayLightView {
	protected JunColorChoiceViewAwt colorChoiceView;
	protected CheckboxGroup lightState;
	protected Checkbox lightStateOn;
	protected Checkbox lightStateOff;
	protected CheckboxGroup lightKind;
	protected Checkbox lightKindAmbient;
	protected Checkbox lightKindParallel;
	protected Checkbox lightKindPoint;
	protected Checkbox lightKindSpot;
	protected TextField positionTextValue;
	protected TextField directionTextValue;
	protected TextField cutoffAngleTextValue;

	/**
	 * Create a new instance of <code>JunOpenGLDisplayLightViewAwt</code> and initialize it.
	 * 
	 * @param anOpenGLDisplayLight jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category Instance creation
	 */
	public JunOpenGLDisplayLightViewAwt(JunOpenGLDisplayLight anOpenGLDisplayLight) {
		super(anOpenGLDisplayLight);
	}

	/**
	 * Create a new instance of <code>JunOpenGLDisplayLightViewAwt</code> for an ambient light.
	 *
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightViewAwt
	 * @param anOpenGLDisplayLight jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category Instance creation
	 */
	public static JunOpenGLDisplayLightViewAwt ForAmbientLight(JunOpenGLDisplayLight anOpenGLDisplayLight) {
		return new JunOpenGLDisplayLightViewAwt(anOpenGLDisplayLight) {
			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.colorChoiceView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 127));
				this.add(new Label(JunSystem.$String("Switch") + ":"), WindowSpecLayout.Position(0f, 1, 0f, 128));
				this.add(this.lightStateOn(), WindowSpecLayout.Position(0f, 10, 0f, 151));
				this.add(this.lightStateOff(), WindowSpecLayout.Position(0f, 10, 0f, 174));
				this.setSize(234, 198);
			}
		};
	}

	/**
	 * Create a new instance of <code>JunOpenGLDisplayLightViewAwt</code> for a position light.
	 *
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightViewAwt
	 * @param anOpenGLDisplayLight jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @category Instance creation
	 */
	public static JunOpenGLDisplayLightViewAwt ForPositionLight(JunOpenGLDisplayLight anOpenGLDisplayLight) {
		return new JunOpenGLDisplayLightViewAwt(anOpenGLDisplayLight) {
			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.colorChoiceView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 127));
				this.add(new Label(JunSystem.$String("Switch") + ":"), WindowSpecLayout.Position(0f, 1, 0f, 128));
				this.add(this.lightStateOn(), WindowSpecLayout.Position(0f, 10, 0f, 151));
				this.add(this.lightStateOff(), WindowSpecLayout.Position(0f, 10, 0f, 174));
				this.add(new Label(JunSystem.$String("Kind") + ":"), WindowSpecLayout.Position(0.5f, 1, 0f, 128));
				this.add(this.lightKindParallel(), WindowSpecLayout.Position(0.5f, 10, 0f, 151));
				this.add(this.lightKindPoint(), WindowSpecLayout.Position(0.5f, 10, 0f, 174));
				this.add(this.lightKindSpot(), WindowSpecLayout.Position(0.5f, 10, 0f, 197));
				this.add(new Label(JunSystem.$String("Position") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 220));
				this.add(this.positionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 243, 1f, -1, 0f, 265));
				this.add(new Label(JunSystem.$String("Direction") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 266));
				this.add(this.directionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 289, 1f, -1, 0f, 311));
				this.add(new Label(JunSystem.$String("Cutoff angle") + ": (" + JunSystem.$String("degree") + ")"), WindowSpecLayout.Position(0f, 1, 0f, 312));
				this.add(this.cutoffAngleTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 335, 1f, -1, 0f, 357));
				this.setSize(234, 358);
			}
		};
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.colorChoiceView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 127));
		this.add(new Label(JunSystem.$String("Switch") + ":"), WindowSpecLayout.Position(0f, 1, 0f, 128));
		this.add(this.lightStateOn(), WindowSpecLayout.Position(0f, 10, 0f, 151));
		this.add(this.lightStateOff(), WindowSpecLayout.Position(0f, 10, 0f, 174));
		this.add(new Label(JunSystem.$String("Kind") + ":"), WindowSpecLayout.Position(0.5f, 1, 0f, 128));
		this.add(this.lightKindAmbient(), WindowSpecLayout.Position(0.5f, 10, 0f, 151));
		this.add(this.lightKindParallel(), WindowSpecLayout.Position(0.5f, 10, 0f, 174));
		this.add(this.lightKindPoint(), WindowSpecLayout.Position(0.5f, 10, 0f, 197));
		this.add(this.lightKindSpot(), WindowSpecLayout.Position(0.5f, 10, 0f, 220));
		this.add(new Label(JunSystem.$String("Position") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 242));
		this.add(this.positionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 266, 1f, -1, 0f, 288));
		this.add(new Label(JunSystem.$String("Direction") + ": (x , y , z)"), WindowSpecLayout.Position(0f, 1, 0f, 289));
		this.add(this.directionTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 312, 1f, -1, 0f, 334));
		this.add(new Label(JunSystem.$String("Cutoff angle") + ": (" + JunSystem.$String("degree") + ")"), WindowSpecLayout.Position(0f, 1, 0f, 335));
		this.add(this.cutoffAngleTextValue(), WindowSpecLayout.Position(0f, 1, 0f, 358, 1f, -1, 0f, 380));
		this.setSize(234, 381);
	}

	/**
	 * Answer my color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt
	 * @category interface opening
	 */
	public JunColorChoiceViewAwt colorChoiceView() {
		if (colorChoiceView == null) {
			colorChoiceView = new JunColorChoiceViewAwt(this.getOpenGLDisplayLight().lightColor());
		}
		return colorChoiceView;
	}

	/**
	 * Answer the text field of the cutoff angle text value.
	 *
	 * @return java.awt.TextField
	 * @category interface opening
	 */
	public TextField cutoffAngleTextValue() {
		if (cutoffAngleTextValue == null) {
			cutoffAngleTextValue = new TextField((String) this.getOpenGLDisplayLight().cutoffAngleTextValue().value());
			cutoffAngleTextValue.setVisible(this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
		}
		return cutoffAngleTextValue;
	}

	/**
	 * Answer the text field of the direction text value.
	 *
	 * @return java.awt.TextField
	 * @category interface opening
	 */
	public TextField directionTextValue() {
		if (directionTextValue == null) {
			directionTextValue = new TextField((String) this.getOpenGLDisplayLight().directionTextValue().value());
			directionTextValue.setVisible(this.getOpenGLDisplayLight().lightKind().value() == $("parallel") || this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
		}
		return directionTextValue;
	}

	/**
	 * Answer the checkbox group of the light kinds.
	 *
	 * @return java.awt.CheckboxGroup
	 * @category interface opening
	 */
	public CheckboxGroup lightKind() {
		if (lightKind == null) {
			lightKind = new CheckboxGroup();
		}
		return lightKind;
	}

	/**
	 * Answer the checkbox for the light kind AMBIENT.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox lightKindAmbient() {
		if (lightKindAmbient == null) {
			lightKindAmbient = new Checkbox("Ambient", this.lightKind(), this.getOpenGLDisplayLight().lightKind().value() == $("ambient"));
			lightKindAmbient.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(false);
					directionTextValue().setVisible(false);
					cutoffAngleTextValue().setVisible(false);
					getOpenGLDisplayLight().lightKind().value_($("ambient"));
				}
			});
		}
		return lightKindAmbient;
	}

	/**
	 * Answer the checkbox for the light kind PARALLEL.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox lightKindParallel() {
		if (lightKindParallel == null) {
			lightKindParallel = new Checkbox(JunSystem.$String("Parallel Light", "Parallel"), this.lightKind(), this.getOpenGLDisplayLight().lightKind().value() == $("parallel"));
			lightKindParallel.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(false);
					directionTextValue().setVisible(true);
					cutoffAngleTextValue().setVisible(false);
					getOpenGLDisplayLight().lightKind().value_($("parallel"));
				}
			});
		}
		return lightKindParallel;
	}

	/**
	 * Answer the checkbox for the light kind POINT.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox lightKindPoint() {
		if (lightKindPoint == null) {
			lightKindPoint = new Checkbox(JunSystem.$String("Point Light", "Point"), this.lightKind(), this.getOpenGLDisplayLight().lightKind().value() == $("point"));
			lightKindPoint.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(true);
					directionTextValue().setVisible(false);
					cutoffAngleTextValue().setVisible(false);
					getOpenGLDisplayLight().lightKind().value_($("point"));
				}
			});
		}
		return lightKindPoint;
	}

	/**
	 * Answer the checkbox for the light kind SPOT.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox lightKindSpot() {
		if (lightKindSpot == null) {
			lightKindSpot = new Checkbox(JunSystem.$String("Spot Light", "Spot"), this.lightKind(), this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
			lightKindSpot.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					positionTextValue().setVisible(true);
					directionTextValue().setVisible(true);
					cutoffAngleTextValue().setVisible(true);
					getOpenGLDisplayLight().lightKind().value_($("spot"));
				}
			});
		}
		return lightKindSpot;
	}

	/**
	 * Answer the checkbox group of the light states.
	 *
	 * @return java.awt.CheckboxGroup
	 * @category interface opening
	 */
	public CheckboxGroup lightState() {
		if (lightState == null) {
			lightState = new CheckboxGroup();
		}
		return lightState;
	}

	/**
	 * Answer the checkbox for the light state ON.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox lightStateOff() {
		if (lightStateOff == null) {
			lightStateOff = new Checkbox(JunSystem.$String("Off"), this.lightState(), this.getOpenGLDisplayLight().lightState()._booleanValue() == false);
			lightStateOff.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getOpenGLDisplayLight().beOff();
				}
			});
		}
		return lightStateOff;
	}

	/**
	 * Answer the checkbox for the light state ON.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox lightStateOn() {
		if (lightStateOn == null) {
			lightStateOn = new Checkbox(JunSystem.$String("On"), this.lightState(), this.getOpenGLDisplayLight().lightState()._booleanValue() == true);
			lightStateOn.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getOpenGLDisplayLight().beOn();
				}
			});
		}
		return lightStateOn;
	}

	/**
	 * Answer the TextField of the position text value.
	 *
	 * @return java.awt.TextField
	 * @category interface opening
	 */
	public TextField positionTextValue() {
		if (positionTextValue == null) {
			positionTextValue = new TextField((String) this.getOpenGLDisplayLight().textValue().value());
			positionTextValue.setVisible(this.getOpenGLDisplayLight().lightKind().value() == $("point") || this.getOpenGLDisplayLight().lightKind().value() == $("spot"));
			positionTextValue.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getOpenGLDisplayLight().textValueChanged_(positionTextValue.getText());
				}
			});
		}
		return positionTextValue;
	}

	/**
	 * Answer my model as JunOpenGLDisplayLight.
	 *
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayLightView#getOpenGLDisplayLight()
	 * @category model accessing
	 */
	public JunOpenGLDisplayLight getOpenGLDisplayLight() {
		return (JunOpenGLDisplayLight) this.model();
	}
}
