package jp.co.sra.jun.opengl.display;

import java.awt.Graphics;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderer;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLAngledDisplayViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/10/16 (by m-asada)
 *  @updated   2007/08/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun621 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLAngledDisplayViewAwt.java,v 8.12 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLAngledDisplayViewAwt extends JunOpenGLDisplayViewAwt implements JunOpenGLAngledDisplayView {

	protected JunAngle angle;

	/**
	 * Create a new instance of <code>JunOpenGLAngledDisplayViewAwt</code> and initialize it.
	 * 
	 * @param anOpenGLStereoDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModel
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @category Instance creation
	 */
	public JunOpenGLAngledDisplayViewAwt(JunOpenGLStereoDisplayModel anOpenGLStereoDisplayModel, JunAngle anAngle) {
		super(anOpenGLStereoDisplayModel);
		this.angle_(anAngle);
		this.getOpenGLDrawable().setRenderer(new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				if (angle() == null) {
					getOpenGLStereoDisplayModel().renderOn_(aRenderingContext);
				} else {
					getOpenGLStereoDisplayModel().renderOn_angle_(aRenderingContext, angle());
				}
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
			}
		});
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		angle = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.getOpenGLDrawable().toComponent(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		this.setSize(260, 280);
	}

	/**
	 * Answer the receiver's model as JunOpenGLStereoDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLStereoDisplayModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLAngledDisplayView#getOpenGLStereoDisplayModel()
	 * @category model accessing
	 */
	public JunOpenGLStereoDisplayModel getOpenGLStereoDisplayModel() {
		return (JunOpenGLStereoDisplayModel) this.model();
	}

	/**
	 * Answer the receiver's angle.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunAngle
	 * @category accessing
	 */
	public JunAngle angle() {
		return angle;
	}

	/**
	 * Set the receiver's angle.
	 * 
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @category accessing
	 */
	public void angle_(JunAngle anAngle) {
		angle = anAngle;
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @see jp.co.sra.smalltalk.StViewPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (this.isShowing() == false) {
			return;
		}

		if (e.getAspect() == $("crossing")) {
			this.getOpenGLDrawable().redisplay();
		} else {
			super.update_(e);
		}
	}

}
