package jp.co.sra.jun.opengl.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Map.Entry;

import javax.swing.JPanel;
import javax.swing.JPopupMenu;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunOpenGL3dViewSwing class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/06 (by MATSUDA Ryouichi)
 *  @updated   2002/04/12 (by nisinaka)
 *  @updated   2003/05/15 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2004/12/02 (by Mitsuhiro Asada)
 *  @updated   2005/03/01 (by nisinaka)
 *  @updated   2006/10/04 (by nisinaka)
 *  @updated   2006/10/16 (by m-asada)
 *  @updated   2007/08/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dViewSwing.java,v 8.18 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGL3dViewSwing extends JunAbstractViewJPanel implements JunOpenGL3dView {

	protected JunOpenGLDrawable drawable;

	/**
	 * Create a new instance of JunOpenGL3dViewSwing and initialize it.
	 *
	 * @param anOpenGLModel jp.co.sra.jun.opengl.JunOpenGL3dModel
	 * @category Instance creation
	 */
	public JunOpenGL3dViewSwing(JunOpenGL3dModel anOpenGL3dModel) {
		super(anOpenGL3dModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		drawable = null;
		this.setLightWeightPopupEnabled(false);
	}

	/**
	 * Build the component. 
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.getOpenGLDrawable().toComponent(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		this.setPreferredSize(new Dimension(200, 200));
	}

	/**
	 * Answer my model as JunOpenGL3dModel.
	 * 
	 * @return jp.kidresearch.art.opengl.JunOpenGL3dModel
	 * @see jp.co.sra.jun.opengl.JunOpenGL3dView#getOpenGL3dModel()
	 * @category model accessing
	 */
	public JunOpenGL3dModel getOpenGL3dModel() {
		return (JunOpenGL3dModel) this.model();
	}

	/**
	 * Answer my OpenGL drawable.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLDrawable
	 * @see jp.co.sra.jun.opengl.JunOpenGL3dView#getOpenGLDrawable()
	 * @category accessing
	 */
	public JunOpenGLDrawable getOpenGLDrawable() {
		if (drawable == null) {
			drawable = this.createOpenGLDrawable();
			this.updateBackgroundColor();
		}
		return drawable;
	}

	/**
	 * Convert the model points to the view 3D points sorted by Z.
	 * 
	 * @param modelPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @return java.util.Map.Entry[]
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dView#convertModelPointsToView3dPointsSortedByZ_(jp.co.sra.jun.geometry.basic.Jun3dPoint[])
	 * @category converting
	 */
	public Entry[] convertModelPointsToView3dPointsSortedByZ_(Jun3dPoint[] modelPoints) {
		return this.getOpenGL3dModel().convertModelPointsToView3dPointsSortedByZ_in_(modelPoints, this.getOpenGLDrawable().toComponent().getBounds());
	}

	/**
	 * Update for the change notice.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("backgroundColor")) {
			this.updateBackgroundColor();
		} else {
			this.getOpenGLDrawable().update_(e);
		}
	}

	/**
	 * Update the background color.
	 * 
	 * @category updating
	 */
	protected void updateBackgroundColor() {
		Color aColor = this.getOpenGL3dModel().backgroundColor();
		if (aColor.equals(this.getOpenGLDrawable().toComponent().getBackground()) == false) {
			this.getOpenGLDrawable().toComponent().setBackground(aColor);
		}
	}

	/**
	 * Show the popup menu at the specified point on the view.
	 *
	 * @param x int
	 * @param y int
	 * @see jp.co.sra.smalltalk.StViewPanel#_showPopupMenu(int, int)
	 * @category popup menu
	 */
	public void _showPopupMenu(int x, int y) {
		JPopupMenu popupMenu = this.popupMenuView();
		if (popupMenu != null) {
			popupMenu.show(this.getOpenGLDrawable().toComponent(), x, y);
		}
	}

	/**
	 * Create an OpenGL drawable.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLDrawable
	 * @category private
	 */
	protected JunOpenGLDrawable createOpenGLDrawable() {
		return this.getOpenGL3dModel().createOpenGLDrawable(null);
	}

	/**
	 * Create a bordered panel with the OpenGL drawable.
	 * 
	 * @return javax.swing.JPanel
	 * @category private
	 */
	protected JPanel createOpenGLDrawableOnBorderedPanel() {
		JPanel openGLDrawableOnBorderedPanel = StApplicationModel._JPanelWithBorder();
		openGLDrawableOnBorderedPanel.setLayout(new BorderLayout());
		openGLDrawableOnBorderedPanel.add(this.getOpenGLDrawable().toComponent(), BorderLayout.CENTER);
		return openGLDrawableOnBorderedPanel;
	}

}
