package jp.co.sra.jun.opengl.display;

import java.util.Map.Entry;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunOpenGL3dView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/10 (by MATSUDA Ryouichi)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2004/12/02 (by Mitsuhiro Asada)
 *  @updated   2006/10/04 (by nisinaka)
 *  @updated   2006/10/16 (by m-asada)
 *  @updated   2007/08/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dView.java,v 8.14 2008/02/20 06:32:18 nisinaka Exp $
 */
public interface JunOpenGL3dView extends JunAbstractView {

	/**
	 * Answer my model as JunOpenGL3dModel.
	 * 
	 * @return jp.kidresearch.art.opengl.JunOpenGL3dModel
	 * @category model accessing
	 */
	public JunOpenGL3dModel getOpenGL3dModel();

	/**
	 * Answer my OpenGL drawable.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLDrawable
	 * @category accessing
	 */
	public JunOpenGLDrawable getOpenGLDrawable();

	/**
	 * Convert the model points to the view 3D points sorted by Z.
	 * 
	 * @param modelPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @return java.util.Map.Entry[]
	 * @category converting
	 */
	public Entry[] convertModelPointsToView3dPointsSortedByZ_(Jun3dPoint[] modelPoints);

}
