package jp.co.sra.jun.opengl.cosmos;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing;

/**
 * JunOpenGLMicrocosmViewSwing class
 * 
 *  @author    nisinaka
 *  @created   1999/08/17 (by nisinaka)
 *  @updated   2002/11/14 (by nisinaka)
 *  @updated   2004/09/22 (by nisinaka)
 *  @updated   2007/08/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLMicrocosmViewSwing.java,v 8.14 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGLMicrocosmViewSwing extends JunOpenGLDisplayViewSwing implements JunOpenGLMicrocosmView {

	/**
	 * Create a new instance of <code>JunOpenGLMicrocosmViewSwing</code> and initialize it.
	 * 
	 * @param anOpenGLMicrocosmModel jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmModel
	 * @category Instance creation
	 */
	public JunOpenGLMicrocosmViewSwing(JunOpenGLMicrocosmModel anOpenGLMicrocosmModel) {
		super(anOpenGLMicrocosmModel);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 20, 0f, 1, 1f, -20, 1f, -20));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().pickButton()), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 19, 0f, 19));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().grabButton()), WindowSpecLayout.Position(0f, 1, 0f, 20, 0f, 19, 0f, 38));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().dragButton()), WindowSpecLayout.Position(0f, 1, 0f, 39, 0f, 19, 0f, 57));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().xThumbWheel()), WindowSpecLayout.Position(0f, 1, 0.5f, -61, 0f, 19, 0.5f, 61));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().yThumbWheel()), WindowSpecLayout.Position(0.5f, -61, 1f, -19, 0.5f, 61, 1f, -1));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().dollyButton()), WindowSpecLayout.Position(1f, -19, 0.5f, 62, 1f, -1, 0.5f, 80));
		this.setSize(300, 300);
	}

	/**
	 * Answer my model as JunOpenGLMicrocosmModel.
	 * 
	 * @return jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmModel
	 * @see jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmView#getOpenGLMicrocosmModel()
	 * @category model accessing
	 */
	public JunOpenGLMicrocosmModel getOpenGLMicrocosmModel() {
		return (JunOpenGLMicrocosmModel) this.model();
	}

	/**
	 * Answer my default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunOpenGLMicrocosmController();
	}

}
