package jp.co.sra.jun.opengl.cosmos;

import java.awt.Color;
import java.awt.Image;

import jp.co.sra.smalltalk.SystemResourceSupport;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;

/**
 * JunOpenGLMicrocosmModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/08/18 (by nisinaka)
 *  @updated   2002/01/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLMicrocosmModelTestExamples.java,v 8.11 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGLMicrocosmModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGLMicrocosmModel displayModel = new JunOpenGLMicrocosmModel();
		displayModel.displayObject_(Room1());
		displayModel.open();
		displayModel.zoomHeight_(4.2);
		displayModel.grabButton().value_(true);
		displayModel.dollyButton().value_(true);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLMicrocosmModelTestExamples();
	}

	/**
	 * Create a back side image1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static Image BackSideImage1() {
		return SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/cosmos/BackSideImage1.jpg");
	}

	/**
	 * Create a back side wall 1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static JunOpenGL3dObject BackSideWall1() {
		Jun3dPoint[] vertexes = new Jun3dPoint[] { new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0) };
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(vertexes);
		aPolygon.paint_(Color.getHSBColor(0f, 0f, 0.9f));

		JunAngle anAngle = JunAngle.FromDeg_(0);
		Jun3dTransformation aT = Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, -1));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0));
		Jun3dTransformation aTransformation = Jun3dTransformation.Unity();
		aTransformation = (Jun3dTransformation) aTransformation.product_(Jun3dTransformation.Rotate_around_(anAngle, aLine));
		aTransformation = (Jun3dTransformation) aTransformation.product_(aT);

		JunOpenGL3dObject aWall = aPolygon.transform_(aTransformation);
		Image anImage = BackSideImage1();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0), new Jun2dPoint(0.0, 0.0) });
		aTexture.linear_(true);
		aTexture.clamp_(true);
		aTexture.modulate_(true);
		aTexture.mipmap_(true);
		aWall.texture_(aTexture);

		return aWall;
	}

	/**
	 * Create a down side image1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static Image DownSideImage1() {
		return SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/cosmos/DownSideImage1.jpg");
	}

	/**
	 * Create a down side wall 1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static JunOpenGL3dObject DownSideWall1() {
		Jun3dPoint[] vertexes = new Jun3dPoint[] { new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0) };
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(vertexes);
		aPolygon.paint_(Color.getHSBColor(0f, 0f, 0.9f));

		JunAngle anAngle = JunAngle.FromDeg_(-90);
		Jun3dTransformation aT = Jun3dTransformation.Translate_(new Jun3dPoint(0, -1, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		Jun3dTransformation aTransformation = Jun3dTransformation.Unity();
		aTransformation = (Jun3dTransformation) aTransformation.product_(Jun3dTransformation.Rotate_around_(anAngle, aLine));
		aTransformation = (Jun3dTransformation) aTransformation.product_(aT);

		JunOpenGL3dObject aWall = aPolygon.transform_(aTransformation);
		Image anImage = DownSideImage1();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0), new Jun2dPoint(0.0, 0.0) });
		aTexture.linear_(true);
		aTexture.clamp_(true);
		aTexture.modulate_(true);
		aTexture.mipmap_(true);
		aWall.texture_(aTexture);

		return aWall;
	}

	/**
	 * Create a left side image1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static Image LeftSideImage1() {
		return SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/cosmos/LeftSideImage1.jpg");
	}

	/**
	 * Create a left side wall 1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static JunOpenGL3dObject LeftSideWall1() {
		Jun3dPoint[] vertexes = new Jun3dPoint[] { new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0) };
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(vertexes);
		aPolygon.paint_(Color.getHSBColor(0f, 0f, 0.9f));

		JunAngle anAngle = JunAngle.FromDeg_(90);
		Jun3dTransformation aT = Jun3dTransformation.Translate_(new Jun3dPoint(-1, 0, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0));
		Jun3dTransformation aTransformation = Jun3dTransformation.Unity();
		aTransformation = (Jun3dTransformation) aTransformation.product_(Jun3dTransformation.Rotate_around_(anAngle, aLine));
		aTransformation = (Jun3dTransformation) aTransformation.product_(aT);

		JunOpenGL3dObject aWall = aPolygon.transform_(aTransformation);
		Image anImage = LeftSideImage1();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0), new Jun2dPoint(0.0, 0.0) });
		aTexture.linear_(true);
		aTexture.clamp_(true);
		aTexture.modulate_(true);
		aTexture.mipmap_(true);
		aWall.texture_(aTexture);

		return aWall;
	}

	/**
	 * Create a right side image1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static Image RightSideImage1() {
		return SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/cosmos/RightSideImage1.jpg");
	}

	/**
	 * Create a right side wall 1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static JunOpenGL3dObject RightSideWall1() {
		Jun3dPoint[] vertexes = new Jun3dPoint[] { new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0) };
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(vertexes);
		aPolygon.paint_(Color.getHSBColor(0f, 0f, 0.9f));

		JunAngle anAngle = JunAngle.FromDeg_(-90);
		Jun3dTransformation aT = Jun3dTransformation.Translate_(new Jun3dPoint(1, 0, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0));
		Jun3dTransformation aTransformation = Jun3dTransformation.Unity();
		aTransformation = (Jun3dTransformation) aTransformation.product_(Jun3dTransformation.Rotate_around_(anAngle, aLine));
		aTransformation = (Jun3dTransformation) aTransformation.product_(aT);

		JunOpenGL3dObject aWall = aPolygon.transform_(aTransformation);
		Image anImage = RightSideImage1();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0), new Jun2dPoint(0.0, 0.0) });
		aTexture.linear_(true);
		aTexture.clamp_(true);
		aTexture.modulate_(true);
		aTexture.mipmap_(true);
		aWall.texture_(aTexture);

		return aWall;
	}

	/**
	 * Create a room1.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Private
	 */
	protected static JunOpenGL3dObject Room1() {
		JunOpenGL3dCompoundObject room = new JunOpenGL3dCompoundObject();
		room.add_(BackSideWall1());
		room.add_(LeftSideWall1());
		room.add_(RightSideWall1());
		room.add_(DownSideWall1());
		room.add_(UpSideWall1());

		return room;
	}

	/**
	 * Create a up side image1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static Image UpSideImage1() {
		return SystemResourceSupport.createImage("/jp/co/sra/jun/opengl/cosmos/UpSideImage1.jpg");
	}

	/**
	 * Create a up side wall 1.
	 * 
	 * @return java.awt.Image
	 * @category Private
	 */
	protected static JunOpenGL3dObject UpSideWall1() {
		Jun3dPoint[] vertexes = new Jun3dPoint[] { new Jun3dPoint(1, -1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(-1, 1, 0), new Jun3dPoint(-1, -1, 0) };
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(vertexes);
		aPolygon.paint_(Color.getHSBColor(0f, 0f, 0.9f));

		JunAngle anAngle = JunAngle.FromDeg_(90);
		Jun3dTransformation aT = Jun3dTransformation.Translate_(new Jun3dPoint(0, 1, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		Jun3dTransformation aTransformation = Jun3dTransformation.Unity();
		aTransformation = (Jun3dTransformation) aTransformation.product_(Jun3dTransformation.Rotate_around_(anAngle, aLine));
		aTransformation = (Jun3dTransformation) aTransformation.product_(aT);

		JunOpenGL3dObject aWall = aPolygon.transform_(aTransformation);
		Image anImage = UpSideImage1();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0), new Jun2dPoint(0.0, 0.0) });
		aTexture.linear_(true);
		aTexture.clamp_(true);
		aTexture.modulate_(true);
		aTexture.mipmap_(true);
		aWall.texture_(aTexture);

		return aWall;
	}
}
