package jp.co.sra.jun.opengl.cosmos;

import java.awt.Point;
import java.awt.event.MouseEvent;

import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.opengl.display.JunOpenGLDisplayController;

/**
 * JunOpenGLMicrocosmController class
 * 
 *  @author    nisinaka
 *  @created   1999/08/17 (by nisinaka)
 *  @updated   2007/08/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLMicrocosmController.java,v 8.12 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGLMicrocosmController extends JunOpenGLDisplayController {

	/**
	 * Action for the mouse drag.
	 * 
	 * @param fromPoint java.awt.Point
	 * @param toPoint java.awt.Point
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayController#mouseDraggedFrom_to_with_(java.awt.Point, java.awt.Point, java.awt.event.MouseEvent)
	 * @category control defaults
	 */
	protected void mouseDraggedFrom_to_with_(Point fromPoint, Point toPoint, MouseEvent event) {
		StSymbol state = this.getOpenGLDisplayModel().buttonState();

		if (state == $("grab")) {
			this.grabActivityFrom_to_(fromPoint, toPoint);
		} else if (state == $("drag")) {
			this.dragActivityFrom_to_with_(fromPoint, toPoint, event);
		}
	}

}
