package jp.co.sra.jun.opengl.cosmos;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunOpenGLHypercosmModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/06 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLHypercosmModelTestExamples.java,v 8.11 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGLHypercosmModelTestExamples extends JunTestExamples {

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dObject displayObject = ExampleDisplayObject1();
		JunOpenGL3dObject hyperDoor1 = ExampleHyperDoor1();
		JunOpenGL3dObject hyperDoor2 = ExampleHyperDoor2();
		JunOpenGL3dObject hyperDoor3 = ExampleHyperDoor3();
		JunOpenGL3dObject hyperDoor4 = ExampleHyperDoor4();
		JunOpenGL3dObject hyperDoor5 = ExampleHyperDoor5();
		JunOpenGL3dObject hyperDoor6 = ExampleHyperDoor6();
		JunOpenGLDisplayModel hyperSpace4 = ExampleHyperSpace4();
		JunOpenGLDisplayModel hyperSpace5 = ExampleHyperSpace5();
		JunOpenGLDisplayModel hyperSpace6 = ExampleHyperSpace6();

		JunOpenGLHypercosmModel hypercosmModel = new JunOpenGLHypercosmModel(displayObject);
		hypercosmModel.add(hyperDoor1, hyperSpace4);
		hypercosmModel.add(hyperDoor2, hyperSpace5);
		hypercosmModel.add(hyperDoor3, hyperSpace6);
		hypercosmModel.add(hyperDoor4, hyperSpace4);
		hypercosmModel.add(hyperDoor5, hyperSpace5);
		hypercosmModel.add(hyperDoor6, hyperSpace6);

		Point aPoint = new Point(450, 100);
		JunOpenGLDisplayModel[] hyperSpaces = hypercosmModel.hyperSpacesNoDupulication();
		for (int i = 0; i < hyperSpaces.length; i++) {
			hyperSpaces[i].openIn_(new Rectangle(aPoint.x, aPoint.y, 300, 300));
			aPoint.translate(25, 25);
		}
		hypercosmModel.openIn_(new Rectangle(100, 100, 300, 300));

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGL3dObject displayObject = ExampleDisplayObject2();
		JunOpenGL3dObject hyperDoor1 = ExampleHyperDoor1();
		JunOpenGL3dObject hyperDoor2 = ExampleHyperDoor2();
		JunOpenGL3dObject hyperDoor3 = ExampleHyperDoor3();
		JunOpenGL3dObject hyperDoor4 = ExampleHyperDoor4();
		JunOpenGL3dObject hyperDoor5 = ExampleHyperDoor5();
		JunOpenGL3dObject hyperDoor6 = ExampleHyperDoor6();
		JunOpenGLDisplayModel hyperSpace1 = ExampleHyperSpace2();
		JunOpenGLDisplayModel hyperSpace2 = ExampleHyperSpace1();
		JunOpenGLDisplayModel hyperSpace3 = ExampleHyperSpace3();

		JunOpenGLHypercosmModel hypercosmModel = new JunOpenGLHypercosmModel(displayObject);
		hypercosmModel.add(hyperDoor1, hyperSpace1);
		hypercosmModel.add(hyperDoor2, hyperSpace2);
		hypercosmModel.add(hyperDoor3, hyperSpace3);
		hypercosmModel.add(hyperDoor4, hyperSpace1);
		hypercosmModel.add(hyperDoor5, hyperSpace2);
		hypercosmModel.add(hyperDoor6, hyperSpace3);

		Point aPoint = new Point(450, 100);
		JunOpenGLDisplayModel[] hyperSpaces = hypercosmModel.hyperSpacesNoDupulication();
		for (int i = 0; i < hyperSpaces.length; i++) {
			hyperSpaces[i].openIn_(new Rectangle(aPoint.x, aPoint.y, 300, 300));
			aPoint.translate(25, 25);
		}
		hypercosmModel.openIn_(new Rectangle(100, 100, 300, 300));

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunOpenGL3dObject displayObject = ExampleDisplayObject3();

		final Vector polygonCollection = new Vector();
		displayObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				polygonCollection.add(aPolygon);
				return null;
			}
		});
		JunOpenGL3dPolygon[] polygons = (JunOpenGL3dPolygon[]) polygonCollection.toArray(new JunOpenGL3dPolygon[polygonCollection.size()]);

		JunOpenGL3dCompoundObject hyperDoor1 = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < polygons.length; i++) {
			if (Math.abs(polygons[i].normalVector().z()) > 0.9) {
				hyperDoor1.add_(polygons[i]);
			}
		}
		JunOpenGL3dCompoundObject hyperDoor2 = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < polygons.length; i++) {
			if (Math.abs(polygons[i].normalVector().y()) > 0.9) {
				hyperDoor2.add_(polygons[i]);
			}
		}
		JunOpenGL3dCompoundObject hyperDoor3 = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < polygons.length; i++) {
			if (Math.abs(polygons[i].normalVector().x()) > 0.9) {
				hyperDoor3.add_(polygons[i]);
			}
		}

		JunOpenGLDisplayModel hyperSpace1 = ExampleHyperSpace2();
		JunOpenGLDisplayModel hyperSpace2 = ExampleHyperSpace1();
		JunOpenGLDisplayModel hyperSpace3 = ExampleHyperSpace3();

		JunOpenGLHypercosmModel hypercosmModel = new JunOpenGLHypercosmModel(displayObject);
		hypercosmModel.add(hyperDoor1, hyperSpace1);
		hypercosmModel.add(hyperDoor2, hyperSpace2);
		hypercosmModel.add(hyperDoor3, hyperSpace3);

		Point aPoint = new Point(450, 100);
		JunOpenGLDisplayModel[] hyperSpaces = hypercosmModel.hyperSpacesNoDupulication();
		for (int i = 0; i < hyperSpaces.length; i++) {
			hyperSpaces[i].openIn_(new Rectangle(aPoint.x, aPoint.y, 300, 300));
			aPoint.translate(25, 25);
		}
		hypercosmModel.openIn_(new Rectangle(100, 100, 300, 300));

		return true;
	}

	/**
	 * Answer the example display object 1.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleDisplayObject1() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Cube();
		displayObject.paint_(Color.yellow);
		return displayObject;
	}

	/**
	 * Answer the example display object 2.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleDisplayObject2() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Cube();
		displayObject.paint_(Color.green);
		return displayObject;
	}

	/**
	 * Answer the example display object 3.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleDisplayObject3() {
		final JunOpenGL3dObject displayObject = JunOpenGL3dObject.Globe_(15);
		displayObject.primitivesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				((JunOpenGL3dObject) anObject).paint_(Color.pink);
				return null;
			}
		});
		return displayObject;
	}

	/**
	 * Answer the example hyper door 1.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleHyperDoor1() {
		JunOpenGL3dCompoundObject stencilObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject aCube = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		JunOpenGL3dObject aPolygon = aCube.components()[0];
		aPolygon = aPolygon.scaledBy_(new Jun3dPoint(0.5, 0.5, 1));
		aPolygon = aPolygon.translatedBy_(new Jun3dPoint(0, 0, 0));
		stencilObject.add_(aPolygon);

		aCube = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		aPolygon = aCube.components()[0];
		aPolygon = aPolygon.rotatedBy_(JunAngle.FromDeg_(45));
		aPolygon = aPolygon.scaledBy_(new Jun3dPoint(0.5, 0.5, 1));
		aPolygon = aPolygon.translatedBy_(new Jun3dPoint(0, 0, 0));
		stencilObject.add_(aPolygon);

		return stencilObject;
	}

	/**
	 * Answer the example hyper door 2.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleHyperDoor2() {
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-90));
		return ExampleHyperDoor1().transform_(aTransformation);
	}

	/**
	 * Answer the example hyper door 3.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleHyperDoor3() {
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90));
		return ExampleHyperDoor1().transform_(aTransformation);
	}

	/**
	 * Answer the example hyper door 4.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleHyperDoor4() {
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(180));
		return ExampleHyperDoor1().transform_(aTransformation);
	}

	/**
	 * Answer the example hyper door 5.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleHyperDoor5() {
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(180));
		return ExampleHyperDoor2().transform_(aTransformation);
	}

	/**
	 * Answer the example hyper door 6.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject ExampleHyperDoor6() {
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(180));
		return ExampleHyperDoor3().transform_(aTransformation);
	}

	/**
	 * Answer the example hyper space 1.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel ExampleHyperSpace1() {
		JunOpenGL3dObject anObject = JunOpenGL3dObject.Minnie();
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(45));
		anObject = new JunOpenGL3dTransformedObject(anObject, aTransformation);
		return new JunOpenGLDisplayModel(anObject);
	}

	/**
	 * Answer the example hyper space 2.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel ExampleHyperSpace2() {
		JunOpenGL3dObject anObject = JunOpenGL3dObject.Mickey();
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(90));
		anObject = new JunOpenGL3dTransformedObject(anObject, aTransformation);
		return new JunOpenGLDisplayModel(anObject);
	}

	/**
	 * Answer the example hyper space 3.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel ExampleHyperSpace3() {
		JunOpenGL3dObject anObject = JunOpenGL3dObject.Pooh();
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(0));
		anObject = new JunOpenGL3dTransformedObject(anObject, aTransformation);
		return new JunOpenGLDisplayModel(anObject);
	}

	/**
	 * Answer the example hyper space 4.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel ExampleHyperSpace4() {
		return new JunOpenGLDisplayModel(JunOpenGL3dObject.Eddy());
	}

	/**
	 * Answer the example hyper space 5.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel ExampleHyperSpace5() {
		return new JunOpenGLDisplayModel(JunOpenGL3dObject.Benzene());
	}

	/**
	 * Answer the example hyper space 6.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel ExampleHyperSpace6() {
		return new JunOpenGLDisplayModel(JunOpenGL3dObject.Smalltalk());
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLHypercosmModelTestExamples();
	}

}
