package jp.co.sra.jun.opengl.chart;

import java.awt.Rectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunChartPieTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun642 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartPieTestExamples.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartPieTestExamples extends JunTestExamples {

	/**
	 * Example:
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples());
		aChart.open();

		return true;
	}

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples(), 1);
		aChart.open();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples(), 1);
		aChart.hideLabels();
		aChart.open();

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples2(), 1);
		aChart.open();

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples2(), 1);
		aChart.radius_(0.2);
		aChart.thickness_(0.1);
		aChart.open();

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples2(), 1);
		aChart.radius_(0.2);
		aChart.thickness_(0.1);
		aChart.labelHeight_(0.04);
		aChart.useScalableLabels();

		JunOpenGL3dObject extraObject = JunOpenGL3dObject.SmalltalkPlane().scaledBy_(2).translatedBy_(new Jun3dPoint(-0.5, -0.5, -0.1));
		extraObject.halftone_(0.5);
		aChart.extra3dObjects_(new JunOpenGL3dObject[] { extraObject });
		aChart.openIn_(new Rectangle(150, 150, 600, 600));

		return true;
	}

	/**
	 * ExampleX:
	 * 
	 * @return boolean
	 */
	public static boolean ExampleX() {
		JunChartPie aChart = new JunChartPie(JunChartDataTestExamples.SampleSamples2(), 1);
		aChart.hideLabels();
		aChart.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunChartPieTestExamples();
	}

}
