package jp.co.sra.jun.opengl.chart;

import java.util.Vector;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunChartBand class
 * 
 *  @author    nisinaka
 *  @created   1998/12/08 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartBand.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartBand extends JunChartWithSymbolicKeys {

	/**
	 * Create a new instance of JunChartBand and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunChartBand() {
		super();
	}

	/**
	 * Create a new instance of JunChartBand and initialize it with the collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	public JunChartBand(Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of JunChartBand and initialize it with the collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartBand(Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of JunChartBand and initialize it with the JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	public JunChartBand(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Create a JunOpenGL3dObject which represents the JunChartBand.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category private
	 */
	protected JunOpenGL3dCompoundObject createChart3dObject() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunChartDataSheet[] sheets = this.data().sheets();
		if (sheets == null) {
			return compoundObject;
		}

		for (int n = 0; n < sheets.length; n++) {
			JunChartDataSheet sheet = sheets[n];
			double z = this.intervalBetweenCharts() * n;
			double width = (1 - this.leftMargin() - this.rightMargin() - this.interval * (sheet.rowSize() - 1)) / sheet.rowSize();
			for (int i = 0; i < sheet.rowSize(); i++) {
				Object[] values = sheet.valuesAtRow_(i);
				double totalValue = 0;
				for (int j = 0; j < values.length; j++) {
					totalValue += ((Number) values[j]).doubleValue();
				}
				double x = this.leftMargin() + ((this.interval() + width) * i);
				double y = 0;
				for (int j = 0; j < values.length; j++) {
					double value = ((Number) values[j]).doubleValue();
					double height = value / totalValue;
					Jun3dPoint origin = new Jun3dPoint(x, y, z);
					Jun3dPoint extent = new Jun3dPoint(width, height, this.thickness());
					JunOpenGL3dObject band = JunOpenGL3dObject.Origin_extent_(origin, extent);
					band.paint_(this.nextColor());
					compoundObject.add_(band);

					y += height;
				}
			}
		}

		return compoundObject;
	}

}
