package jp.co.sra.jun.octree.nodes;

import java.util.Vector;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;

/**
 * Jun27TreeNode class
 * 
 *  @author    nisinaka
 *  @created   1999/12/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun27TreeNode.java,v 8.10 2008/02/20 06:32:17 nisinaka Exp $
 */
public class Jun27TreeNode extends JunOctreeNode {

	/**
	 * Create an instance of Jun27TreeNode and initialize it.
	 * 
	 * @param aBoolean java.lang.Boolean
	 */
	public Jun27TreeNode(Boolean aBoolean) {
		super(aBoolean);
	}

	/**
	 * Create an instance of Jun27TreeNode and initialize it.
	 * 
	 * @param aBoolean boolean
	 */
	public Jun27TreeNode(boolean aBoolean) {
		super(aBoolean);
	}

	/**
	 * Create a new instance of Jun27TreeNode as an empty node.
	 * 
	 * @return jp.co.sra.jun.octree.nodes.JunOctreeNode
	 */
	public static JunOctreeNode Empty() {
		return new Jun27TreeNode(false);
	}

	/**
	 * Create a new instance of Jun27TreeNode as a filled node.
	 * 
	 * @return jp.co.sra.jun.octree.nodes.JunOctreeNode
	 */
	public static JunOctreeNode Filled() {
		return new Jun27TreeNode(true);
	}

	/**
	 * Set the contents to be divided.
	 */
	public void beDivided() {
		Jun27TreeNode[] newContents = new Jun27TreeNode[27];

		for (int i = 0; i < 27; i++) {
			newContents[i] = new Jun27TreeNode((Boolean) contents);
		}

		contents = newContents;
	}

	/**
	 * Set myself as a node of b-reps octree.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public void brepsOrigin_extent_accuracy_block_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, double aNumber, StBlockClosure aBlock) {
		if ((aJun3dPoint2.x() < aNumber) && (aJun3dPoint2.y() < aNumber) && (aJun3dPoint2.z() < aNumber)) {
			this.brepsOrigin_extent_block_(aJun3dPoint1, aJun3dPoint2, aBlock);
		} else {
			this.beDivided();

			Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
			Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
			Jun3dPoint origin1 = aJun3dPoint1;
			Jun3dPoint origin2 = origin1.plus_(extent);
			Jun3dPoint origin3 = origin2.plus_(extent);
			_compositionalContents[0].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[1].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[2].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[3].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[4].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[5].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[6].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[7].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[8].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[9].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[10].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[11].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[12].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[13].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[14].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[15].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[16].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[17].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[18].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[19].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[20].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[21].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[22].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[23].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[24].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[25].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[26].brepsOrigin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, aNumber, aBlock);
			this.basicBeCompact();
		}
	}

	/**
	 * Set myself as a node of b-reps octree.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param anInteger int
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public void brepsOrigin_extent_depth_block_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, int anInteger, StBlockClosure aBlock) {
		if (anInteger == 1) {
			this.brepsOrigin_extent_block_(aJun3dPoint1, aJun3dPoint2, aBlock);
		} else {
			this.beDivided();

			Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
			Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
			Jun3dPoint origin1 = aJun3dPoint1;
			Jun3dPoint origin2 = origin1.plus_(extent);
			Jun3dPoint origin3 = origin2.plus_(extent);
			int depth = anInteger - 1;
			_compositionalContents[0].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[1].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[2].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[3].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[4].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[5].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[6].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[7].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[8].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[9].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[10].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[11].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[12].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[13].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[14].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[15].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[16].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[17].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[18].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[19].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[20].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[21].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[22].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[23].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[24].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[25].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[26].brepsOrigin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, depth, aBlock);
			this.basicBeCompact();
		}
	}

	/**
	 * Evaluate the block according to the accuracy.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public void origin_extent_accuracy_block_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, double aNumber, StBlockClosure aBlock) {
		if ((aJun3dPoint2.x() <= aNumber) && (aJun3dPoint2.y() <= aNumber) && (aJun3dPoint2.z() <= aNumber)) {
			this.origin_extent_block_(aJun3dPoint1, aJun3dPoint2, aBlock);
		} else {
			this.beDivided();

			Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
			Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
			Jun3dPoint origin1 = aJun3dPoint1;
			Jun3dPoint origin2 = origin1.plus_(extent);
			Jun3dPoint origin3 = origin2.plus_(extent);
			_compositionalContents[0].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[1].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[2].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[3].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[4].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[5].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[6].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[7].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[8].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, aNumber, aBlock);
			_compositionalContents[9].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[10].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[11].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[12].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[13].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[14].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[15].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[16].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[17].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, aNumber, aBlock);
			_compositionalContents[18].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[19].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[20].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[21].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[22].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[23].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[24].origin_extent_accuracy_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[25].origin_extent_accuracy_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, aNumber, aBlock);
			_compositionalContents[26].origin_extent_accuracy_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, aNumber, aBlock);
			this.basicBeCompact();
		}
	}

	/**
	 * Evaluate the block according to the depth.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param anInteger int
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public void origin_extent_depth_block_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, int anInteger, StBlockClosure aBlock) {
		if (anInteger == 1) {
			this.origin_extent_block_(aJun3dPoint1, aJun3dPoint2, aBlock);
		} else {
			this.beDivided();

			Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
			Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
			Jun3dPoint origin1 = aJun3dPoint1;
			Jun3dPoint origin2 = origin1.plus_(extent);
			Jun3dPoint origin3 = origin2.plus_(extent);
			int depth = anInteger - 1;
			_compositionalContents[0].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[1].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[2].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[3].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[4].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[5].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[6].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[7].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[8].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, depth, aBlock);
			_compositionalContents[9].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[10].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[11].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[12].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[13].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[14].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[15].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[16].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[17].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, depth, aBlock);
			_compositionalContents[18].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[19].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[20].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[21].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[22].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[23].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[24].origin_extent_depth_block_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[25].origin_extent_depth_block_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, depth, aBlock);
			_compositionalContents[26].origin_extent_depth_block_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, depth, aBlock);
			this.basicBeCompact();
		}
	}

	/**
	 * Enumerate the nodes and evaluate the block closure.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object origin_extent_nodesDo_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, StBlockClosure aBlock) {
		aBlock.value_value_value_(aJun3dPoint1, aJun3dPoint2, this);

		if (this.isNode()) {
			Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
			Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
			Jun3dPoint origin1 = aJun3dPoint1;
			Jun3dPoint origin2 = origin1.plus_(extent);
			Jun3dPoint origin3 = origin2.plus_(extent);
			_compositionalContents[0].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, aBlock);
			_compositionalContents[1].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, aBlock);
			_compositionalContents[2].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, aBlock);
			_compositionalContents[3].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, aBlock);
			_compositionalContents[4].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, aBlock);
			_compositionalContents[5].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, aBlock);
			_compositionalContents[6].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, aBlock);
			_compositionalContents[7].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, aBlock);
			_compositionalContents[8].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, aBlock);
			_compositionalContents[9].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, aBlock);
			_compositionalContents[10].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, aBlock);
			_compositionalContents[11].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, aBlock);
			_compositionalContents[12].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, aBlock);
			_compositionalContents[13].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, aBlock);
			_compositionalContents[14].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, aBlock);
			_compositionalContents[15].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, aBlock);
			_compositionalContents[16].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, aBlock);
			_compositionalContents[17].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, aBlock);
			_compositionalContents[18].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, aBlock);
			_compositionalContents[19].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, aBlock);
			_compositionalContents[20].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, aBlock);
			_compositionalContents[21].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, aBlock);
			_compositionalContents[22].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, aBlock);
			_compositionalContents[23].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, aBlock);
			_compositionalContents[24].origin_extent_nodesDo_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, aBlock);
			_compositionalContents[25].origin_extent_nodesDo_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, aBlock);
			_compositionalContents[26].origin_extent_nodesDo_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, aBlock);
		}

		return null;
	}

	/**
	 * Enumerate all nodes except aCollectionOfJunOctreeNode and evaluate the
	 * block.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunOctreeNode jp.co.sra.jun.octree.nodes.JunOctreeNode
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object origin_extent_nodesWithout_do_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, JunOctreeNode aJunOctreeNode, StBlockClosure aBlock) {
		if (this != aJunOctreeNode) {
			aBlock.value_value_value_(aJun3dPoint1, aJun3dPoint2, this);

			if (this.isNode()) {
				Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
				Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
				Jun3dPoint origin1 = aJun3dPoint1;
				Jun3dPoint origin2 = origin1.plus_(extent);
				Jun3dPoint origin3 = origin2.plus_(extent);
				_compositionalContents[0].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[1].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[2].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[3].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[4].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[5].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[6].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[7].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[8].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[9].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[10].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[11].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[12].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[13].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[14].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[15].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[16].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[17].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[18].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[19].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[20].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[21].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[22].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[23].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[24].origin_extent_nodesWithout_do_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[25].origin_extent_nodesWithout_do_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
				_compositionalContents[26].origin_extent_nodesWithout_do_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, aJunOctreeNode, aBlock);
			}
		}

		return null;
	}

	/**
	 * Enumerate all nodes except aCollectionOfJunOctreeNode and evaluate the
	 * block.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aCollectionOfJunOctreeNode java.util.Vector
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object origin_extent_nodesWithoutAll_do_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, Vector aCollectionOfJunOctreeNode, StBlockClosure aBlock) {
		if (aCollectionOfJunOctreeNode.contains(this) == false) {
			aBlock.value_value_value_(aJun3dPoint1, aJun3dPoint2, this);

			if (this.isNode()) {
				Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
				Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
				Jun3dPoint origin1 = aJun3dPoint1;
				Jun3dPoint origin2 = origin1.plus_(extent);
				Jun3dPoint origin3 = origin2.plus_(extent);
				_compositionalContents[0].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[1].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[2].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[3].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[4].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[5].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[6].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[7].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[8].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[9].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[10].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[11].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[12].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[13].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[14].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[15].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[16].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[17].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[18].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[19].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[20].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[21].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[22].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[23].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[24].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[25].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
				_compositionalContents[26].origin_extent_nodesWithoutAll_do_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, aCollectionOfJunOctreeNode, aBlock);
			}
		}

		return null;
	}

	/**
	 * Enumerate the tips and evaluate the block closure.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return java.lang.Object
	 */
	public Object origin_extent_tipsDo_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, StBlockClosure aBlock) {
		if (this.isTip()) {
			return aBlock.value_value_value_(aJun3dPoint1, aJun3dPoint2, this);
		} else {
			Jun27TreeNode[] _compositionalContents = (Jun27TreeNode[]) contents;
			Jun3dPoint extent = aJun3dPoint2.dividedBy_(3.0d);
			Jun3dPoint origin1 = aJun3dPoint1;
			Jun3dPoint origin2 = origin1.plus_(extent);
			Jun3dPoint origin3 = origin2.plus_(extent);
			_compositionalContents[0].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin1.y(), origin1.z()), extent, aBlock);
			_compositionalContents[1].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin1.y(), origin1.z()), extent, aBlock);
			_compositionalContents[2].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin1.y(), origin1.z()), extent, aBlock);
			_compositionalContents[3].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin2.y(), origin1.z()), extent, aBlock);
			_compositionalContents[4].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin2.y(), origin1.z()), extent, aBlock);
			_compositionalContents[5].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin2.y(), origin1.z()), extent, aBlock);
			_compositionalContents[6].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin3.y(), origin1.z()), extent, aBlock);
			_compositionalContents[7].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin3.y(), origin1.z()), extent, aBlock);
			_compositionalContents[8].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin3.y(), origin1.z()), extent, aBlock);
			_compositionalContents[9].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin1.y(), origin2.z()), extent, aBlock);
			_compositionalContents[10].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin1.y(), origin2.z()), extent, aBlock);
			_compositionalContents[11].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin1.y(), origin2.z()), extent, aBlock);
			_compositionalContents[12].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin2.y(), origin2.z()), extent, aBlock);
			_compositionalContents[13].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin2.y(), origin2.z()), extent, aBlock);
			_compositionalContents[14].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin2.y(), origin2.z()), extent, aBlock);
			_compositionalContents[15].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin3.y(), origin2.z()), extent, aBlock);
			_compositionalContents[16].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin3.y(), origin2.z()), extent, aBlock);
			_compositionalContents[17].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin3.y(), origin2.z()), extent, aBlock);
			_compositionalContents[18].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin1.y(), origin3.z()), extent, aBlock);
			_compositionalContents[19].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin1.y(), origin3.z()), extent, aBlock);
			_compositionalContents[20].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin1.y(), origin3.z()), extent, aBlock);
			_compositionalContents[21].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin2.y(), origin3.z()), extent, aBlock);
			_compositionalContents[22].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin2.y(), origin3.z()), extent, aBlock);
			_compositionalContents[23].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin2.y(), origin3.z()), extent, aBlock);
			_compositionalContents[24].origin_extent_tipsDo_(new Jun3dPoint(origin1.x(), origin3.y(), origin3.z()), extent, aBlock);
			_compositionalContents[25].origin_extent_tipsDo_(new Jun3dPoint(origin2.x(), origin3.y(), origin3.z()), extent, aBlock);
			_compositionalContents[26].origin_extent_tipsDo_(new Jun3dPoint(origin3.x(), origin3.y(), origin3.z()), extent, aBlock);

			return null;
		}
	}
}
