package jp.co.sra.jun.octree.basic;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.boundaries.*;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * Jun27TreeTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/12/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun27TreeTestExamples.java,v 8.10 2008/02/20 06:32:17 nisinaka Exp $
 */
public class Jun27TreeTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		final Jun3dPoint center = new Jun3dPoint(0, 0, 0);
		final double radius = 1.0;
		Jun3dBoundingBox bounds = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-2, -2, -2), new Jun3dPoint(2, 2, 2));
		JunOctree octree = Jun27Tree.FromBlock_depth_bounds_(new StBlockClosure() {
			public Object value_(Object anObject) {
				Jun3dPoint point = (Jun3dPoint) anObject;

				return new Double(radius - point.distance_(center));
			}
		}, 4, bounds);
		octree.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunOctree tree = Jun27Tree.Bounds_(Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-2, -2, -2), new Jun3dPoint(2, 2, 2)));
		tree.edit();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new Jun27TreeTestExamples();
	}
}
