package jp.co.sra.jun.metaball.atoms;

import jp.co.sra.jun.geometry.abstracts.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.metaball.abstracts.*;

/**
 * JunMetaGeometry class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMetaGeometry.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMetaGeometry extends JunDistanceMetaball {
	/** geometry. */
	protected JunGeometry geometry;

	/**
	 * Create a new instance of JunMetaGeometry and initialize it.
	 * 
	 * @param aJunGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 */
	public JunMetaGeometry(JunGeometry aJunGeometry) {
		super();
		this.geometry_(aJunGeometry);
	}

	/**
	 * Create a new instance of JunMetaGeometry and initialize it.
	 * 
	 * @param aJunGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @param order int
	 * @param weight double
	 */
	public JunMetaGeometry(JunGeometry aJunGeometry, int order, double weight) {
		super(order, weight);
		this.geometry_(aJunGeometry);
	}

	/**
	 * Create a new instance of JunMetaGeometry and set it with geometry.
	 * 
	 * @param aJunGeometry
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaGeometry
	 */
	public static JunMetaGeometry Geometry_(JunGeometry aJunGeometry) {
		return new JunMetaGeometry(aJunGeometry);
	}

	/**
	 * Create a new instance of JunMetaGeometry and set it with geometry, order
	 * and weight.
	 * 
	 * @param aJunGeometry
	 * @param aNumber1
	 * @param aNumber2
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaGeometry
	 */
	public static JunMetaGeometry Geometry_order_weight_(JunGeometry aJunGeometry, int aNumber1, double aNumber2) {
		return new JunMetaGeometry(aJunGeometry, aNumber1, aNumber2);
	}

	/**
	 * Answer a value of the distance.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return double
	 */
	public double distance_(Jun3dPoint aJun3dPoint) {
		return this.geometry.distanceFromPoint_(aJun3dPoint);
	}

	/**
	 * Answer the geometry.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry
	 */
	public JunGeometry geometry() {
		return this.geometry;
	}

	/**
	 * set the geometry.
	 * 
	 * @param aJunGeometry
	 */
	public void geometry_(JunGeometry aJunGeometry) {
		this.geometry = aJunGeometry;
	}
}
