package jp.co.sra.jun.metaball.abstracts;

import jp.co.sra.jun.csg.atoms.JunSolidCSG;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.metaball.atoms.JunTransformedMetaball;
import jp.co.sra.jun.metaball.solid.JunMetaballSolid;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunMetaball class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMetaball.java,v 8.11 2008/02/20 06:32:16 nisinaka Exp $
 */
public abstract class JunMetaball extends JunAbstractObject {

	/**
	 * Answer the JunTransformedMetaball which is applied the specified
	 * transformation.
	 * 
	 * @param aNumber
	 * @return aJunSolidCSG jp.co.sra.jun.metaball.solid.JunMetaballSolid
	 * @category converting
	 */
	public JunSolidCSG asCSGSolidThreshold_(double aNumber) {
		return (JunMetaballSolid.With_threshold_(this, aNumber)).asCSGSolid();
	}

	/**
	 * Answer the JunTransformedMetaball which is applied the specified
	 * transformation.
	 * 
	 * @param aJun3dTransformation
	 * @return jp.co.sra.jun.metaball.solid.JunTransformedMetaball
	 * @category transforming
	 */
	public JunTransformedMetaball transform_(Jun3dTransformation aJun3dTransformation) {
		return JunTransformedMetaball.On_transform_(this, aJun3dTransformation);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return double
	 * @see jp.co.sra.jun.metaball.abstracts.JunMetaball#valueAt_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category accessing
	 */
	public abstract double valueAt_(Jun3dPoint aJun3dPoint);
}
