package jp.co.sra.jun.graphics.navigator;

import java.awt.Choice;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.files.JunFileModel.FileType;

/**
 * JunFileRequesterViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/11/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileRequesterViewAwt.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunFileRequesterViewAwt extends JunFileNavigatorViewAwt implements JunFileRequesterView {
	protected Choice fileType;
	protected TextField tailFileName;

	/**
	 * Create a new instance of <code>JunFileRequesterViewAwt</code> and initialize it.
	 * 
	 * @param aFileRequester jp.co.sra.jun.graphics.navigator.JunFileRequester
	 * @category Instance creation
	 */
	public JunFileRequesterViewAwt(JunFileRequester aFileRequester) {
		super(aFileRequester);
	}

	/**
	 * Answer the receiver's model as <code>JunFileRequester</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileRequester
	 * @see jp.co.sra.jun.graphics.navigator.JunFileRequesterView#getFileRequester()
	 * @category model accessing
	 */
	public JunFileRequester getFileRequester() {
		return (JunFileRequester) this.model();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.homeButtonView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 25, 0f, 25));
		this.add(this.currentFileNameWithBorder(), WindowSpecLayout.Position(0f, 26, 0f, 1, 1f, -1, 0f, 25));
		this.add(this.leftView(), WindowSpecLayout.Position(0f, 1, 0f, 26, 0.32f, -1, 1f, -26));
		this.add(this.centerView(), WindowSpecLayout.Position(0.32f, 0, 0f, 26, 0.68f, 0, 1f, -26));
		this.add(this.rightView(), WindowSpecLayout.Position(0.68f, 1, 0f, 26, 1f, -1, 1f, -26));
		this.add(this.fileType(), WindowSpecLayout.Position(0f, 1, 1f, -25, 0.5f, -1, 1f, -1));
		this.add(this.tailFileName(), WindowSpecLayout.Position(0.5f, 0, 1f, -25, 1f, -1, 1f, -1));
		this.setSize(new Dimension(500, 300));
	}

	/**
	 * Answer the file type combo box.
	 *
	 * @return java.awt.Choice
	 * @category user interface
	 */
	protected Choice fileType() {
		if (fileType == null) {
			fileType = new Choice();
			FileType[] fileTypes = this.getFileRequester().fileTypes();
			for (int i = 0; i < fileTypes.length; i++) {
				fileType.add(fileTypes[i].name());
			}
			fileType.select(((FileType) this.getFileRequester().fileType().value()).name());

			fileType.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						JunFileRequesterViewAwt.this.getFileRequester().fileTypeChanged(fileType.getSelectedIndex());
					}
				}
			});
		}
		return fileType;
	}

	/**
	 * Answer the text field for the current file name.
	 * 
	 * @return java.awt.TextField
	 * @category user interface
	 */
	protected TextField tailFileName() {
		if (tailFileName == null) {
			tailFileName = new TextField();

			StSymbol requestType = this.getFileRequester().requestType();
			if (requestType == $("oldFile") || requestType == $("oldDirectory")) {
				tailFileName.setEnabled(false);
			} else {
				tailFileName.setText(this.getFileRequester().tailFileName());
				tailFileName.addTextListener(new TextListener() {
					public void textValueChanged(TextEvent e) {
						JunFileRequesterViewAwt.this.getFileRequester().tailFileName_(tailFileName.getText());
					}
				});
			}

			this.getFileRequester().tailFileNameHolder().compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					if (tailFileName.getText().equals(anObject) == false) {
						tailFileName.setText(anObject.toString());
					}
					return null;
				}
			});
		}
		return tailFileName;
	}
}
