package jp.co.sra.jun.graphics.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.SwingUtilities;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.graphics.framework.JunGraphicViewAwt;
import jp.co.sra.jun.graphics.list.JunSequenceListViewAwt;

/**
 * JunFileNavigatorViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/11/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileNavigatorViewAwt.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunFileNavigatorViewAwt extends JunGraphicViewAwt implements JunFileNavigatorView {
	protected JunSequenceListViewAwt centerView;
	protected JunSequenceListViewAwt leftView;
	protected JunSequenceListViewAwt rightView;
	protected JunButtonViewAwt homeButtonView;
	protected Label currentFileName;
	protected Label statusLabel;

	/**
	 * Create a new instance of <code>JunFileNavigatorViewSwing</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.graphics.navigator.JunFileNavigator
	 * @category Instance creation
	 */
	public JunFileNavigatorViewAwt(JunFileNavigator aModel) {
		super(aModel);
	}

	/**
	 * Answer the receiver's model as <code>JunFileNavigator</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileNavigator
	 * @see jp.co.sra.jun.graphics.navigator.JunFileNavigatorView#getFileNavigator()
	 * @category accessing 
	 */
	public JunFileNavigator getFileNavigator() {
		return (JunFileNavigator) this.model();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.homeButtonView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 25, 0f, 25));
		this.add(this.currentFileNameWithBorder(), WindowSpecLayout.Position(0f, 26, 0f, 1, 1f, -1, 0f, 25));
		this.add(this.leftView(), WindowSpecLayout.Position(0f, 1, 0f, 26, 0.32f, -1, 1f, -21));
		this.add(this.centerView(), WindowSpecLayout.Position(0.32f, 0, 0f, 26, 0.68f, 0, 1f, -21));
		this.add(this.rightView(), WindowSpecLayout.Position(0.68f, 1, 0f, 26, 1f, -1, 1f, -21));
		this.add(this.statusLabel(), WindowSpecLayout.Position(0f, 1, 1f, -20, 1f, -1, 1f, -1));
		this.setSize(500, 300);
	}

	/**
	 * Answer the center view.
	 * 
	 * @return jp.co.sra.jun.graphics.graphics.list.JunSequenceListViewAwt
	 * @category user interface
	 */
	protected JunSequenceListViewAwt centerView() {
		if (centerView == null) {
			centerView = new JunEmbeddedFileListViewAwt(this.getFileNavigator().centerList());
		}
		return centerView;
	}

	/**
	 * Answer the left view.
	 * 
	 * @return jp.co.sra.jun.graphics.graphics.list.JunSequenceListViewAwt
	 * @category user interface
	 */
	protected JunSequenceListViewAwt leftView() {
		if (leftView == null) {
			leftView = new JunEmbeddedFileListViewAwt(this.getFileNavigator().leftList());
			leftView.setVisible(!this.getFileNavigator().isLeftEnd());
		}
		return leftView;
	}

	/**
	 * Answer the right view.
	 * 
	 * @return jp.co.sra.jun.graphics.graphics.list.JunSequenceListViewSwing
	 * @category user interface
	 */
	protected JunSequenceListViewAwt rightView() {
		if (rightView == null) {
			rightView = new JunSequenceListViewAwt(this.getFileNavigator().rightList());
		}
		return rightView;
	}

	/**
	 * Answer the home button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewAwt homeButtonView() {
		if (homeButtonView == null) {
			homeButtonView = new JunButtonViewAwt(this.getFileNavigator().homeButton());
		}
		return homeButtonView;
	}

	/**
	 * Answer the label for the current file name.
	 * 
	 * @return java.awt.Label
	 * @category user interface
	 */
	protected Label currentFileName() {
		if (currentFileName == null) {
			currentFileName = new Label();
			currentFileName.setFocusable(false);
			if (this.getFileNavigator().currentFileHolder().value() != null) {
				currentFileName.setText(this.getFileNavigator().currentFileAsString());
			}

			this.getFileNavigator().currentFileHolder().compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					currentFileName.setText(JunFileNavigatorViewAwt.this.getFileNavigator().currentFileAsString());
					return null;
				}
			});
		}
		return currentFileName;
	}

	/**
	 * Answer the label for the current file name with border.
	 * 
	 * @return java.awt.Component
	 * @category user interface
	 */
	protected Component currentFileNameWithBorder() {
		Panel panel = new Panel() {
			public Insets getInsets() {
				return new Insets(0, 10, 0, 0);
			}
		};
		panel.setLayout(new BorderLayout());
		panel.add(this.currentFileName(), BorderLayout.CENTER);
		return panel;
	}

	/**
	 * Answer the label for the status.
	 * 
	 * @return java.awt.Label
	 * @category user interface
	 */
	protected Label statusLabel() {
		if (statusLabel == null) {
			statusLabel = new Label(this.getFileNavigator().currentStatus());
			statusLabel.setAlignment(Label.CENTER);
		}
		return statusLabel;
	}

	/**
	 * To fix the scrolling offset when opened.
	 * 
	 * @see java.awt.Component#addNotify()
	 * @category actions
	 */
	public void addNotify() {
		super.addNotify();

		this.topComponent().addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				JunFileNavigatorViewAwt.this.getFileNavigator().fixScrollingOffset();
			}
		});
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(final Window aWindow) {
		KeyListener keyListener = this.centerView().getSequenceList()._keyListener();
		if (keyListener == null) {
			return;
		}

		this.centerView().addKeyListener(keyListener);

		MouseListener mouseListener = new MouseAdapter() {
			public void mouseEntered(MouseEvent e) {
				if (aWindow.isActive() && aWindow.getFocusOwner() != JunFileNavigatorViewAwt.this.centerView()) {
					JunFileNavigatorViewAwt.this.centerView().requestFocus();
				}
			}
		};
		this.centerView().canvas().addMouseListener(mouseListener);
		this.leftView().canvas().addMouseListener(mouseListener);
		this.rightView().canvas().addMouseListener(mouseListener);

		aWindow.addWindowListener(new WindowAdapter() {
			public void windowActivated(WindowEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						Component focusOwner = aWindow.getFocusOwner();
						if (focusOwner == null || focusOwner != JunFileNavigatorViewAwt.this.centerView()) {
							JunFileNavigatorViewAwt.this.centerView().requestFocus();
						}
					}
				});
			}
		});
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DevendentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		StSymbol aspect = evt.getAspect();
		if (aspect == $("current file")) {
			this.statusLabel().setText(this.getFileNavigator().currentStatus());
			this.setListViewVisible(this.leftView(), !this.getFileNavigator().isLeftEnd());
			this.setListViewVisible(this.rightView(), !this.getFileNavigator().isCurrentFileInaccessibleDirectory());
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Set the list view visibility.
	 * 
	 * @param listView jp.co.sra.jun.graphics.graphics.list.JunSequenceListViewAwt
	 * @param aFlag boolean
	 * @category private
	 */
	protected void setListViewVisible(JunSequenceListViewAwt listView, boolean aFlag) {
		if (listView.isVisible() != aFlag) {
			listView.setVisible(aFlag);
		}
	}
}
