package jp.co.sra.jun.graphics.navigator;

import java.io.File;
import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.graphics.navigator.JunFileNavigator;
import jp.co.sra.jun.graphics.navigator.JunFileNavigatorTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunFileNavigatorTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/22 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileNavigatorTestExamples.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunFileNavigatorTestExamples extends JunTestExamples {
	/**
	 * Example: Open a new file navigator.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunFileNavigator fileNavigator = new JunFileNavigator();
		fileNavigator.open();
		return true;
	}

	/**
	 * Example1: Open a new file navigator with specifying some attributes.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunFileNavigator fileNavigator = new JunFileNavigator();
		fileNavigator.filePatterns_(new String[] { "*.exe", "*.dll", "*.mov" });
		fileNavigator.distinctFolder_(false);
		fileNavigator.sortKey_($("nameUp"));
		fileNavigator.compute_(new StBlockClosure() {
			public Object value_(Object file) {
				System.out.println(file);
				return null;
			}
		});
		fileNavigator.open();
		return true;
	}

	/**
	 * Example2: Open a new file navigator with empty file patterns.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunFileNavigator fileNavigator = new JunFileNavigator();
		fileNavigator.filePatterns_(new String[0]);
		fileNavigator.compute_(new StBlockClosure() {
			public Object value_(Object file) {
				System.out.println(file);
				return null;
			}
		});
		fileNavigator.open();
		return true;
	}

	/**
	 * Example3: Open a new file navigator with empty file patterns.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunFileNavigator fileNavigator = new JunFileNavigator(new File("."));
		fileNavigator.compute_(new StBlockClosure() {
			public Object value_(Object file) {
				System.out.println(file);
				return null;
			}
		});
		fileNavigator.open();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunFileNavigatorTestExamples();
	}
}
