package jp.co.sra.jun.graphics.list;

import java.io.File;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunFileListTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/13 (by nisinaka)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun690 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileListTestExamples.java,v 8.10 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunFileListTestExamples extends JunTestExamples {
	/**
	 * Example1: Show the root file list.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunFileList fileList = JunFileList.Root();
		fileList.directoryItemBlock_(new StBlockClosure() {
			public Object value_(Object filename) {
				System.out.println(filename);
				return null;
			}
		});
		fileList.open();
		return true;
	}

	/**
	 * Example2: Show the current file list.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunFileList fileList = JunFileList.Current();
		fileList.directoryItemBlock_(new StBlockClosure() {
			public Object value_(Object filename) {
				System.out.println(filename);
				return null;
			}
		});
		fileList.sortKey_($("extensionUp"));
		fileList.distinctFolder_(false);
		fileList.open();
		return true;
	}

	/**
	 * Example3: Show the current file list.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		File aFile = (new File(".")).listFiles()[0];
		JunFileList fileList = new JunFileList(aFile);
		fileList.fileItemBlock_(new StBlockClosure() {
			public Object value_(Object filename) {
				System.out.println(filename);
				return null;
			}
		});
		fileList.open();
		return true;
	}

	/**
	 * Example4: Show the null file list.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunFileList fileList = JunFileList.Null();
		fileList.nullItemBlock_(new StBlockClosure() {
			public Object value_(Object filename) {
				System.out.println(filename);
				return null;
			}
		});
		fileList.open();
		return true;
	}

	/**
	 * Example5: Show the root file list.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunFileList fileList = JunFileList.Root();
		fileList.showContents_(false);
		fileList.directoryItemBlock_(new StBlockClosure() {
			public Object value_(Object filename) {
				System.out.println(filename);
				return null;
			}
		});
		fileList.open();
		return true;
	}

	/**
	 * Test2: Select block.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test_selectBlock() {
		JunFileList fileList = JunFileList.Current();
		fileList.selectBlock_(new StBlockClosure() {
			public Object value_(Object aFile) {
				return Boolean.valueOf(((File) aFile).isFile());
			}
		});
		fileList.open();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunFileListTestExamples();
	}
}
