package jp.co.sra.jun.graphics.abstracts;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.graphics.item.JunCompositeItem;
import jp.co.sra.jun.graphics.item.JunCompositeItemTestExamples;
import jp.co.sra.jun.graphics.item.JunPrimitiveItem;
import jp.co.sra.jun.graphics.item.JunPrimitiveItemTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunAbstractMapTestExamples class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/17 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractMapTestExamples.java,v 8.9 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunAbstractMapTestExamples extends JunTestExamples {
	/**
	 * Test example #1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final JunAbstractMap aMap = new JunAbstractMap();
		JunCompositeItem aCompositeItem = new JunCompositeItem(new Point(20, 10), new Point(200, 100));
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(120, 50), StImage._OfArea(new Rectangle(0, 0, 100, 100)));
		aCompositeItem.add_(aPrimitiveItem);
		aMap.add_(aCompositeItem);

		Frame aFrame = new Frame();
		aFrame.add(new Canvas() {
			public void paint(Graphics g) {
				aMap.displayOn_(g);
			}
		});
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.setBounds(200, 200, 300, 300);
		aFrame.setVisible(true);

		return true;
	}

	/**
	 * Test example #2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final JunAbstractMap aMap = new JunAbstractMap();
		JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		JunPrimitiveItem aTextItem = JunPrimitiveItemTestExamples.ExampleTextItem();
		JunPrimitiveItem anImageItem = JunPrimitiveItemTestExamples.ExampleImageItem();
		aMap.add_(aCompositeItem);
		aMap.add_(anIconItem);
		aMap.add_(aTextItem);
		aMap.add_(anImageItem);

		Frame aFrame = new Frame();
		aFrame.add(new Canvas() {
			public void paint(Graphics g) {
				aMap.displayOn_(g);
			}
		});
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.setBounds(200, 200, 300, 300);
		aFrame.setVisible(true);

		return true;
	}

	/**
	 * Test example #3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunAbstractMap aMap = new JunAbstractMap();
		for (int i = 1; i <= 7; i++) {
			Rectangle aBox = aMap.bounds();
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aCompositeItem.originPoint_(new StRectangle(aBox).bottomLeft());
			aMap.add_(aCompositeItem);
		}
		aMap.itemsDo_(new StBlockClosure() {
			public Object value_(Object o) {
				JunAbstractItem item = (JunAbstractItem) o;
				item.borderWidth_(0);
				return null;
			}
		});

		Frame aFrame = new Frame();
		aFrame.add(new Canvas() {
			public void paint(Graphics g) {
				aMap.displayOn_(g);
			}
		});
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.setBounds(200, 200, 300, 300);
		aFrame.setVisible(true);

		return true;
	}

	/**
	 * Execure the example launcher.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		Example3();
	}
}
