package jp.co.sra.jun.goodies.wavelet;

/**
 * JunDiscreteWaveletTransformation class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/07 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun660 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDiscreteWaveletTransformation.java,v 8.6 2008/02/20 06:32:14 nisinaka Exp $
 */
public abstract class JunDiscreteWaveletTransformation extends JunWaveletTransformation {
	protected double[] daubechieScalingSequence;
	protected double[] daubechieWaveletSequence;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.goodies.wavelet.JunWaveletTransformation#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		daubechieScalingSequence = new double[] { 0.48296291314453, 0.83651630373781, 0.22414386804201, 0 - 0.12940952255126 };
		int size = daubechieScalingSequence.length;
		daubechieWaveletSequence = new double[size];
		for (int n = 0; n < size; n++) {
			daubechieWaveletSequence[n] = Math.pow(-1, n) * daubechieScalingSequence[size - 1 - n];
		}
	}
}
