package jp.co.sra.jun.goodies.utilities;

import java.io.IOException;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunStringUtilityTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/13 (by nisinaka)
 *  @updated   2006/04/17 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun679 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunStringUtilityTestExamples.java,v 8.15 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunStringUtilityTestExamples extends JunTestExamples {
	/**
	 * Example: StringMatch_and_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_StringMatch() {
		boolean match = JunStringUtility.StringMatch_and_("Jun Aoki", "Ju*[A-B]?ki");
		return match;
	}

	/**
	 * Example: A_value_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Avalue_() {
		System.out.println(JunStringUtility.A_value_("10", "abc"));
		System.out.println(JunStringUtility.A_value_("", "abc"));
		System.out.println(JunStringUtility.A_value_("3", "abcdefgh"));

		return true;
	}

	/**
	 * Example: F_value_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Fvalue_() {
		System.out.println(JunStringUtility.F_value_("10.4", 1234.567f));
		System.out.println(JunStringUtility.F_value_("", 1234.567f));
		System.out.println(JunStringUtility.F_value_("3", 1234.567f));

		return true;
	}

	/**
	 * Example: I_value_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Ivalue_() {
		System.out.println(JunStringUtility.I_value_("10", 1234567));
		System.out.println(JunStringUtility.I_value_("", 1234567));
		System.out.println(JunStringUtility.I_value_("3", 1234567));

		return true;
	}

	/**
	 * Example: X_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_X() {
		System.out.println(JunStringUtility.X_("10"));
		System.out.println(JunStringUtility.X_(""));

		return true;
	}

	/**
	 * Example: Format_value_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_FormatValue() {
		System.out.println(JunStringUtility.Format_value_("a10", "abc"));
		System.out.println(JunStringUtility.Format_value_("f10.4", new Float(1234.567f)));
		System.out.println(JunStringUtility.Format_value_("x10", null));

		return true;
	}

	/**
	 * Example: StringWithCommas_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_StringWithCommas() {
		System.out.println(JunStringUtility.StringWithCommas_("abcdefghijklmnopqrstuvwxyz"));
		System.out.println(JunStringUtility.StringWithCommasFor_(8.478668123456E6));
		System.out.println(JunStringUtility.StringWithCommasFor_(Long.MAX_VALUE));
		System.out.println(JunStringUtility.StringWithCommasFor_(Integer.MIN_VALUE));
		System.out.println(JunStringUtility.StringWithCommasFor_(Double.MAX_VALUE));
		System.out.println(JunStringUtility.StringWithCommasFor_(Double.MIN_VALUE));

		return true;
	}

	/**
	 * Example: GetLines_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_GetLines() {
		StringBuffer writer = new StringBuffer();
		writer.append("-1.1604   -0.6711   -0.0756\n");
		writer.append("-1.1621    0.6709   -0.0461\n");
		writer.append("-0.0019    1.3422    0.0296\n");
		writer.append(" 1.1596    0.6708    0.0756\n");
		writer.append(" 1.1615   -0.6712    0.0461\n");
		writer.append(" 0.0012   -1.3423   -0.0296\n");
		writer.append("-2.1144   -1.2230   -0.1378\n");
		writer.append("-2.1172    1.2228   -0.0839\n");
		writer.append("-0.0032    2.4459    0.0539\n");
		writer.append(" 2.1138    1.2225    0.1378\n");
		writer.append(" 2.1172   -1.2230    0.0840\n");
		writer.append(" 0.0024   -2.4459   -0.0539\n");

		String[] anArray = new String[0];
		try {
			anArray = JunStringUtility.GetLinesFromString_(writer.toString());
		} catch (IOException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		}

		for (int i = 0; i < anArray.length; i++) {
			System.out.println(anArray[i]);
		}
		return true;
	}

	/**
	 * Example: GetTokens_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_GetTokens() {
		StringBuffer writer = new StringBuffer();
		writer.append("-1.1604   -0.6711   -0.0756\n");
		writer.append("-1.1621    0.6709   -0.0461\n");
		writer.append("-0.0019    1.3422    0.0296\n");
		writer.append(" 1.1596    0.6708    0.0756\n");
		writer.append(" 1.1615   -0.6712    0.0461\n");
		writer.append(" 0.0012   -1.3423   -0.0296\n");
		writer.append("-2.1144   -1.2230   -0.1378\n");
		writer.append("-2.1172    1.2228   -0.0839\n");
		writer.append("-0.0032    2.4459    0.0539\n");
		writer.append(" 2.1138    1.2225    0.1378\n");
		writer.append(" 2.1172   -1.2230    0.0840\n");
		writer.append(" 0.0024   -2.4459   -0.0539\n");

		String[][] anArray = new String[0][];
		try {
			anArray = JunStringUtility.GetTokensFromString_(writer.toString());
		} catch (IOException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		}

		for (int i = 0; i < anArray.length; i++) {
			for (int j = 0; j < anArray[i].length; j++) {
				System.out.print(anArray[i][j]);
				if (j + 1 < anArray[i].length) {
					System.out.print(", ");
				}
			}
			System.out.println();
		}
		return true;
	}

	/**
	 * Example: StringCharcters_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_StripCharcters() {
		System.out.println("StripFronCharcters      \"" + JunStringUtility.StripFrontCharcters_from_(new char[] { ';', ':', ',' }, ":,;abc,:;") + "\"");
		System.out.println("StripFrontBackCharcters \"" + JunStringUtility.StripFrontBackCharcters_from_(new char[] { ';', ':', ',' }, ":,;abc,:;") + "\"");
		System.out.println("StripBackCharcters      \"" + JunStringUtility.StripBackCharcters_from_(new char[] { ';', ':', ',' }, ":,;abc,:;") + "\"");

		System.out.println("---");

		System.out.println("StripFronCharcters      \"" + JunStringUtility.StripFrontCharcters_from_(new char[] { ';', ':', ',' }, "") + "\"");
		System.out.println("StripFrontBackCharcters \"" + JunStringUtility.StripFrontBackCharcters_from_(new char[] { ';', ':', ',' }, "") + "\"");
		System.out.println("StripBackCharcters      \"" + JunStringUtility.StripBackCharcters_from_(new char[] { ';', ':', ',' }, "") + "\"");
		return true;
	}

	/**
	 * Example: StringSeparators_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_StripSeparators() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("\n");
		buffer.append("	   abc\n");
		buffer.append("	   ");
		String aString = buffer.toString();

		System.out.println(aString);
		System.out.println("---");
		System.out.println(JunStringUtility.StripBackSeparators_(aString));
		System.out.println("---");
		System.out.println(JunStringUtility.StripFrontSeparators_(aString));
		System.out.println("---");
		System.out.println(JunStringUtility.StripFrontBackSeparators_(aString));
		System.out.println("---");

		return true;
	}

	/**
	 * Example: SpacingMessageSelector_()
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_SpacingMessageSelector() {
		System.out.println(JunStringUtility.SpacingMessageSelector_($("spacingMessageSelector:")));
		System.out.println(JunStringUtility.SpacingMessageSelector_with_($("spacingMessageSelector:"), "_"));

		return true;
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunStringUtilityTestExamples();
	}
}
