package jp.co.sra.jun.goodies.utilities;

import java.awt.Point;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSensorUtilityTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSensorUtilityTestExamples.java,v 8.10 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunSensorUtilityTestExamples extends JunTestExamples {

	/**
	 * Example_CursorPoint:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_CursorPoint() {
		JunSensorUtility.CursorPoint_(new Point(0, 0));
		return JunSensorUtility.CursorPoint().equals(new Point(0, 0));
	}

	/**
	 * Example_AnyButtonPressed:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_AnyButtonPressed() {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		boolean pressed = JunSensorUtility.AnyButtonPressed();
		System.out.println("any button: " + pressed);

		JunSensorUtility.WaitNoButton();

		return true;
	}

	/**
	 * Example_NoButtonPressed:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_NoButtonPressed() {
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		boolean pressed = JunSensorUtility.NoButtonPressed();
		System.out.println("no button: " + pressed);

		JunSensorUtility.WaitNoButton();

		return true;
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSensorUtilityTestExamples();
	}

}
