package jp.co.sra.jun.goodies.utilities;

import java.awt.Point;

import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.SystemInterface;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunSensorUtility class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSensorUtility.java,v 8.12 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunSensorUtility extends JunAbstractObject {

	/**
	 * Answer whether the alt key is down.
	 * 
	 * @return boolean
	 * @category Keyboard 
	 */
	public static boolean AltDown() {
		return InputState().altDown();
	}

	/**
	 * Answer whether the ctrl key is down.
	 * 
	 * @return boolean
	 * @category Keyboard 
	 */
	public static boolean CtrlDown() {
		return InputState().ctrlDown();
	}

	/**
	 * Answer whether the meta key is down.
	 * 
	 * @return boolean
	 * @category Keyboard 
	 */
	public static boolean MetaDown() {
		return InputState().metaDown();
	}

	/**
	 * Answer whether the shift key is down.
	 * 
	 * @return boolean
	 * @category Keyboard 
	 */
	public static boolean ShiftDown() {
		return InputState().shiftDown();
	}

	/**
	 * Answer the current cursor point.
	 * 
	 * @return java.awt.Point
	 * @category Mouse
	 */
	public static Point CursorPoint() {
		return SystemInterface._MousePoint();
	}

	/**
	 * Set the new cursor point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category Mouse
	 */
	public static void CursorPoint_(Point aPoint) {
		SystemInterface._SetMousePoint(aPoint.x, aPoint.y);
	}

	/**
	 * Answer true if the any mouse button is currently pressed, otherwise false.
	 * 
	 * @return boolean
	 * @category Mouse
	 */
	public static boolean AnyButtonPressed() {
		return StInputState.Default().anyButtonDown();
	}

	/**
	 * Answer true if the no mouse button is currently pressed, otherwise false.
	 * 
	 * @return boolean
	 * @category Mouse
	 */
	public static boolean NoButtonPressed() {
		return AnyButtonPressed() == false;
	}

	/**
	 * Wait for the any mouse button pressed.
	 * 
	 * @return java.awt.Point
	 * @category Mouse
	 */
	public static Point WaitButton() {
		Thread aThread = Thread.currentThread();
		int priority = aThread.getPriority();
		try {
			aThread.setPriority(Math.max(priority - 1, Thread.MIN_PRIORITY));

			while (AnyButtonPressed() == false) {
				aThread.yield();
			}

		} finally {
			aThread.setPriority(priority);
		}

		return CursorPoint();
	}

	/**
	 * Wait for the any mouse button released.
	 * 
	 * @return java.awt.Point
	 * @category Mouse
	 */
	public static Point WaitNoButton() {
		Thread aThread = Thread.currentThread();
		int priority = aThread.getPriority();
		try {
			aThread.setPriority(Math.max(priority - 1, Thread.MIN_PRIORITY));

			while (AnyButtonPressed() == true) {
				aThread.yield();
			}

		} finally {
			aThread.setPriority(priority);
		}

		return CursorPoint();
	}

	/**
	 * Wait for the any mouse button released.
	 * 
	 * @return java.awt.Point
	 * @category Mouse
	 */
	public static Point WaitClickButton() {
		WaitButton();
		return WaitNoButton();
	}

	/**
	 * Answer my private input state.
	 * 
	 * @return jp.co.sra.smalltalk.StInputState
	 * @category Private
	 */
	protected static StInputState InputState() {
		return StInputState.Default();
	}

}
