package jp.co.sra.jun.goodies.track;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunSimpleSliderViewSwing class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/27 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleSliderViewSwing.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunSimpleSliderViewSwing extends JunAbstractViewJPanel implements JunSimpleSliderView {

	protected StRectangle sliderRectangle;
	protected StRectangle savedSliderRectangle;

	/**
	 * Create a new instance of JunSimpleSliderViewSwing and initialize it.
	 */
	public JunSimpleSliderViewSwing() {
		super();
	}

	/**
	 * Create a new instance of JunSimpleSliderViewSwing and initialize it.
	 * 
	 * @param aSimpleSliderModel
	 */
	public JunSimpleSliderViewSwing(JunSimpleSliderModel aSimpleSliderModel) {
		super(aSimpleSliderModel);
	}

	/**
	 * Display on a graphics context.
	 * 
	 * @param graphicsContext java.awt.Graphics
	 */
	public void displayOn_(Graphics graphicsContext) {
		if (this.isShowing() == false) {
			return;
		}

		this.displayBackgroundOn_(graphicsContext);
		this.displaySliderOn_(graphicsContext);
	}

	/**
	 * Display the slider on the graphics context.
	 * 
	 * @param graphicsContext java.awt.Graphics
	 */
	public void displaySliderOn_(Graphics graphicsContext) {
		StRectangle box = this.sliderRectangle();
		Polygon polygon = new Polygon();
		polygon.addPoint(box.left(), box.bottom());
		polygon.addPoint(box.right(), box.bottom());
		polygon.addPoint(box.center().x, box.center().y - 1);
		graphicsContext.setColor(Gray20);
		graphicsContext.fillPolygon(polygon);
		savedSliderRectangle = box;
	}

	/**
	 * Answer the current JunSimpleSliderModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderModel
	 * @deprecated since Jun379
	 */
	public JunSimpleSliderModel getModel() {
		return (JunSimpleSliderModel) this.model();
	}

	/**
	 * Answer the current model as a JunSimpleSliderModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderModel
	 */
	public JunSimpleSliderModel getSimpleSliderModel() {
		return (JunSimpleSliderModel) this.model();
	}

	/**
	 * Set the bounds of the view.
	 * Also needs to flush the slider rectangles which need to redraw.
	 *
	 * @param x The new <i>x</i>-coordinate of this component.
	 * @param y The new <i>y</i>-coordinate of this component.
	 * @param width The new <code>width</code> of this component.
	 * @param height The new <code>height</code> of this component.
	 * @see java.awt.Component#setBounds(int, int, int, int)
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);
		this.flushSliderRectangles();
	}

	/**
	 * Set the new JunSimpleSliderModel.
	 * 
	 * @param aModel jp.co.sra.jun.goodies.track.JunSimpleSliderModel
	 * @deprecated since Jun379
	 */
	public void setModel(JunSimpleSliderModel aModel) {
		this.model_(aModel);
	}

	/**
	 * Set the new model value via view.
	 * 
	 * @param x int
	 * @param y int
	 * @see jp.co.sra.jun.goodies.track.JunSimpleSliderView#setModelValue_(int, int)
	 */
	public void setModelValue_(int x, int y) {
		StRectangle box = this.sliderArea();
		box = box.insetBy_(new StRectangle(0, 0, 1, 1));
		double value = (double) (x - box.originX()) / box.width();
		this.getSimpleSliderModel().value_(Math.max(0, Math.min(value, 1)));
	}

	/**
	 * Answer my slider area.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 */
	public StRectangle sliderArea() {
		return (new StRectangle(this.getSize())).insetBy_(this.margin());
	}

	/**
	 * Answer my slider rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 */
	public StRectangle sliderRectangle() {
		if (sliderRectangle == null) {
			sliderRectangle = this.sliderRectangleForValue_(this.getSimpleSliderModel().doubleValue());
		}
		return sliderRectangle;
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("value")) {
			sliderRectangle = null;
			StRectangle clipBox = this.sliderRectangle();
			if (clipBox.equals(savedSliderRectangle) == false) {
				if (savedSliderRectangle != null) {
					clipBox = clipBox.merge_(savedSliderRectangle);
				}
				this.repaint(clipBox.originX(), clipBox.originY(), clipBox.width(), clipBox.height());
			}
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setPreferredSize(new Dimension(150, 20));
	}

	/**
	 * Answer my default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 */
	protected StController defaultController() {
		return new JunSimpleSliderController();
	}

	/**
	 * Answer my default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new JunSimpleSliderModel();
	}

	/**
	 * Display the background on the graphics.
	 * 
	 * @param graphicsContext java.awt.Graphics
	 */
	protected void displayBackgroundOn_(Graphics graphicsContext) {
		StRectangle box = new StRectangle(this.getSize());
		graphicsContext.clipRect(box.left(), box.top(), box.right(), box.bottom());
		graphicsContext.setColor(Gray70);
		graphicsContext.fillRect(box.left(), box.top(), box.right(), box.bottom());
		graphicsContext.drawRect(box.left(), box.top(), box.right(), box.bottom());
		graphicsContext.setColor(Gray80);
		graphicsContext.drawLine(box.left(), box.top(), box.right() - 1, box.top());
		graphicsContext.drawLine(box.left(), box.top(), box.left(), box.bottom() - 1);
		graphicsContext.setColor(Gray20);
		graphicsContext.drawLine(box.left(), box.bottom() - 1, box.right() - 1, box.bottom() - 1);
		graphicsContext.drawLine(box.right() - 1, box.top(), box.right() - 1, box.bottom() - 1);
		box = this.sliderArea();
		graphicsContext.setColor(Gray80);
		graphicsContext.drawLine(box.left() + 1, box.top() + 1, box.left() + 1, box.bottom() - 1);
		graphicsContext.drawLine(box.left(), box.center().y, box.right() - 1, box.center().y);
		graphicsContext.drawLine(box.right(), box.top(), box.right(), box.bottom() - 1);
		graphicsContext.setColor(Gray20);
		graphicsContext.drawLine(box.left(), box.top(), box.left(), box.bottom() - 1);
		graphicsContext.drawLine(box.left() + 1, box.center().y - 1, box.right() - 1, box.center().y - 1);
		graphicsContext.drawLine(box.right() - 1, box.top() + 1, box.right() - 1, box.bottom() - 1);
	}

	/**
	 * Flush the slider rectangles.
	 */
	protected void flushSliderRectangles() {
		sliderRectangle = null;
		savedSliderRectangle = null;
	}

	/**
	 * Initialize the receiver.
	 */
	protected void initialize() {
		this.flushSliderRectangles();
	}

	/**
	 * Answer the Rectangle of margin.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 */
	protected StRectangle margin() {
		return new StRectangle(6, 4, 6, 4);
	}

	/**
	 * Answer a slider rectangle for a value.
	 * 
	 * @param aValue double
	 * @return jp.co.sra.smalltalk.StRectangle
	 */
	protected StRectangle sliderRectangleForValue_(double aValue) {
		StRectangle box = this.sliderArea();
		box = box.insetBy_(new StRectangle(0, 0, 1, 1));
		int x = (int) Math.round(box.width() * aValue) + box.originX();
		StRectangle slider = new StRectangle(x, box.top(), x, box.bottom());
		slider = slider.expandedBy_(new StRectangle(this.margin().left() - 2, 0, this.margin().right() - 2, 1));
		return slider;
	}

}
