package jp.co.sra.jun.goodies.track;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunSimpleSliderController class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/27 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleSliderController.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunSimpleSliderController extends JunAbstractController implements MouseListener, MouseMotionListener {

	protected StSymbol _tracking;
	protected Point _previousPoint;
	protected Point _offsetPoint;
	protected boolean _redisplayBoolean;
	protected Graphics _graphicsContext;

	/**
	 * Answer my model as a JunSimpleSliderModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderModel
	 */
	public JunSimpleSliderModel getSimpleSliderModel() {
		return (JunSimpleSliderModel) this.model();
	}

	/**
	 * Answer my view as a JunSimpleSliderView.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderView
	 */
	public JunSimpleSliderView getSimpleSliderView() {
		return (JunSimpleSliderView) this.view();
	}

	/**
	 * Answer my view as a JunSimpleSliderView.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderView
	 * @deprecated since Jun379, use getSimpleSliderView()
	 */
	public JunSimpleSliderView getView() {
		return (JunSimpleSliderView) this.view();
	}

	/**
	 * Invoked when a mouse button is pressed on a component and then dragged.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
		if (_tracking == $("slider")) {
			this._trackSlider(e.getPoint());
		}
	}

	/**
	 * Invoked when the mouse button has been moved on a component (with no buttons no down).
	 *
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e) {
		StSymbol symbol = this._trackingState(e.getPoint());
		if (symbol == $("slider")) {
			this.getComponent().setCursor(JunCursors.CrossCursor());
		} else {
			this.getComponent().setCursor(Cursor.getDefaultCursor());
		}
	}

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		if (e.isMetaDown() || e.isAltDown()) {
			return;
		}

		Point startPoint = e.getPoint();
		_tracking = this._trackingState(startPoint);
		if (_tracking == $("slider")) {
			if (this.getSimpleSliderView().sliderRectangle().containsPoint_(startPoint)) {
				_offsetPoint = this.getSimpleSliderView().sliderRectangle().center();
				_offsetPoint = new Point(_offsetPoint.x - startPoint.x, _offsetPoint.y - startPoint.y);
			} else {
				_offsetPoint = new Point(0, 0);
			}
			_previousPoint = null;
			_redisplayBoolean = false;
			this._trackSlider(startPoint);
		}
	}

	/**
	 * Invoked when a mouse button has been released on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
		if (_tracking == $("slider")) {
			if (_redisplayBoolean) {
				this.getSimpleSliderView().displayOn_(this._graphicsContext());
			}
		}

		_tracking = null;
		_offsetPoint = null;
		_previousPoint = null;
		_redisplayBoolean = false;
		if (_graphicsContext != null) {
			_graphicsContext.dispose();
			_graphicsContext = null;
		}
	}

	/**
	 * Method _graphicsContext.
	 * 
	 * @return Graphics
	 */
	protected Graphics _graphicsContext() {
		if (_graphicsContext == null) {
			_graphicsContext = this.getComponent().getGraphics();
		}
		return _graphicsContext;
	}

	/**
	 * Answer the tracking state at the specified point.
	 * 
	 * @param aPoint
	 * 
	 * @return StSymbol
	 */
	protected StSymbol _trackingState(Point aPoint) {
		StSymbol symbol = null;
		if (this.getSimpleSliderView().sliderArea().containsPoint_(aPoint)) {
			symbol = $("slider");
		}
		if (this.getSimpleSliderView().sliderRectangle().containsPoint_(aPoint)) {
			symbol = $("slider");
		}
		return symbol;
	}

	/**
	 * Do the slider tracking.
	 * 
	 * @param aPoint
	 */
	protected void _trackSlider(Point aPoint) {
		if ((new StRectangle(this.getComponent().getSize())).expandedBy_(16, 16).containsPoint_(aPoint)) {
			if (aPoint.equals(_previousPoint) == false) {
				this.getSimpleSliderView().setModelValue_(aPoint.x + _offsetPoint.x, aPoint.y + _offsetPoint.y);
				this.getSimpleSliderView().displaySliderOn_(this._graphicsContext());
				_previousPoint = aPoint;
			}
			_redisplayBoolean = true;
		}
	}

	/**
	 * add listeners.
	 * 
	 * @param newView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		final Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}

	/**
	 * Answer my view as a Component.
	 * 
	 * @return java.awt.Component
	 */
	protected Component getComponent() {
		return (Component) this.view();
	}

}
