package jp.co.sra.jun.goodies.tools;

import java.awt.Cursor;
import java.io.File;
import java.net.MalformedURLException;

import jp.co.sra.smalltalk.SmalltalkException;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.tips.JunURL;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunFileLauncher class
 * 
 *  @author    nisinaka
 *  @created   2005/07/11 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileLauncher.java,v 8.12 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunFileLauncher extends JunAbstractObject {

	/**
	 * Request to select a file and launch it.
	 * 
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File Request() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				JunFileModel.FileType.All($String("All files")),
				new JunFileModel.FileType($String("<1p> files", null, "PDF"), new String[] { "*.pdf", "*.PDF" }),
				new JunFileModel.FileType($String("<1p> files", null, "DOC"), new String[] { "*.doc", "*.DOC" }),
				new JunFileModel.FileType($String("<1p> files", null, "XLS"), new String[] { "*.xls", "*.XLS" }),
				new JunFileModel.FileType($String("<1p> files", null, "PPT"), new String[] { "*.ppt", "*.PPT" }) };
		return Request(fileTypes);
	}

	/**
	 * Request to select a file and launch it.
	 * 
	 * @param fileTypes jp.co.sra.jun.goodies.files.JunFileModel.FileType[]
	 * @return java.io.File
	 * @category Utilities
	 */
	public static File Request(JunFileModel.FileType[] fileTypes) {
		File file = JunFileRequesterDialog.RequestFile($String("Select a file."), fileTypes, fileTypes[0]);
		if (file == null) {
			return null;
		}

		JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		try {
			cursor._show();

			JunURL.Browse_(file.toURL());
		} catch (MalformedURLException e) {
			e.printStackTrace();
			throw new SmalltalkException(e);
		} finally {
			cursor._restore();
		}

		return file;
	}

}
