package jp.co.sra.jun.goodies.tips;

import java.net.URL;
import jp.co.sra.smalltalk.SystemInterface;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunURL class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2002/01/25 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunURL.java,v 8.12 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunURL extends JunAbstractObject {
	protected String name;

	/**
	 * Open the browser with the string as URL.
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.goodies.tips.JunURL
	 * @category Utilities
	 */
	public static JunURL Browse_(String aString) {
		JunURL newURL = JunURL.Named_(aString);
		newURL.browse();

		return newURL;
	}

	/**
	 * Open the browser with the URL.
	 * 
	 * @param aURL java.net.URL
	 * @return jp.co.sra.jun.goodies.tips.JunURL
	 * @category Utilities
	 */
	public static JunURL Browse_(URL aURL) {
		return JunURL.Browse_(aURL.toString());
	}
	
	/**
	 * The constructor with name.
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.goodies.tips.JunURL
	 * @category Instance creation
	 */
	public static JunURL Named_(String aString) {
		return new JunURL(aString);
	}

	/**
	 * The constructor with URL.
	 * 
	 * @param aURL java.net.URL
	 * @return jp.co.sra.jun.goodies.tips.JunURL
	 * @category Instance creation
	 */
	public static JunURL Named_(URL aURL) {
		return new JunURL(aURL.toString());
	}

	/**
	 * Create a new instance of <code>JunURL</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	protected JunURL() {
		super();
	}

	/**
	 * Create a new instance of <code>JunURL</code> and initialize it.
	 * 
	 * @param aString java.lang.String
	 * @category Instance creation
	 */
	public JunURL(String aString) {
		this();
		this.name_(aString);
	}

	/**
	 * Create a new instance of <code>JunURL</code> and initialize it.
	 * 
	 * @param aURL java.net.URL
	 * @category Instance creation
	 */
	public JunURL(URL aURL) {
		this(aURL.toString());
	}
	
	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		name = null;
	}

	/**
	 * Answer the name.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String name() {
		return name;
	}

	/**
	 * Set the name.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void name_(String aString) {
		name = aString;
	}

	/**
	 * Open the browser.
	 * 
	 * @category browsing
	 */
	public void browse() {
		if (this.name() != null) {
			SystemInterface.Current().utilBrowse(this.name());
		}
	}
	
	/**
	 * Convert the receiver to string.
	 * 
	 * @return java.lang.String
	 * @category converting
	 */
	public String asString() {
		return this.toString();
	}
	
	/**
	 * Answer printable string of this object.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StObject#toString()
	 * @category printing
	 */
	public String toString() {
		return this.name();
	}
}
