package jp.co.sra.jun.goodies.texteditor;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunTextEditorView interface
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextEditorView.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public interface JunTextEditorView extends JunAbstractView {
	/**
	 * Answer the model as JunTextEditor.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditor
	 * @category model accessing
	 */
	public JunTextEditor getModel();

	/**
	 * Answer the text in text area.
	 * 
	 * @return java.lang.String
	 * @category text accessing
	 */
	public String getText();

	/**
	 * Answer the selected text in text area.
	 * 
	 * @return java.lang.String
	 * @category text accessing
	 */
	public String getSelectedText();

	/**
	 * Copy selected text to clipboard.
	 * 
	 * @category text accessing
	 */
	public void copyText();

	/**
	 * Cut selected text to clipboard.
	 * 
	 * @category text accessing
	 */
	public void cutText();

	/**
	 * Paste selected text from clipboard.
	 * 
	 * @category text accessing
	 */
	public void pasteText();

	/**
	 * Clear text.
	 * 
	 * @category text accessing
	 */
	public void clearText();

	/**
	 * Undo text.
	 * 
	 * @category text accessing
	 */
	public void undoText();

	/**
	 * Redo text.
	 * 
	 * @category text accessing
	 */
	public void redoText();
}
