package jp.co.sra.jun.goodies.texteditor;

import java.awt.Dialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunTextEditorDialog class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextEditorDialog.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTextEditorDialog extends StSimpleDialog {
	protected JunTextEditor textPropertiesModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Open JunGaugeDialog to request a value.
	 * 
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request() {
		return Request(JunSystem.$String("Input a new <1p>.", null, JunSystem.$String("Text")));
	}

	/**
	 * Open a JunGaugeDialog to request a value.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString) {
		return Request(messageString, new JunTextEditor());
	}

	/**
	 * Open a JunGaugeDialog to request a value with the speicified gauge model.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @param aTextEditor jp.co.sra.jun.goodies.texteditor.JunTextEditor
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunTextEditor aTextEditor) {
		return Request(messageString, aTextEditor, null, null);
	}

	/**
	 * Open a JunTextEditorDialog to request a value with the speicified text properties model.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @param aTextEditor jp.co.sra.jun.goodies.texteditor.JunTextEditor
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunTextEditor aTextEditor, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunTextEditorDialog textPropertiesDialog = new JunTextEditorDialog();
		if (aTextEditor != null) {
			textPropertiesDialog.textPropertiesModel_(aTextEditor);
		}
		Dialog aDialog = textPropertiesDialog.allButOpenDialog();
		if (messageString != null) {
			aDialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			textPropertiesDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			textPropertiesDialog.cancelBlock_(cancelBlock);
		}

		_ShowAtMousePoint(aDialog);

		return (textPropertiesDialog.accept()._booleanValue()) ? textPropertiesDialog.textPropertiesModel().text() : null;
	}

	/**
	 * Open a JunTextEditorDialog to request a value with the speicified initial value.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @param value java.lang.String
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, String value) {
		return Request(messageString, new JunTextEditor(value));
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		textPropertiesModel = null;
		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer my current text properties model.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditor
	 * @category accessing
	 */
	public JunTextEditor textPropertiesModel() {
		if (textPropertiesModel == null) {
			textPropertiesModel = new JunTextEditor();
		}
		return textPropertiesModel;
	}

	/**
	 * Set my new text properties model.
	 * 
	 * @param newTextEditor jp.co.sra.jun.goodies.texteditor.JunTextEditor
	 * @category accessing
	 */
	public void textPropertiesModel_(JunTextEditor newTextEditor) {
		textPropertiesModel = newTextEditor;
	}

	/**
	 * Set my new accept block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Set my new cancel block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Called when the accept button is pressed.
	 * 
	 * @return boolean
	 * @category actions
	 */
	protected boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			return ((Boolean) acceptBlock.value_(this.textPropertiesModel())).booleanValue();
		}
		return true;

	}

	/**
	 * Called when the cancel button is pressed.
	 * 
	 * @return boolean
	 * @category actions
	 */
	protected boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			return ((Boolean) cancelBlock.value_(this.textPropertiesModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Answer my default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category view accessing
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunTextEditorDialogViewAwt(this);
		} else {
			return new JunTextEditorDialogViewSwing(this);
		}
	}
}
