package jp.co.sra.jun.goodies.tables;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunReferenceTable class
 * 
 *  @author    nisinaka
 *  @created   2006/04/07 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun592 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunReferenceTable.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunReferenceTable extends JunAttributeTable {

	/**
	 * Create a new instance of JunReferenceTable and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunReferenceTable() {
		super();
	}

	/**
	 * Create a new instance of JunReferenceTable and initialize it.
	 *
	 * @param size int
	 * @category Instance creation
	 */
	public JunReferenceTable(int size) {
		super(size);
	}

	/**
	 * Create a new instance of JunReferenceTable and initialize it.
	 *
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunReferenceTable(JunLispList aList) {
		super(aList);
	}

	/**
	 * Answer my bindings as references.
	 * 
	 * @return java.util.Map.Entry[]
	 * @category accessing
	 */
	public Map.Entry[] references() {
		return this.bindings();
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException if failed.
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write('(');
		aWriter.write(this._className().toString());
		if (this.isEmpty() == false) {
			aWriter.write(" (references");

			Map.Entry[] references = this.references();
			int size = references.length;
			if (size <= this.printMax()) {
				for (int i = 0; i < size; i++) {
					this.printEntryOn_(references[i], aWriter);
				}
			} else {
				for (int i = 0; i < this.printMax() / 2; i++) {
					this.printEntryOn_(references[i], aWriter);
				}
				aWriter.write(" ...");
				for (int i = size - this.printMax() / 2; i < size; i++) {
					this.printEntryOn_(references[i], aWriter);
				}
			}

			aWriter.write(')');
		}
		aWriter.write(')');
	}

	/**
	 * Answer the maximum number for printing elements.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.goodies.tables.JunAttributeTable#printMax()
	 * @category printing
	 */
	protected int printMax() {
		return 100;
	}

}
