package jp.co.sra.jun.goodies.tables;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunAdjacencyMatrixTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/06 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun594 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAdjacencyMatrixTestExamples.java,v 8.11 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunAdjacencyMatrixTestExamples extends JunTestExamples {

	/**
	 * Example01: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example01() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		adjacencyMatrix.beDirectedGraph();
		System.out.println(adjacencyMatrix.printString());

		return true;
	}

	/**
	 * Example02: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example02() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		adjacencyMatrix.beUndirectedGraph();
		System.out.println(adjacencyMatrix.printString());

		return true;
	}

	/**
	 * Example03: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example03() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		adjacencyMatrix = new JunAdjacencyMatrix(adjacencyMatrix.toLispList());
		System.out.println(adjacencyMatrix.printString());

		return true;
	}

	/**
	 * Example10: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example10() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		adjacencyMatrix.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(node.toString());
				System.out.println();
				return null;
			}
		});
		System.out.println();
		adjacencyMatrix.arcsDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object arc, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(((Object[]) arc)[0].toString());
				System.out.print("==");
				System.out.print(((Object[]) arc)[1].toString());
				System.out.print("=>");
				System.out.print(((Object[]) arc)[2].toString());
				System.out.println();
				return null;
			}
		});

		return true;
	}

	/**
	 * Example11: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example11() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleCycle();
		adjacencyMatrix.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(node.toString());
				System.out.println();
				return null;
			}
		});
		System.out.println();
		adjacencyMatrix.arcsDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object arc, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(((Object[]) arc)[0].toString());
				System.out.print("==");
				System.out.print(((Object[]) arc)[1].toString());
				System.out.print("=>");
				System.out.print(((Object[]) arc)[2].toString());
				System.out.println();
				return null;
			}
		});

		return true;
	}

	/**
	 * Example12: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example12() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		adjacencyMatrix.nodesBreadthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(node.toString());
				System.out.println();
				return null;
			}
		});
		System.out.println();
		adjacencyMatrix.arcsBreadthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object arc, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(((Object[]) arc)[0].toString());
				System.out.print("==");
				System.out.print(((Object[]) arc)[1].toString());
				System.out.print("=>");
				System.out.print(((Object[]) arc)[2].toString());
				System.out.println();
				return null;
			}
		});

		return true;
	}

	/**
	 * Example13: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example13() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		adjacencyMatrix.nodesTopologicalSortDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence.toString());
				System.out.print(": ");
				System.out.print(node.toString());
				System.out.println();
				return null;
			}
		});
		System.out.println();
		Object[] nodes = adjacencyMatrix.nodesTopologicalSort();
		for (int i = 0; i < nodes.length; i++) {
			System.out.println(nodes[i].toString());
		}

		return true;
	}

	/**
	 * Example14: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example14() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleSimple();
		Map shortestPaths = adjacencyMatrix.shortestPaths();

		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object o1, Object o2) {
				Object key1 = ((Map.Entry) o1).getKey();
				Object key2 = ((Map.Entry) o2).getKey();

				if (key1 instanceof Comparable) {
					return ((Comparable) key1).compareTo(key2);
				} else if (key2 instanceof Comparable) {
					return ((Comparable) key2).compareTo(key1) * -1;
				} else {
					return key1.toString().compareTo(key2.toString());
				}
			}
		});
		aTreeSet.addAll(shortestPaths.entrySet());
		Iterator iterator = aTreeSet.iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			Object startNode = entry.getKey();
			Map shortestPath = (Map) entry.getValue();

			TreeSet aTreeSet2 = new TreeSet(new Comparator() {
				public int compare(Object o1, Object o2) {
					Object key1 = ((Map.Entry) o1).getKey();
					Object key2 = ((Map.Entry) o2).getKey();

					if (key1 instanceof Comparable) {
						return ((Comparable) key1).compareTo(key2);
					} else if (key2 instanceof Comparable) {
						return ((Comparable) key2).compareTo(key1) * -1;
					} else {
						return key1.toString().compareTo(key2.toString());
					}
				}
			});
			aTreeSet2.addAll(shortestPath.entrySet());
			Iterator iterator2 = aTreeSet2.iterator();
			while (iterator2.hasNext()) {
				Map.Entry entry2 = (Map.Entry) iterator2.next();
				Object node = entry2.getKey();
				Number distance = (Number) entry2.getValue();

				System.out.print(startNode);
				System.out.print(" -- ");
				System.out.print(distance);
				System.out.print(" -> ");
				System.out.print(node);
				System.out.println();
			}
		}

		return true;
	}

	/**
	 * Example15: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example15() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleCycle();
		Map shortestPaths = adjacencyMatrix.shortestPaths();

		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object o1, Object o2) {
				Object key1 = ((Map.Entry) o1).getKey();
				Object key2 = ((Map.Entry) o2).getKey();

				if (key1 instanceof Comparable) {
					return ((Comparable) key1).compareTo(key2);
				} else if (key2 instanceof Comparable) {
					return ((Comparable) key2).compareTo(key1) * -1;
				} else {
					return key1.toString().compareTo(key2.toString());
				}
			}
		});
		aTreeSet.addAll(shortestPaths.entrySet());
		Iterator iterator = aTreeSet.iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			Object startNode = entry.getKey();
			Map shortestPath = (Map) entry.getValue();

			TreeSet aTreeSet2 = new TreeSet(new Comparator() {
				public int compare(Object o1, Object o2) {
					Object key1 = ((Map.Entry) o1).getKey();
					Object key2 = ((Map.Entry) o2).getKey();

					if (key1 instanceof Comparable) {
						return ((Comparable) key1).compareTo(key2);
					} else if (key2 instanceof Comparable) {
						return ((Comparable) key2).compareTo(key1) * -1;
					} else {
						return key1.toString().compareTo(key2.toString());
					}
				}
			});
			aTreeSet2.addAll(shortestPath.entrySet());
			Iterator iterator2 = aTreeSet2.iterator();
			while (iterator2.hasNext()) {
				Map.Entry entry2 = (Map.Entry) iterator2.next();
				Object node = entry2.getKey();
				Number distance = (Number) entry2.getValue();

				System.out.print(startNode);
				System.out.print(" -- ");
				System.out.print(distance);
				System.out.print(" -> ");
				System.out.print(node);
				System.out.println();
			}
		}

		return true;
	}

	/**
	 * Example16: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example16() {
		JunAdjacencyMatrix aMatrix = new JunAdjacencyMatrix();
		aMatrix.connect_with_("a", "b");
		aMatrix.connect_with_("a", "c");
		aMatrix.connect_with_("b", "c");
		JunAdjacencyMatrix anotherMatrix = new JunAdjacencyMatrix();
		anotherMatrix.connect_with_("f", "d");
		anotherMatrix.connect_with_("e", "d");
		anotherMatrix.connect_with_("e", "f");
		boolean isIsomorphic = aMatrix.isIsomorphicTo_(anotherMatrix);
		System.out.println(isIsomorphic);

		return isIsomorphic;
	}

	/**
	 * Example17: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example17() {
		JunAdjacencyMatrix aMatrix = ExampleSimple();
		JunAdjacencyMatrix anotherMatrix = ExampleCycle();
		boolean isIsomorphic = aMatrix.isIsomorphicTo_(anotherMatrix);
		System.out.println(isIsomorphic);

		return !isIsomorphic;
	}

	/**
	 * Example20: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example20() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleTree();
		adjacencyMatrix.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print("|-- ");
				}
				System.out.println(node);
				return null;
			}
		});

		return true;
	}

	/**
	 * Example21: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example21() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleForest();
		adjacencyMatrix.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print("|-- ");
				}
				System.out.println(node);
				return null;
			}
		});

		return true;
	}

	/**
	 * Example22: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example22() {
		JunAdjacencyMatrix adjacencyMatrix = ExampleDirectory_withFiles_(3, true);
		if (adjacencyMatrix == null) {
			return false;
		}

		adjacencyMatrix.visitDepthFirst_nodeDo_arcDo_(null, new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				File aFile = (File) node;
				int level = ((Number) indent).intValue();
				if (level > 0) {
					for (int i = 1; i < level; i++) {
						System.out.print("|  ");
					}
					if (aFile.isDirectory()) {
						System.out.print("+- ");
					} else {
						System.out.print("|- ");
					}
				}
				System.out.println(aFile.getName());
				return null;
			}
		}, new StBlockClosure());

		return true;
	}

	/**
	 * Create a new simple adjacency matrix.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAdjacencyMatrix
	 * @category Examples
	 */
	protected static JunAdjacencyMatrix ExampleSimple() {
		JunAdjacencyMatrix adjacencyMatrix = new JunAdjacencyMatrix();
		adjacencyMatrix.connect_with_("abc", "def");
		adjacencyMatrix.connect_with_cost_("abc", "ghi", 3);
		adjacencyMatrix.connect_with_("abc", "jkl");
		adjacencyMatrix.connect_with_("def", "mno");
		adjacencyMatrix.connect_with_("ghi", "pqr");
		adjacencyMatrix.connect_with_("ghi", "stu");
		adjacencyMatrix.connect_with_("jkl", "vwx");
		adjacencyMatrix.connect_with_cost_("jkl", "yz0", 2);
		adjacencyMatrix.connect_with_cost_("stu", "123", 4);
		adjacencyMatrix.connect_with_("stu", "456");
		adjacencyMatrix.add_("789");
		return adjacencyMatrix;
	}

	/**
	 * Create a new cycle adjacency matrix.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAdjacencyMatrix
	 * @category Examples
	 */
	protected static JunAdjacencyMatrix ExampleCycle() {
		JunAdjacencyMatrix adjacencyMatrix = new JunAdjacencyMatrix();
		adjacencyMatrix.connect_with_("abc", "def");
		adjacencyMatrix.connect_with_cost_("abc", "ghi", 3);
		adjacencyMatrix.connect_with_("abc", "jkl");
		adjacencyMatrix.connect_with_("def", "mno");
		adjacencyMatrix.connect_with_("ghi", "pqr");
		adjacencyMatrix.connect_with_("ghi", "stu");
		adjacencyMatrix.connect_with_("jkl", "vwx");
		adjacencyMatrix.connect_with_cost_("jkl", "yz0", 2);
		adjacencyMatrix.connect_with_cost_("stu", "123", 4);
		adjacencyMatrix.connect_with_("stu", "456");
		adjacencyMatrix.connect_with_("789", "abc");
		adjacencyMatrix.connect_with_("123", "789");

		return adjacencyMatrix;
	}

	/**
	 * Create a new tree adjacency matrix.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAdjacencyMatrix
	 * @category Examples
	 */
	protected static JunAdjacencyMatrix ExampleTree() {
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				JunAdjacencyMatrix aMatrix = (JunAdjacencyMatrix) o1;
				Class aClass = (Class) o2;
				Class superClass = aClass.getSuperclass();
				if (superClass != null) {
					aMatrix.connect_with_(superClass.getName(), aClass.getName());
					this.value_value_(aMatrix, superClass);
				}
				return null;
			}
		};

		JunAdjacencyMatrix adjacencyMatrix = new JunAdjacencyMatrix();
		aBlock.value_value_(adjacencyMatrix, java.util.ArrayList.class);
		aBlock.value_value_(adjacencyMatrix, java.util.HashMap.class);
		aBlock.value_value_(adjacencyMatrix, java.util.HashSet.class);
		aBlock.value_value_(adjacencyMatrix, java.util.Hashtable.class);
		aBlock.value_value_(adjacencyMatrix, java.util.LinkedHashSet.class);
		aBlock.value_value_(adjacencyMatrix, java.util.LinkedHashMap.class);
		aBlock.value_value_(adjacencyMatrix, java.util.LinkedList.class);
		aBlock.value_value_(adjacencyMatrix, java.util.Stack.class);
		aBlock.value_value_(adjacencyMatrix, java.util.TreeMap.class);
		aBlock.value_value_(adjacencyMatrix, java.util.TreeSet.class);
		aBlock.value_value_(adjacencyMatrix, java.util.Vector.class);

		return adjacencyMatrix;
	}

	/**
	 * Create a new forest adjacency matrix.
	 * 
	 * @return jp.co.sra.jun.goodies.tables.JunAdjacencyMatrix
	 * @category Examples
	 */
	protected static JunAdjacencyMatrix ExampleForest() {
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				JunAdjacencyMatrix aMatrix = (JunAdjacencyMatrix) o1;
				Class aClass = (Class) o2;
				Class superClass = aClass.getSuperclass();
				if (superClass != java.lang.Object.class) {
					aMatrix.connect_with_(superClass.getName(), aClass.getName());
					this.value_value_(aMatrix, superClass);
				}
				return null;
			}
		};

		JunAdjacencyMatrix adjacencyMatrix = new JunAdjacencyMatrix();
		aBlock.value_value_(adjacencyMatrix, java.util.ArrayList.class);
		aBlock.value_value_(adjacencyMatrix, java.util.HashMap.class);
		aBlock.value_value_(adjacencyMatrix, java.util.HashSet.class);
		aBlock.value_value_(adjacencyMatrix, java.util.Hashtable.class);
		aBlock.value_value_(adjacencyMatrix, java.util.LinkedHashSet.class);
		aBlock.value_value_(adjacencyMatrix, java.util.LinkedHashMap.class);
		aBlock.value_value_(adjacencyMatrix, java.util.LinkedList.class);
		aBlock.value_value_(adjacencyMatrix, java.util.Stack.class);
		aBlock.value_value_(adjacencyMatrix, java.util.TreeMap.class);
		aBlock.value_value_(adjacencyMatrix, java.util.TreeSet.class);
		aBlock.value_value_(adjacencyMatrix, java.util.Vector.class);

		return adjacencyMatrix;
	}

	/**
	 * Create a new directory adjacency matrix.
	 * 
	 * @param diveLevel int
	 * @param withFiles boolean
	 * @return jp.co.sra.jun.goodies.tables.JunAdjacencyMatrix
	 * @category Examples
	 */
	protected static JunAdjacencyMatrix ExampleDirectory_withFiles_(final int diveLevel, final boolean withFiles) {
		File theDirectory = JunFileRequesterDialog.RequestDirectory($String("Select a directory."));
		if (theDirectory == null) {
			return null;
		}
		if (theDirectory.isDirectory() == false) {
			return null;
		}

		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object o1, Object o2, Object o3) {
				JunAdjacencyMatrix aMatrix = (JunAdjacencyMatrix) o1;
				File aDirectory = (File) o2;
				int level = ((Number) o3).intValue();
				if (level < diveLevel) {
					File[] files = aDirectory.listFiles();
					for (int i = 0; i < files.length; i++) {
						if (files[i].isDirectory()) {
							aMatrix.connect_with_(aDirectory, files[i]);
							this.value_value_value_(aMatrix, files[i], new Integer(level + 1));
						} else if (withFiles) {
							aMatrix.connect_with_(aDirectory, files[i]);
						}
					}
				}

				return null;
			}
		};

		JunAdjacencyMatrix adjacencyMatrix = new JunAdjacencyMatrix();
		aBlock.value_value_value_(adjacencyMatrix, theDirectory, new Integer(1));

		return adjacencyMatrix;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunAdjacencyMatrixTestExamples();
	}

}
