package jp.co.sra.jun.goodies.sound;

import java.util.Hashtable;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunSoundMeterModel class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/29 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSoundMeterModel.java,v 8.12 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSoundMeterModel extends JunApplicationModel {

	protected StValueHolder soundValueHolder;
	protected Hashtable soundLevelData;

	/**
	 * Answer the sound level data.
	 *
	 * @return java.util.Hashtable
	 * @category accessing
	 */
	public Hashtable soundLevelData() {
		if (soundLevelData == null) {
			soundLevelData = new Hashtable();
		}
		return soundLevelData;
	}

	/**
	 * Answer the sound level data at key.
	 *
	 * @param key java.lang.Object
	 * @return double[]
	 * @category accessing
	 */
	public double[] soundLevelDataAt_(Object key) {
		if (this.soundLevelData().containsKey(key)) {
			Object value = this.soundLevelData().get(key);
			if (value instanceof double[] && ((double[]) value).length >= 2) {
				return (double[]) value;
			}
		}
		return null;
	}

	/**
	 * Answer the sound value holder.
	 *
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category accessing
	 */
	public StValueHolder soundValueHolder() {
		return soundValueHolder;
	}

	/**
	 * Set the sound value holder to valueHolder.
	 *
	 * @param valueHolder jp.co.sra.smalltalk.StValueHolder
	 * @category accessing
	 */
	public void soundValueHolder_(StValueHolder valueHolder) {
		if (soundValueHolder != null) {
			soundValueHolder.removeDependent_(this);
		}
		soundValueHolder = valueHolder;
		if (soundValueHolder != null) {
			soundValueHolder.addDependent_(this);
		}
	}

	/**
	 * Add an association.
	 *
	 * @param anObject java.lang.Object
	 * @category adding
	 */
	public void add_(Object anObject) {
		if (anObject instanceof Object[]) {
			Object key = ((Object[]) anObject)[0];
			Object value = ((Object[]) anObject)[1];
			this.soundLevelData().put(key, value);
			this.changed_with_($("wave"), key);
			this.changed_with_($("level"), value);
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunSoundMeterViewAwt(this);
		} else {
			return new JunSoundMeterViewSwing(this);
		}
	}
	
	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	public String windowTitle() {
		return $String("Sound Meter");
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StObject#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("value")) {
			if (soundValueHolder != null) {
				this.add_(soundValueHolder.value());
			}
		} else {
			super.update_(evt);
		}
	}
}
